/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.job;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.groovy.util.Maps;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.RedirectFilter;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/tasks")
@Singleton
@Tag(name="TaskAPI")
public class TaskAPI
extends API {
    private static final Logger LOG = Log.logger(TaskAPI.class);
    private static final long NO_LIMIT = -1L;
    public static final String ACTION_CANCEL = "cancel";

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="status") String status, @QueryParam(value="ids") List<Long> ids, @QueryParam(value="limit") @DefaultValue(value="100") long limit, @QueryParam(value="page") String page) {
        Iterator iter;
        LOG.debug("Graph [{}] list tasks with status {}, ids {}, limit {}, page {}", new Object[]{graph, status, ids, limit, page});
        TaskScheduler scheduler = TaskAPI.graph(manager, graph).taskScheduler();
        if (!ids.isEmpty()) {
            E.checkArgument((status == null ? 1 : 0) != 0, (String)"Not support status when query task by ids, but got status='%s'", (Object[])new Object[]{status});
            E.checkArgument((page == null ? 1 : 0) != 0, (String)"Not support page when query task by ids, but got page='%s'", (Object[])new Object[]{page});
            limit = -1L;
            List idList = ids.stream().map(IdGenerator::of).collect(Collectors.toList());
            iter = scheduler.tasks(idList);
        } else {
            iter = status == null ? scheduler.tasks(null, limit, page) : scheduler.tasks(TaskAPI.parseStatus(status), limit, page);
        }
        List tasks = new ArrayList<Map>();
        while (iter.hasNext()) {
            tasks.add(((HugeTask)iter.next()).asMap(false));
        }
        if (limit != -1L && (long)tasks.size() > limit) {
            tasks = tasks.subList(0, (int)limit);
        }
        if (page == null) {
            return Maps.of((Object)"tasks", tasks);
        }
        return Maps.of((Object)"tasks", tasks, (Object)"page", (Object)PageInfo.pageInfo((Iterator)iter));
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Map<String, Object> get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") long id) {
        LOG.debug("Graph [{}] get task: {}", (Object)graph, (Object)id);
        TaskScheduler scheduler = TaskAPI.graph(manager, graph).taskScheduler();
        return scheduler.task(IdGenerator.of((long)id)).asMap();
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @RedirectFilter.RedirectMasterRole
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") long id, @DefaultValue(value="false") @QueryParam(value="force") boolean force) {
        LOG.debug("Graph [{}] delete task: {}", (Object)graph, (Object)id);
        TaskScheduler scheduler = TaskAPI.graph(manager, graph).taskScheduler();
        HugeTask task = scheduler.delete(IdGenerator.of((long)id), force);
        E.checkArgument((task != null ? 1 : 0) != 0, (String)"There is no task with id '%s'", (Object[])new Object[]{id});
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @StatusFilter.Status(value=202)
    @Produces(value={"application/json;charset=UTF-8"})
    @RedirectFilter.RedirectMasterRole
    public Map<String, Object> update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") long id, @QueryParam(value="action") String action) {
        LOG.debug("Graph [{}] cancel task: {}", (Object)graph, (Object)id);
        if (!ACTION_CANCEL.equals(action)) {
            throw new NotSupportedException(String.format("Not support action '%s'", action));
        }
        TaskScheduler scheduler = TaskAPI.graph(manager, graph).taskScheduler();
        HugeTask task = scheduler.task(IdGenerator.of((long)id));
        if (!task.completed() && !task.cancelling()) {
            scheduler.cancel(task);
            if (task.cancelling() || task.cancelled()) {
                return task.asMap();
            }
        }
        assert (task.completed() || task.cancelling());
        throw new BadRequestException(String.format("Can't cancel task '%s' which is completed or cancelling", id));
    }

    private static TaskStatus parseStatus(String status) {
        try {
            return TaskStatus.valueOf((String)status.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Status value must be in %s, but got '%s'", Arrays.asList(TaskStatus.values()), status));
        }
    }
}

