/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job;

import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.Job;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.TaskCallable;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;

public class JobBuilder<V> {
    private final HugeGraph graph;
    private String name;
    private String input;
    private Job<V> job;
    private Set<Id> dependencies;

    public static <T> JobBuilder<T> of(HugeGraph graph) {
        return new JobBuilder(graph);
    }

    public JobBuilder(HugeGraph graph) {
        this.graph = graph;
    }

    public JobBuilder<V> name(String name) {
        this.name = name;
        return this;
    }

    public JobBuilder<V> input(String input) {
        this.input = input;
        return this;
    }

    public JobBuilder<V> job(Job<V> job) {
        this.job = job;
        return this;
    }

    public JobBuilder<V> dependencies(Set<Id> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public HugeTask<V> schedule() {
        E.checkArgumentNotNull((Object)this.name, (String)"Job name can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull(this.job, (String)"Job callable can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)(this.job instanceof TaskCallable), (String)"Job must be instance of TaskCallable", (Object[])new Object[0]);
        this.graph.taskScheduler().checkRequirement("schedule");
        TaskCallable job = (TaskCallable)((Object)this.job);
        HugeTask task = new HugeTask(this.genTaskId(), null, job);
        task.type(this.job.type());
        task.name(this.name);
        if (this.input != null) {
            task.input(this.input);
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            for (Id depend : this.dependencies) {
                task.depends(depend);
            }
        }
        TaskScheduler scheduler = this.graph.taskScheduler();
        scheduler.schedule(task);
        return task;
    }

    private Id genTaskId() {
        return this.graph.getNextId(HugeType.TASK);
    }
}

