/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.exception.LimitExceedException;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.collection.IdSet;

public class Query
implements Cloneable {
    public static final long NO_LIMIT = Long.MAX_VALUE;
    public static final long COMMIT_BATCH = 500L;
    public static final long QUERY_BATCH = 100L;
    public static final long NO_CAPACITY = -1L;
    public static final long DEFAULT_CAPACITY = 800000L;
    private static final ThreadLocal<Long> CAPACITY_CONTEXT = new ThreadLocal();
    protected static final Query NONE = new Query(HugeType.UNKNOWN);
    private static final Set<Id> EMPTY_OLAP_PKS = ImmutableSet.of();
    private HugeType resultType;
    private Map<HugeKeys, Order> orders;
    private long offset;
    private long actualOffset;
    private long actualStoreOffset;
    private long limit;
    private long skipDegree;
    private String page;
    private long capacity;
    private boolean showHidden;
    private boolean showDeleting;
    private boolean showExpired;
    private boolean olap;
    private boolean withProperties;
    private OrderType orderType;
    private Set<Id> olapPks;
    private Aggregate aggregate;
    private Query originQuery;

    public Query(HugeType resultType) {
        this(resultType, null);
    }

    public Query(HugeType resultType, Query originQuery) {
        this.resultType = resultType;
        this.originQuery = originQuery;
        this.orders = null;
        this.offset = 0L;
        this.actualOffset = 0L;
        this.actualStoreOffset = 0L;
        this.limit = Long.MAX_VALUE;
        this.skipDegree = Long.MAX_VALUE;
        this.page = null;
        this.capacity = Query.defaultCapacity();
        this.showHidden = false;
        this.showDeleting = false;
        this.withProperties = true;
        this.orderType = OrderType.ORDER_STRICT;
        this.aggregate = null;
        this.showExpired = false;
        this.olap = false;
        this.olapPks = EMPTY_OLAP_PKS;
    }

    public void copyBasic(Query query) {
        E.checkNotNull((Object)query, (String)"query");
        this.offset = query.offset();
        this.limit = query.limit();
        this.skipDegree = query.skipDegree();
        this.page = query.page();
        this.capacity = query.capacity();
        this.showHidden = query.showHidden();
        this.showDeleting = query.showDeleting();
        this.withProperties = query.withProperties();
        this.orderType = query.orderType();
        this.aggregate = query.aggregate();
        this.showExpired = query.showExpired();
        this.olap = query.olap();
        if (query.orders != null) {
            this.orders(query.orders);
        }
    }

    public HugeType resultType() {
        return this.resultType;
    }

    public void resultType(HugeType resultType) {
        this.resultType = resultType;
    }

    public Query originQuery() {
        return this.originQuery;
    }

    public void setOriginQuery(Query query) {
        this.originQuery = query;
    }

    public Query rootOriginQuery() {
        Query root = this;
        while (root.originQuery != null) {
            root = root.originQuery;
        }
        return root;
    }

    protected void originQuery(Query originQuery) {
        this.originQuery = originQuery;
    }

    public Map<HugeKeys, Order> orders() {
        return Collections.unmodifiableMap(this.getOrNewOrders());
    }

    public void orders(Map<HugeKeys, Order> orders) {
        this.orders = InsertionOrderUtil.newMap(orders);
    }

    public void order(HugeKeys key, Order order) {
        this.getOrNewOrders().put(key, order);
    }

    protected Map<HugeKeys, Order> getOrNewOrders() {
        if (this.orders != null) {
            return this.orders;
        }
        this.orders = InsertionOrderUtil.newMap();
        return this.orders;
    }

    public long offset() {
        return this.offset;
    }

    public void offset(long offset) {
        E.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset %s", (Object[])new Object[]{offset});
        this.offset = offset;
    }

    public void copyOffset(Query parent) {
        assert (this.offset == 0L || this.offset == parent.offset);
        assert (this.actualOffset == 0L || this.actualOffset == parent.actualOffset);
        this.offset = parent.offset;
        this.actualOffset = parent.actualOffset;
    }

    public long actualOffset() {
        return this.actualOffset;
    }

    public void resetActualOffset() {
        this.actualOffset = 0L;
        this.actualStoreOffset = 0L;
    }

    public long goOffset(long offset) {
        E.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset value: %s", (Object[])new Object[]{offset});
        if (this.originQuery != null) {
            this.goParentOffset(offset);
        }
        return this.goSelfOffset(offset);
    }

    private void goParentOffset(long offset) {
        assert (offset >= 0L);
        Query parent = this.originQuery;
        while (parent != null) {
            parent.actualOffset += offset;
            parent = parent.originQuery;
        }
    }

    private long goSelfOffset(long offset) {
        assert (offset >= 0L);
        if (this.originQuery != null) {
            this.originQuery.goStoreOffsetBySubQuery(offset);
        }
        this.actualOffset += offset;
        return this.actualOffset;
    }

    private long goStoreOffsetBySubQuery(long offset) {
        Query parent = this.originQuery;
        while (parent != null) {
            parent.actualStoreOffset += offset;
            parent = parent.originQuery;
        }
        this.actualStoreOffset += offset;
        return this.actualStoreOffset;
    }

    public <T> Set<T> skipOffsetIfNeeded(Set<T> elems) {
        long fromIndex = this.offset() - this.actualOffset();
        if (fromIndex < 0L) {
            fromIndex = 0L;
        } else if (fromIndex > 0L) {
            this.goOffset(fromIndex);
        }
        E.checkArgument((fromIndex <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Offset must be <= 0x7fffffff, but got '%s'", (Object[])new Object[]{fromIndex});
        if (fromIndex >= (long)elems.size()) {
            return ImmutableSet.of();
        }
        long toIndex = this.total();
        if (this.noLimit() || toIndex > (long)elems.size()) {
            toIndex = elems.size();
        }
        if (fromIndex == 0L && toIndex == (long)elems.size()) {
            return elems;
        }
        assert (fromIndex < (long)elems.size());
        assert (toIndex <= (long)elems.size());
        return CollectionUtil.subSet(elems, (int)((int)fromIndex), (int)((int)toIndex));
    }

    public long remaining() {
        if (this.limit == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.total() - this.actualOffset();
    }

    public long total() {
        if (this.limit == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.offset + this.limit;
    }

    public long limit() {
        if (this.capacity != -1L) {
            E.checkArgument((this.limit == Long.MAX_VALUE || this.limit <= this.capacity ? 1 : 0) != 0, (String)"Invalid limit %s, must be <= capacity(%s)", (Object[])new Object[]{this.limit, this.capacity});
        }
        return this.limit;
    }

    public void limit(long limit) {
        E.checkArgument((limit >= 0L || limit == Long.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid limit %s", (Object[])new Object[]{limit});
        this.limit = limit;
    }

    public boolean noLimit() {
        return this.limit() == Long.MAX_VALUE;
    }

    public boolean noLimitAndOffset() {
        return this.limit() == Long.MAX_VALUE && this.offset() == 0L;
    }

    public boolean reachLimit(long count) {
        long limit = this.limit();
        if (limit == Long.MAX_VALUE) {
            return false;
        }
        return count >= limit + this.offset();
    }

    public long range(long start, long end) {
        long offset = this.offset();
        start = Math.max(start, offset);
        this.offset(start);
        if (end != -1L) {
            if (!this.noLimit()) {
                end = Math.min(end, offset + this.limit());
            } else assert (end < Long.MAX_VALUE);
            E.checkArgument((end >= start ? 1 : 0) != 0, (String)"Invalid range: [%s, %s)", (Object[])new Object[]{start, end});
            this.limit(end - start);
        } else assert (this.limit() <= Long.MAX_VALUE);
        return this.limit;
    }

    public String page() {
        if (this.page != null) {
            E.checkState((this.limit() != 0L ? 1 : 0) != 0, (String)"Can't set limit=0 when using paging", (Object[])new Object[0]);
            E.checkState((this.offset() == 0L ? 1 : 0) != 0, (String)"Can't set offset when using paging, but got '%s'", (Object[])new Object[]{this.offset()});
        }
        return this.page;
    }

    public String pageWithoutCheck() {
        return this.page;
    }

    public void page(String page) {
        this.page = page;
    }

    public boolean paging() {
        return this.page != null;
    }

    public void olap(boolean olap) {
        this.olap = olap;
    }

    public boolean olap() {
        return this.olap;
    }

    public void olapPks(Set<Id> olapPks) {
        for (Id olapPk : olapPks) {
            this.olapPk(olapPk);
        }
    }

    public void olapPk(Id olapPk) {
        if (this.olapPks == EMPTY_OLAP_PKS) {
            this.olapPks = new IdSet(CollectionType.EC);
        }
        this.olapPks.add(olapPk);
    }

    public Set<Id> olapPks() {
        return this.olapPks;
    }

    public long capacity() {
        return this.capacity;
    }

    public void capacity(long capacity) {
        this.capacity = capacity;
    }

    public boolean bigCapacity() {
        return this.capacity == -1L || this.capacity > 800000L;
    }

    public void checkCapacity(long count) throws LimitExceedException {
        if (this.capacity != -1L && count > this.capacity) {
            int MAX_CHARS = 256;
            Object query = this.toString();
            if (((String)query).length() > 256) {
                query = ((String)query).substring(0, 256) + "...";
            }
            throw new LimitExceedException("Too many records(must <= %s) for the query: %s", this.capacity, query);
        }
    }

    public Aggregate aggregate() {
        return this.aggregate;
    }

    public Aggregate aggregateNotNull() {
        E.checkArgument((this.aggregate != null ? 1 : 0) != 0, (String)"The aggregate must be set for number query", (Object[])new Object[0]);
        return this.aggregate;
    }

    public void aggregate(Aggregate.AggregateFunc func, String property) {
        this.aggregate = new Aggregate(func, property);
    }

    public void aggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public boolean showHidden() {
        return this.showHidden;
    }

    public void showHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public boolean showDeleting() {
        return this.showDeleting;
    }

    public void showDeleting(boolean showDeleting) {
        this.showDeleting = showDeleting;
    }

    public long skipDegree() {
        return this.skipDegree;
    }

    public void skipDegree(long skipDegree) {
        this.skipDegree = skipDegree;
    }

    public boolean withProperties() {
        return this.withProperties;
    }

    public void withProperties(boolean withProperties) {
        this.withProperties = withProperties;
    }

    public OrderType orderType() {
        return this.orderType;
    }

    public void orderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public boolean showExpired() {
        return this.showExpired;
    }

    public void showExpired(boolean showExpired) {
        this.showExpired = showExpired;
    }

    public Collection<Id> ids() {
        return ImmutableList.of();
    }

    public Collection<Condition> conditions() {
        return ImmutableList.of();
    }

    public int idsSize() {
        return 0;
    }

    public int conditionsSize() {
        return 0;
    }

    public boolean empty() {
        return this.idsSize() == 0 && this.conditionsSize() == 0;
    }

    public boolean test(HugeElement element) {
        return true;
    }

    public Query copy() {
        try {
            return (Query)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BackendException(e);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Query)) {
            return false;
        }
        Query other = (Query)object;
        return this.resultType.equals(other.resultType) && this.orders().equals(other.orders()) && this.offset == other.offset && this.limit == other.limit && Objects.equals(this.page, other.page) && this.ids().equals(other.ids()) && this.conditions().equals(other.conditions()) && this.withProperties == other.withProperties;
    }

    public int hashCode() {
        return this.resultType.hashCode() ^ this.orders().hashCode() ^ Long.hashCode(this.offset) ^ Long.hashCode(this.limit) ^ Objects.hashCode(this.page) ^ this.ids().hashCode() ^ this.conditions().hashCode() ^ Boolean.hashCode(this.withProperties);
    }

    public String toString() {
        Map pairs = InsertionOrderUtil.newMap();
        if (this.page != null) {
            pairs.put("page", String.format("'%s'", this.page));
        }
        if (this.offset != 0L) {
            pairs.put("offset", this.offset);
        }
        if (this.limit != Long.MAX_VALUE) {
            pairs.put("limit", this.limit);
        }
        if (!this.orders().isEmpty()) {
            pairs.put("order by", this.orders());
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("`Query ");
        if (this.aggregate != null) {
            sb.append(this.aggregate);
        } else {
            sb.append('*');
        }
        sb.append(" from ").append(this.resultType);
        for (Map.Entry entry : pairs.entrySet()) {
            sb.append(' ').append((String)entry.getKey()).append(' ').append(entry.getValue()).append(',');
        }
        if (!pairs.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (!this.empty()) {
            sb.append(" where");
        }
        if (!this.ids().isEmpty()) {
            sb.append(" id in ").append(this.ids());
        }
        if (!this.conditions().isEmpty()) {
            if (!this.ids().isEmpty()) {
                sb.append(" and");
            }
            sb.append(" ").append(this.conditions());
        }
        sb.append('`');
        return sb.toString();
    }

    public static long defaultCapacity(long capacity) {
        Long old = CAPACITY_CONTEXT.get();
        CAPACITY_CONTEXT.set(capacity);
        return old != null ? old : 800000L;
    }

    public static long defaultCapacity() {
        Long capacity = CAPACITY_CONTEXT.get();
        return capacity != null ? capacity : 800000L;
    }

    public static void checkForceCapacity(long count) throws LimitExceedException {
        if (count > 800000L) {
            throw new LimitExceedException("Too many records(must <= %s) for one query", 800000L);
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static enum OrderType {
        ORDER_NONE,
        ORDER_WITHIN_VERTEX,
        ORDER_STRICT;

    }
}

