/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.HugeGroup;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.type.define.DataType;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;

public class HugeAccess
extends SchemaDefine.Relationship {
    private static final long serialVersionUID = -7644007602408729385L;
    private final Id group;
    private final Id target;
    private HugePermission permission;
    private String description;

    public HugeAccess(Id group, Id target) {
        this(group, target, null);
    }

    public HugeAccess(Id group, Id target, HugePermission permission) {
        this.group = group;
        this.target = target;
        this.permission = permission;
        this.description = null;
    }

    @Override
    public ResourceType type() {
        return ResourceType.GRANT;
    }

    @Override
    public String label() {
        return P.ACCESS;
    }

    @Override
    public String sourceLabel() {
        return P.GROUP;
    }

    @Override
    public String targetLabel() {
        return P.TARGET;
    }

    @Override
    public Id source() {
        return this.group;
    }

    @Override
    public Id target() {
        return this.target;
    }

    public HugePermission permission() {
        return this.permission;
    }

    public void permission(HugePermission permission) {
        this.permission = permission;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("HugeAccess(%s->%s)%s", this.group, this.target, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~access_permission": {
                this.permission = HugePermission.fromCode((Byte)value);
                break;
            }
            case "~access_description": {
                this.description = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        E.checkState((this.permission != null ? 1 : 0) != 0, (String)"Access permission can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(12);
        list.add(T.label);
        list.add(P.ACCESS);
        list.add("~access_permission");
        list.add(this.permission.code());
        if (this.description != null) {
            list.add("~access_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((this.permission != null ? 1 : 0) != 0, (String)"Access permission can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)P.GROUP), this.group);
        map.put(Graph.Hidden.unHide((String)P.TARGET), this.target);
        map.put(Graph.Hidden.unHide((String)"~access_permission"), this.permission);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~access_description"), this.description);
        }
        return super.asMap(map);
    }

    public static HugeAccess fromEdge(Edge edge) {
        HugeAccess access = new HugeAccess((Id)edge.outVertex().id(), (Id)edge.inVertex().id());
        return HugeAccess.fromEdge(edge, access);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static HugeAccess fromMap(Map<String, Object> map) {
        HugeAccess access = new HugeAccess(null, null, null);
        return HugeAccess.fromMap(map, access);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.ACCESS);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existEdgeLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            EdgeLabel label = (EdgeLabel)this.schema().edgeLabel(this.label).sourceLabel(P.GROUP).targetLabel(P.TARGET).properties(properties).nullableKeys("~access_description").sortKeys("~access_permission").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addEdgeLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~access_permission", DataType.BYTE));
            props.add(this.createPropertyKey("~access_description"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String ACCESS = Graph.Hidden.hide((String)"access");
        public static final String LABEL = T.label.getAccessor();
        public static final String GROUP = HugeGroup.P.GROUP;
        public static final String TARGET = HugeTarget.P.TARGET;
        public static final String PERMISSION = "~access_permission";
        public static final String DESCRIPTION = "~access_description";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"access_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

