/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.util.HgMapCache;

public class HgMapCache<K, V> {
    private final Map<K, V> cache = new ConcurrentHashMap();
    private final Supplier<Boolean> expiry;

    private HgMapCache(Supplier<Boolean> expiredPolicy) {
        this.expiry = expiredPolicy;
    }

    public static HgMapCache expiredOf(long interval) {
        return new HgMapCache((Supplier)new CycleIntervalPolicy(interval));
    }

    private boolean isExpired() {
        if (this.expiry != null && ((Boolean)this.expiry.get()).booleanValue()) {
            this.cache.clear();
            return true;
        }
        return false;
    }

    public void put(K key, V value) {
        if (key == null || value == null) {
            return;
        }
        this.cache.put(key, value);
    }

    public V get(K key) {
        if (this.isExpired()) {
            return null;
        }
        return this.cache.get(key);
    }

    public void removeAll() {
        this.cache.clear();
    }

    public boolean remove(K key) {
        if (key != null) {
            this.cache.remove(key);
            return true;
        }
        return false;
    }

    public Map<K, V> getAll() {
        return this.cache;
    }
}

