/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.raft.RaftStateListener;

public interface ServiceGrpc
extends RaftStateListener {
    public static final ConcurrentHashMap<String, ManagedChannel> channels = new ConcurrentHashMap();

    default public Pdpb.ResponseHeader getResponseHeader(PDException e) {
        Pdpb.Error error = Pdpb.Error.newBuilder().setTypeValue(e.getErrorCode()).setMessage(e.getMessage()).build();
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
        return header;
    }

    default public Pdpb.ResponseHeader getResponseHeader() {
        Pdpb.Error error = Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.OK).build();
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
        return header;
    }

    default public boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    default public <ReqT, RespT> void redirectToLeader(ManagedChannel channel, MethodDescriptor<ReqT, RespT> method, ReqT req, StreamObserver<RespT> observer) {
        try {
            String address = RaftEngine.getInstance().getLeaderGrpcAddress();
            channel = (ManagedChannel)channels.get(address);
            if (channel == null || channel.isTerminated() || channel.isShutdown()) {
                Class<ServiceGrpc> clazz = ServiceGrpc.class;
                // MONITORENTER : org.apache.hugegraph.pd.service.ServiceGrpc.class
                channel = (ManagedChannel)channels.get(address);
                if (channel == null || channel.isTerminated() || channel.isShutdown()) {
                    while (channel != null && channel.isShutdown() && !channel.isTerminated()) {
                        channel.awaitTermination(50L, TimeUnit.MILLISECONDS);
                    }
                    ManagedChannel c = ManagedChannelBuilder.forTarget((String)address).usePlaintext().build();
                    channels.put(address, c);
                    channel = c;
                }
                // MONITOREXIT : clazz
            }
            ClientCalls.asyncUnaryCall((ClientCall)channel.newCall(method, CallOptions.DEFAULT), req, observer);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public <ReqT, RespT> void redirectToLeader(MethodDescriptor<ReqT, RespT> method, ReqT req, StreamObserver<RespT> observer) {
        this.redirectToLeader(null, method, req, observer);
    }

    default public void onRaftLeaderChanged() {
    }
}

