/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import com.alipay.sofa.jraft.JRaftUtils;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.pd.ConfigService;
import org.apache.hugegraph.pd.IdService;
import org.apache.hugegraph.pd.LogService;
import org.apache.hugegraph.pd.PartitionInstructionListener;
import org.apache.hugegraph.pd.PartitionService;
import org.apache.hugegraph.pd.PartitionStatusListener;
import org.apache.hugegraph.pd.ShardGroupStatusListener;
import org.apache.hugegraph.pd.StoreMonitorDataService;
import org.apache.hugegraph.pd.StoreNodeService;
import org.apache.hugegraph.pd.StoreStatusListener;
import org.apache.hugegraph.pd.TaskScheduleService;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.PDGrpc;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.watch.NodeEventType;
import org.apache.hugegraph.pd.pulse.PDPulseSubject;
import org.apache.hugegraph.pd.pulse.PulseListener;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.raft.RaftStateListener;
import org.apache.hugegraph.pd.service.ServiceGrpc;
import org.apache.hugegraph.pd.util.grpc.StreamObserverUtil;
import org.apache.hugegraph.pd.watch.PDWatchSubject;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@GRpcService
public class PDService
extends PDGrpc.PDImplBase
implements ServiceGrpc,
RaftStateListener {
    private static final Logger log = LoggerFactory.getLogger(PDService.class);
    static String TASK_ID_KEY = "task_id";
    private final Pdpb.ResponseHeader okHeader = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.OK)).build();
    private final Map<String, ManagedChannel> channelMap = new ConcurrentHashMap();
    @Autowired
    private PDConfig pdConfig;
    private StoreNodeService storeNodeService;
    private PartitionService partitionService;
    private TaskScheduleService taskService;
    private IdService idService;
    private ConfigService configService;
    private LogService logService;
    private StoreMonitorDataService storeMonitorDataService;
    private ManagedChannel channel;

    private Pdpb.ResponseHeader newErrorHeader(int errorCode, String errorMsg) {
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setTypeValue(errorCode).setMessage(errorMsg)).build();
        return header;
    }

    private Pdpb.ResponseHeader newErrorHeader(PDException e) {
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setTypeValue(e.getErrorCode()).setMessage(e.getMessage())).build();
        return header;
    }

    public StoreNodeService getStoreNodeService() {
        return this.storeNodeService;
    }

    public PartitionService getPartitionService() {
        return this.partitionService;
    }

    public TaskScheduleService getTaskService() {
        return this.taskService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public StoreMonitorDataService getStoreMonitorDataService() {
        return this.storeMonitorDataService;
    }

    public LogService getLogService() {
        return this.logService;
    }

    @PostConstruct
    public void init() throws PDException {
        log.info("PDService init\u2026\u2026\u2026\u2026 {}", (Object)this.pdConfig);
        this.configService = new ConfigService(this.pdConfig);
        RaftEngine.getInstance().addStateListener((RaftStateListener)this);
        RaftEngine.getInstance().addStateListener((RaftStateListener)this.configService);
        RaftEngine.getInstance().init(this.pdConfig.getRaft());
        this.storeNodeService = new StoreNodeService(this.pdConfig);
        this.partitionService = new PartitionService(this.pdConfig, this.storeNodeService);
        this.taskService = new TaskScheduleService(this.pdConfig, this.storeNodeService, this.partitionService);
        this.idService = new IdService(this.pdConfig);
        this.logService = new LogService(this.pdConfig);
        this.storeMonitorDataService = new StoreMonitorDataService(this.pdConfig);
        RaftEngine.getInstance().addStateListener((RaftStateListener)this.partitionService);
        this.pdConfig.setIdService(this.idService);
        PDPulseSubject.listenPartitionHeartbeat((PulseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.partitionService.addInstructionListener((PartitionInstructionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.partitionService.addStatusListener((PartitionStatusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.storeNodeService.addShardGroupStatusListener((ShardGroupStatusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.storeNodeService.addStatusListener((StoreStatusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.storeNodeService.init(this.partitionService);
        this.partitionService.init();
        this.taskService.init();
    }

    public void registerStore(Pdpb.RegisterStoreRequest request, StreamObserver<Pdpb.RegisterStoreResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getRegisterStoreMethod(), (Object)request, observer);
            return;
        }
        Pdpb.RegisterStoreResponse response = null;
        try {
            Metapb.Store store = this.storeNodeService.register(request.getStore());
            response = Pdpb.RegisterStoreResponse.newBuilder().setHeader(this.okHeader).setStoreId(store.getId()).build();
        }
        catch (PDException e) {
            response = Pdpb.RegisterStoreResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("registerStore exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getStore(Pdpb.GetStoreRequest request, StreamObserver<Pdpb.GetStoreResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetStoreMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetStoreResponse response = null;
        try {
            Metapb.Store store = this.storeNodeService.getStore(request.getStoreId());
            response = Pdpb.GetStoreResponse.newBuilder().setHeader(this.okHeader).setStore(store).build();
        }
        catch (PDException e) {
            response = Pdpb.GetStoreResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("{} getStore exception: {}", (Object)StreamObserverUtil.getRemoteIP(observer), (Object)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void setStore(Pdpb.SetStoreRequest request, StreamObserver<Pdpb.SetStoreResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSetStoreMethod(), (Object)request, observer);
            return;
        }
        Pdpb.SetStoreResponse response = null;
        try {
            Metapb.ClusterStats stats;
            Metapb.StoreState state = request.getStore().getState();
            Long storeId = request.getStore().getId();
            Metapb.Store lastStore = this.storeNodeService.getStore(request.getStore().getId());
            if (lastStore == null) {
                throw new PDException(101, String.format("Store id %d does not exist!", storeId));
            }
            if (Metapb.StoreState.Up.equals((Object)state) && !Metapb.StoreState.Pending.equals((Object)lastStore.getState())) {
                throw new PDException(113, "only stores in Pending state can be set to Up!");
            }
            if (state.equals((Object)Metapb.StoreState.Offline) && (stats = this.storeNodeService.getClusterStats()).getState() != Metapb.ClusterState.Cluster_OK) {
                Pdpb.ResponseHeader errorHeader = this.newErrorHeader(-1, "can not offline node when cluster state is not normal ");
                response = Pdpb.SetStoreResponse.newBuilder().setHeader(errorHeader).build();
                observer.onNext((Object)response);
                observer.onCompleted();
                return;
            }
            this.logService.insertLog("NODE_CHANGE", "GRPC", (GeneratedMessageV3)request.getStore());
            if (state.equals((Object)Metapb.StoreState.Up)) {
                int cores = 0;
                long id = request.getStore().getId();
                List stores = this.storeNodeService.getStores();
                int nodeCount = 0;
                for (Metapb.Store store : stores) {
                    if (store.getId() == id) {
                        cores = store.getCores();
                    }
                    if (!store.getState().equals((Object)Metapb.StoreState.Up)) continue;
                    ++nodeCount;
                }
            }
            Metapb.Store store = request.getStore();
            if (state.equals((Object)Metapb.StoreState.Tombstone)) {
                List activeStores = this.storeNodeService.getActiveStores();
                if (lastStore.getState() == Metapb.StoreState.Up && activeStores.size() - 1 < this.pdConfig.getMinStoreCount()) {
                    throw new PDException(105, "The number of active stores is less then " + this.pdConfig.getMinStoreCount());
                }
                if (!this.storeNodeService.checkStoreCanOffline(request.getStore())) {
                    throw new PDException(105, "check activeStores or online shardsList size");
                }
                if (lastStore.getState() == Metapb.StoreState.Exiting) {
                    throw new PDException(1010, "Downline is in progress, do not resubmit");
                }
                Map resultMap = this.taskService.canAllPartitionsMovedOut(lastStore);
                if (((Boolean)resultMap.get("flag")).booleanValue()) {
                    if (resultMap.get("current_store_is_online") != null && ((Boolean)resultMap.get("current_store_is_online")).booleanValue()) {
                        log.info("updateStore removeActiveStores store {}", (Object)store.getId());
                        store = Metapb.Store.newBuilder((Metapb.Store)lastStore).setState(Metapb.StoreState.Exiting).build();
                        this.taskService.movePartitions((Map)resultMap.get("movedPartitions"));
                    }
                } else {
                    throw new PDException(113, "the resources on other stores may be not enough to store the partitions of current store!");
                }
            }
            store = this.storeNodeService.updateStore(store);
            response = Pdpb.SetStoreResponse.newBuilder().setHeader(this.okHeader).setStore(store).build();
        }
        catch (PDException e) {
            response = Pdpb.SetStoreResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("setStore exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getAllStores(Pdpb.GetAllStoresRequest request, StreamObserver<Pdpb.GetAllStoresResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetAllStoresMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetAllStoresResponse response = null;
        try {
            List stores = null;
            stores = request.getExcludeOfflineStores() ? this.storeNodeService.getActiveStores(request.getGraphName()) : this.storeNodeService.getStores(request.getGraphName());
            response = Pdpb.GetAllStoresResponse.newBuilder().setHeader(this.okHeader).addAllStores((Iterable)stores).build();
        }
        catch (PDException e) {
            response = Pdpb.GetAllStoresResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getAllStores exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void storeHeartbeat(Pdpb.StoreHeartbeatRequest request, StreamObserver<Pdpb.StoreHeartbeatResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getStoreHeartbeatMethod(), (Object)request, observer);
            return;
        }
        Metapb.StoreStats stats = request.getStats();
        if (this.pdConfig.getStore().isMonitorDataEnabled()) {
            try {
                this.storeMonitorDataService.saveMonitorData(stats);
            }
            catch (PDException e) {
                log.error("save status failed, state:{}", (Object)stats);
            }
            stats = Metapb.StoreStats.newBuilder().mergeFrom(request.getStats()).clearField(Metapb.StoreStats.getDescriptor().findFieldByName("system_metrics")).build();
        }
        Pdpb.StoreHeartbeatResponse response = null;
        try {
            Metapb.ClusterStats clusterStats = this.storeNodeService.heartBeat(stats);
            response = Pdpb.StoreHeartbeatResponse.newBuilder().setHeader(this.okHeader).setClusterStats(clusterStats).build();
        }
        catch (PDException e) {
            response = Pdpb.StoreHeartbeatResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("storeHeartbeat exception: ", (Throwable)e);
        }
        catch (Exception e2) {
            response = Pdpb.StoreHeartbeatResponse.newBuilder().setHeader(this.newErrorHeader(1, e2.getMessage())).build();
            log.error("storeHeartbeat exception: ", (Throwable)e2);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartition(Pdpb.GetPartitionRequest request, StreamObserver<Pdpb.GetPartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPartitionMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetPartitionResponse response = null;
        try {
            Metapb.PartitionShard partShard = this.partitionService.getPartitionShard(request.getGraphName(), request.getKey().toByteArray());
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.okHeader).setPartition(partShard.getPartition()).setLeader(partShard.getLeader()).build();
        }
        catch (PDException e) {
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getPartition exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartitionByCode(Pdpb.GetPartitionByCodeRequest request, StreamObserver<Pdpb.GetPartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPartitionByCodeMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetPartitionResponse response = null;
        try {
            Metapb.PartitionShard partShard = this.partitionService.getPartitionByCode(request.getGraphName(), request.getCode());
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.okHeader).setPartition(partShard.getPartition()).setLeader(partShard.getLeader()).build();
        }
        catch (PDException e) {
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getPartitionByCode exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartitionByID(Pdpb.GetPartitionByIDRequest request, StreamObserver<Pdpb.GetPartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPartitionByIDMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetPartitionResponse response = null;
        try {
            Metapb.PartitionShard partShard = this.partitionService.getPartitionShardById(request.getGraphName(), request.getPartitionId());
            if (partShard == null) {
                throw new PDException(103, String.format("partition: %s-%s not found", request.getGraphName(), request.getPartitionId()));
            }
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.okHeader).setPartition(partShard.getPartition()).setLeader(partShard.getLeader()).build();
        }
        catch (PDException e) {
            response = Pdpb.GetPartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getPartitionByID exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updatePartition(Pdpb.UpdatePartitionRequest request, StreamObserver<Pdpb.UpdatePartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getUpdatePartitionMethod(), (Object)request, observer);
            return;
        }
        Pdpb.UpdatePartitionResponse response = null;
        try {
            this.partitionService.updatePartition(request.getPartitionList());
            response = Pdpb.UpdatePartitionResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.UpdatePartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("update partition exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void delPartition(Pdpb.DelPartitionRequest request, StreamObserver<Pdpb.DelPartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getDelPartitionMethod(), (Object)request, observer);
            return;
        }
        Pdpb.DelPartitionResponse response = null;
        try {
            Metapb.Partition partition = this.partitionService.getPartitionById(request.getGraphName(), request.getPartitionId());
            if (partition != null) {
                this.partitionService.removePartition(request.getGraphName(), request.getPartitionId());
                response = Pdpb.DelPartitionResponse.newBuilder().setHeader(this.okHeader).setPartition(partition).build();
            } else {
                response = Pdpb.DelPartitionResponse.newBuilder().setHeader(this.okHeader).build();
            }
        }
        catch (PDException e) {
            response = Pdpb.DelPartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("delPartition exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void scanPartitions(Pdpb.ScanPartitionsRequest request, StreamObserver<Pdpb.ScanPartitionsResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getScanPartitionsMethod(), (Object)request, observer);
            return;
        }
        Pdpb.ScanPartitionsResponse response = null;
        try {
            List partShards = this.partitionService.scanPartitions(request.getGraphName(), request.getStartKey().toByteArray(), request.getEndKey().toByteArray());
            response = Pdpb.ScanPartitionsResponse.newBuilder().setHeader(this.okHeader).addAllPartitions((Iterable)partShards).build();
        }
        catch (PDException e) {
            response = Pdpb.ScanPartitionsResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("scanPartitions exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getGraph(Pdpb.GetGraphRequest request, StreamObserver<Pdpb.GetGraphResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetGraphMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetGraphResponse response = null;
        String graphName = request.getGraphName();
        try {
            Metapb.Graph graph = this.partitionService.getGraph(graphName);
            if (graph != null) {
                response = Pdpb.GetGraphResponse.newBuilder().setHeader(this.okHeader).setGraph(graph).build();
            } else {
                Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.NOT_FOUND).build()).build();
                response = Pdpb.GetGraphResponse.newBuilder().setHeader(header).build();
            }
        }
        catch (PDException e) {
            response = Pdpb.GetGraphResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getGraph exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void setGraph(Pdpb.SetGraphRequest request, StreamObserver<Pdpb.SetGraphResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSetGraphMethod(), (Object)request, observer);
            return;
        }
        Pdpb.SetGraphResponse response = null;
        Metapb.Graph graph = request.getGraph();
        try {
            graph = this.partitionService.updateGraph(graph);
            response = Pdpb.SetGraphResponse.newBuilder().setHeader(this.okHeader).setGraph(graph).build();
        }
        catch (PDException e) {
            log.error("setGraph exception: ", (Throwable)e);
            response = Pdpb.SetGraphResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void delGraph(Pdpb.DelGraphRequest request, StreamObserver<Pdpb.DelGraphResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getDelGraphMethod(), (Object)request, observer);
            return;
        }
        Pdpb.DelGraphResponse response = null;
        String graphName = request.getGraphName();
        try {
            Metapb.Graph graph = this.partitionService.delGraph(graphName);
            if (graph != null) {
                response = Pdpb.DelGraphResponse.newBuilder().setHeader(this.okHeader).setGraph(graph).build();
            }
        }
        catch (PDException e) {
            response = Pdpb.DelGraphResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getGraph exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void queryPartitions(Pdpb.QueryPartitionsRequest request, StreamObserver<Pdpb.QueryPartitionsResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getQueryPartitionsMethod(), (Object)request, observer);
            return;
        }
        Metapb.PartitionQuery query = request.getQuery();
        List partitions = this.partitionService.getPartitions(query.getGraphName());
        ArrayList<Metapb.Partition> result = new ArrayList<Metapb.Partition>();
        if (!CollectionUtils.isEmpty((Collection)partitions)) {
            for (Metapb.Partition partition : partitions) {
                if (query.hasPartitionId() && partition.getId() != query.getPartitionId() || query.hasGraphName() && !partition.getGraphName().equals(query.getGraphName())) continue;
                long storeId = query.getStoreId();
                if (query.hasStoreId() && query.getStoreId() != 0L) {
                    try {
                        this.storeNodeService.getShardGroup(partition.getId()).getShardsList().forEach(shard -> {
                            if (shard.getStoreId() == storeId) {
                                result.add(partition);
                            }
                        });
                    }
                    catch (PDException e) {
                        log.error("query partitions error, req:{}, error:{}", (Object)request, (Object)e.getMessage());
                    }
                    continue;
                }
                result.add(partition);
            }
        }
        Pdpb.QueryPartitionsResponse response = Pdpb.QueryPartitionsResponse.newBuilder().addAllPartitions(result).build();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getId(Pdpb.GetIdRequest request, StreamObserver<Pdpb.GetIdResponse> responseObserver) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetIdMethod(), (Object)request, responseObserver);
            return;
        }
        long id = 0L;
        try {
            id = this.idService.getId(request.getKey(), request.getDelta());
        }
        catch (PDException e) {
            responseObserver.onError((Throwable)e);
            log.error("getId exception: ", (Throwable)e);
            return;
        }
        Pdpb.GetIdResponse response = Pdpb.GetIdResponse.newBuilder().setId(id).setDelta(request.getDelta()).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void resetId(Pdpb.ResetIdRequest request, StreamObserver<Pdpb.ResetIdResponse> responseObserver) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getResetIdMethod(), (Object)request, responseObserver);
            return;
        }
        try {
            this.idService.resetId(request.getKey());
        }
        catch (PDException e) {
            responseObserver.onError((Throwable)e);
            log.error("getId exception: ", (Throwable)e);
            return;
        }
        Pdpb.ResetIdResponse response = Pdpb.ResetIdResponse.newBuilder().setResult(0).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getMembers(Pdpb.GetMembersRequest request, StreamObserver<Pdpb.GetMembersResponse> observer) {
        Pdpb.GetMembersResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetMembersMethod(), (Object)request, observer);
            return;
        }
        try {
            response = Pdpb.GetMembersResponse.newBuilder().addAllMembers((Iterable)RaftEngine.getInstance().getMembers()).setLeader(RaftEngine.getInstance().getLocalMember()).build();
        }
        catch (Exception e) {
            log.error("getMembers exception: ", (Throwable)e);
            response = Pdpb.GetMembersResponse.newBuilder().setHeader(this.newErrorHeader(-1, e.getMessage())).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getStoreStatus(Pdpb.GetAllStoresRequest request, StreamObserver<Pdpb.GetAllStoresResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetStoreStatusMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetAllStoresResponse response = null;
        try {
            List stores = null;
            stores = this.storeNodeService.getStoreStatus(request.getExcludeOfflineStores());
            response = Pdpb.GetAllStoresResponse.newBuilder().setHeader(this.okHeader).addAllStores((Iterable)stores).build();
        }
        catch (PDException e) {
            response = Pdpb.GetAllStoresResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
            log.error("getAllStores exception: ", (Throwable)e);
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPDConfig(Pdpb.GetPDConfigRequest request, StreamObserver<Pdpb.GetPDConfigResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPDConfigMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetPDConfigResponse response = null;
        try {
            Metapb.PDConfig pdConfig = null;
            pdConfig = this.configService.getPDConfig(request.getVersion());
            response = Pdpb.GetPDConfigResponse.newBuilder().setHeader(this.okHeader).setPdConfig(pdConfig).build();
        }
        catch (PDException e) {
            response = Pdpb.GetPDConfigResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void setPDConfig(Pdpb.SetPDConfigRequest request, StreamObserver<Pdpb.SetPDConfigResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSetPDConfigMethod(), (Object)request, observer);
            return;
        }
        Pdpb.SetPDConfigResponse response = null;
        try {
            if (request.getPdConfig().getShardCount() % 2 != 1) {
                throw new PDException(112, "shard count must be an odd number!");
            }
            if (request.getPdConfig().getShardCount() > this.storeNodeService.getActiveStores().size()) {
                throw new PDException(112, "shard count can't be greater than the number of active stores!");
            }
            int oldShardCount = this.configService.getPDConfig().getShardCount();
            int newShardCount = request.getPdConfig().getShardCount();
            if (newShardCount > oldShardCount) {
                if (!this.isResourceEnough(oldShardCount, newShardCount)) {
                    throw new PDException(112, "There is not enough disk space left!");
                }
                if (!this.checkShardCount(newShardCount)) {
                    throw new PDException(112, "the cluster can't support so many shard count!");
                }
            }
            this.configService.setPDConfig(request.getPdConfig());
            response = Pdpb.SetPDConfigResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.SetPDConfigResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getGraphSpace(Pdpb.GetGraphSpaceRequest request, StreamObserver<Pdpb.GetGraphSpaceResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetGraphSpaceMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetGraphSpaceResponse response = null;
        try {
            List graphSpaces = null;
            graphSpaces = this.configService.getGraphSpace(request.getGraphSpaceName());
            response = Pdpb.GetGraphSpaceResponse.newBuilder().setHeader(this.okHeader).addAllGraphSpace((Iterable)graphSpaces).build();
        }
        catch (PDException e) {
            response = Pdpb.GetGraphSpaceResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void setGraphSpace(Pdpb.SetGraphSpaceRequest request, StreamObserver<Pdpb.SetGraphSpaceResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSetGraphSpaceMethod(), (Object)request, observer);
            return;
        }
        Pdpb.SetGraphSpaceResponse response = null;
        try {
            this.configService.setGraphSpace(request.getGraphSpace());
            response = Pdpb.SetGraphSpaceResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.SetGraphSpaceResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void splitData(Pdpb.SplitDataRequest request, StreamObserver<Pdpb.SplitDataResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSplitDataMethod(), (Object)request, observer);
            return;
        }
        this.logService.insertLog("PARTITION_CHANGE", "splitData", (GeneratedMessageV3)request);
        Pdpb.SplitDataResponse response = null;
        try {
            this.taskService.splitPartition(request.getMode(), request.getParamList());
            response = Pdpb.SplitDataResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("splitData exception {}", (Throwable)e);
            response = Pdpb.SplitDataResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void splitGraphData(Pdpb.SplitGraphDataRequest request, StreamObserver<Pdpb.SplitDataResponse> observer) {
        Pdpb.SplitDataResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getSplitGraphDataMethod(), (Object)request, observer);
            return;
        }
        this.logService.insertLog("PARTITION_CHANGE", "splitGraphData", (GeneratedMessageV3)request);
        try {
            this.partitionService.splitPartition(this.partitionService.getGraph(request.getGraphName()), request.getToCount());
            response = Pdpb.SplitDataResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("splitGraphData exception {}", (Throwable)e);
            response = Pdpb.SplitDataResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void movePartition(Pdpb.MovePartitionRequest request, StreamObserver<Pdpb.MovePartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getMovePartitionMethod(), (Object)request, observer);
            return;
        }
        this.logService.insertLog("PARTITION_CHANGE", "balanceData", (GeneratedMessageV3)request);
        Pdpb.MovePartitionResponse response = null;
        try {
            this.taskService.patrolPartitions();
            this.taskService.balancePartitionShard();
            response = Pdpb.MovePartitionResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("transferData exception {}", (Throwable)e);
            response = Pdpb.MovePartitionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getClusterStats(Pdpb.GetClusterStatsRequest request, StreamObserver<Pdpb.GetClusterStatsResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetClusterStatsMethod(), (Object)request, observer);
            return;
        }
        Pdpb.GetClusterStatsResponse response = null;
        response = Pdpb.GetClusterStatsResponse.newBuilder().setHeader(this.okHeader).setCluster(this.storeNodeService.getClusterStats()).build();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void reportTask(Pdpb.ReportTaskRequest request, StreamObserver<Pdpb.ReportTaskResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getReportTaskMethod(), (Object)request, observer);
            return;
        }
        try {
            this.taskService.reportTask(request.getTask());
        }
        catch (Exception e) {
            log.error("PDService.reportTask {}", (Throwable)e);
        }
        Pdpb.ReportTaskResponse response = null;
        response = Pdpb.ReportTaskResponse.newBuilder().setHeader(this.okHeader).build();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartitionStats(Pdpb.GetPartitionStatsRequest request, StreamObserver<Pdpb.GetPartitionStatsResponse> observer) {
        Pdpb.GetPartitionStatsResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPartitionStatsMethod(), (Object)request, observer);
            return;
        }
        try {
            Metapb.PartitionStats stats = this.partitionService.getPartitionStats(request.getGraphName(), request.getPartitionId());
            response = Pdpb.GetPartitionStatsResponse.newBuilder().setHeader(this.okHeader).setPartitionStats(stats).build();
        }
        catch (PDException e) {
            log.error("getPartitionStats exception {}", (Throwable)e);
            response = Pdpb.GetPartitionStatsResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }

    public void changePeerList(Pdpb.ChangePeerListRequest request, StreamObserver<Pdpb.getChangePeerListResponse> observer) {
        Pdpb.getChangePeerListResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getChangePeerListMethod(), (Object)request, observer);
            return;
        }
        try {
            Status status = RaftEngine.getInstance().changePeerList(request.getPeerList());
            Pdpb.ResponseHeader responseHeader = status.isOk() ? this.okHeader : this.newErrorHeader(status.getCode(), status.getErrorMsg());
            response = Pdpb.getChangePeerListResponse.newBuilder().setHeader(responseHeader).build();
        }
        catch (Exception e) {
            log.error("changePeerList exception: ", (Throwable)e);
            response = Pdpb.getChangePeerListResponse.newBuilder().setHeader(this.newErrorHeader(-1, e.getMessage())).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public synchronized void onRaftLeaderChanged() {
        log.info("onLeaderChanged");
        try {
            PDWatchSubject.notifyNodeChange((NodeEventType)NodeEventType.NODE_EVENT_TYPE_PD_LEADER_CHANGE, (String)RaftEngine.getInstance().getLeaderGrpcAddress(), (long)0L);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("failed to notice client", (Throwable)e);
        }
    }

    public void balanceLeaders(Pdpb.BalanceLeadersRequest request, StreamObserver<Pdpb.BalanceLeadersResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getBalanceLeadersMethod(), (Object)request, observer);
            return;
        }
        this.logService.insertLog("PARTITION_CHANGE", "balanceLeaders", (GeneratedMessageV3)request);
        Pdpb.BalanceLeadersResponse response = null;
        try {
            this.taskService.balancePartitionLeader(true);
            response = Pdpb.BalanceLeadersResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("balance Leaders exception: ", (Throwable)e);
            response = Pdpb.BalanceLeadersResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void putLicense(Pdpb.PutLicenseRequest request, StreamObserver<Pdpb.PutLicenseResponse> responseObserver) {
        Pdpb.PutLicenseResponse response = null;
        boolean moved = false;
        String bakPath = this.pdConfig.getLicensePath() + "-bak";
        File bakFile = new File(bakPath);
        File licenseFile = new File(this.pdConfig.getLicensePath());
        try {
            byte[] content = request.getContent().toByteArray();
            if (licenseFile.exists()) {
                if (bakFile.exists()) {
                    FileUtils.deleteQuietly((File)bakFile);
                }
                FileUtils.moveFile((File)licenseFile, (File)bakFile);
                moved = true;
            }
            FileUtils.writeByteArrayToFile((File)licenseFile, (byte[])content, (boolean)false);
        }
        catch (Exception e) {
            log.error("putLicense with error:", (Throwable)e);
            if (moved) {
                try {
                    FileUtils.moveFile((File)bakFile, (File)licenseFile);
                }
                catch (IOException ex) {
                    log.error("failed to restore the license file:", (Throwable)ex);
                }
            }
            Pdpb.ResponseHeader header = this.newErrorHeader(107, e.getMessage());
            response = Pdpb.PutLicenseResponse.newBuilder().setHeader(header).build();
        }
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    public void delStore(Pdpb.DetStoreRequest request, StreamObserver<Pdpb.DetStoreResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getDelStoreMethod(), (Object)request, observer);
            return;
        }
        long storeId = request.getStoreId();
        Pdpb.DetStoreResponse response = null;
        try {
            Metapb.Store store = this.storeNodeService.getStore(storeId);
            if (Metapb.StoreState.Tombstone != store.getState()) {
                throw new PDException(111, "the store can't be deleted, please check store state!");
            }
            this.storeNodeService.removeStore(Long.valueOf(storeId));
            response = Pdpb.DetStoreResponse.newBuilder().setHeader(this.okHeader).setStore(store).build();
        }
        catch (PDException e) {
            log.error("delete store exception: {}", (Throwable)e);
            response = Pdpb.DetStoreResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    private boolean checkShardCount(int newShardCount) {
        try {
            int maxCount = this.pdConfig.getPartition().getMaxShardsPerStore() * this.storeNodeService.getActiveStores().size() / this.pdConfig.getConfigService().getPartitionCount();
            if (newShardCount > maxCount) {
                log.error("new shard count :{} exceed current cluster max shard count {}", (Object)newShardCount, (Object)maxCount);
                return false;
            }
        }
        catch (Exception e) {
            log.error("checkShardCount: {}", (Object)e.getMessage());
        }
        return true;
    }

    public boolean isResourceEnough(int oldShardCount, int newShardCount) {
        try {
            float expansionRatio = newShardCount / oldShardCount;
            long currentDataSize = 0L;
            long newDataSize = 0L;
            long totalAvaible = 0L;
            for (Metapb.Store store : this.storeNodeService.getStores()) {
                List graphStatsList = store.getStats().getGraphStatsList();
                for (Metapb.GraphStats graphStats : graphStatsList) {
                    currentDataSize += graphStats.getApproximateSize();
                }
            }
            newDataSize = (long)Math.ceil((float)currentDataSize * expansionRatio);
            List activeStores = this.storeNodeService.getActiveStores();
            for (Metapb.Store store : activeStores) {
                Metapb.StoreStats storeStats = store.getStats();
                totalAvaible += storeStats.getAvailable();
            }
            return totalAvaible > newDataSize - currentDataSize;
        }
        catch (PDException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dbCompaction(Pdpb.DbCompactionRequest request, StreamObserver<Pdpb.DbCompactionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getDbCompactionMethod(), (Object)request, observer);
            return;
        }
        this.logService.insertLog("TASK", "dbCompaction", (GeneratedMessageV3)request);
        Pdpb.DbCompactionResponse response = null;
        try {
            log.info("dbCompaction call dbCompaction");
            this.taskService.dbCompaction(request.getTableName());
            response = Pdpb.DbCompactionResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("dbCompaction exception {}", (Throwable)e);
            response = Pdpb.DbCompactionResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void combineCluster(Pdpb.CombineClusterRequest request, StreamObserver<Pdpb.CombineClusterResponse> observer) {
        Pdpb.CombineClusterResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getCombineClusterMethod(), (Object)request, observer);
            return;
        }
        try {
            this.partitionService.combinePartition(request.getToCount());
            response = Pdpb.CombineClusterResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.CombineClusterResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void combineGraph(Pdpb.CombineGraphRequest request, StreamObserver<Pdpb.CombineGraphResponse> observer) {
        Pdpb.CombineGraphResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getCombineGraphMethod(), (Object)request, observer);
            return;
        }
        try {
            this.partitionService.combineGraphPartition(request.getGraphName(), request.getToCount());
            response = Pdpb.CombineGraphResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.CombineGraphResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void deleteShardGroup(Pdpb.DeleteShardGroupRequest request, StreamObserver<Pdpb.DeleteShardGroupResponse> observer) {
        Pdpb.DeleteShardGroupResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getDeleteShardGroupMethod(), (Object)request, observer);
            return;
        }
        try {
            this.storeNodeService.deleteShardGroup(request.getGroupId());
            response = Pdpb.DeleteShardGroupResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            response = Pdpb.DeleteShardGroupResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getShardGroup(Pdpb.GetShardGroupRequest request, StreamObserver<Pdpb.GetShardGroupResponse> observer) {
        Pdpb.GetShardGroupResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetShardGroupMethod(), (Object)request, observer);
            return;
        }
        try {
            Metapb.ShardGroup shardGroup = this.storeNodeService.getShardGroup(request.getGroupId());
            response = Pdpb.GetShardGroupResponse.newBuilder().setHeader(this.okHeader).setShardGroup(shardGroup).build();
        }
        catch (PDException e) {
            log.error("getPartitionStats exception", (Throwable)e);
            response = Pdpb.GetShardGroupResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updateShardGroup(Pdpb.UpdateShardGroupRequest request, StreamObserver<Pdpb.UpdateShardGroupResponse> responseObserver) {
        Pdpb.UpdateShardGroupResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getUpdateShardGroupMethod(), (Object)request, responseObserver);
            return;
        }
        try {
            Metapb.ShardGroup group = request.getShardGroup();
            this.storeNodeService.updateShardGroup(group.getId(), group.getShardsList(), group.getVersion(), group.getConfVer());
            response = Pdpb.UpdateShardGroupResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("updateShardGroup exception, ", (Throwable)e);
            response = Pdpb.UpdateShardGroupResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void updateShardGroupOp(Pdpb.ChangeShardRequest request, StreamObserver<Pdpb.ChangeShardResponse> observer) {
        Pdpb.ChangeShardResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getUpdateShardGroupOpMethod(), (Object)request, observer);
            return;
        }
        try {
            this.storeNodeService.shardGroupOp(request.getGroupId(), request.getShardsList());
            response = Pdpb.ChangeShardResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("changeShard exception, ", (Throwable)e);
            response = Pdpb.ChangeShardResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void changeShard(Pdpb.ChangeShardRequest request, StreamObserver<Pdpb.ChangeShardResponse> observer) {
        Pdpb.ChangeShardResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getChangeShardMethod(), (Object)request, observer);
            return;
        }
        try {
            this.partitionService.changeShard(request.getGroupId(), request.getShardsList());
            response = Pdpb.ChangeShardResponse.newBuilder().setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("changeShard exception, ", (Throwable)e);
            response = Pdpb.ChangeShardResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void updatePdRaft(Pdpb.UpdatePdRaftRequest request, StreamObserver<Pdpb.UpdatePdRaftResponse> observer) {
        Pdpb.UpdatePdRaftResponse response;
        block7: {
            Node node;
            List list;
            block6: {
                block5: {
                    if (!this.isLeader()) {
                        this.redirectToLeader(PDGrpc.getUpdatePdRaftMethod(), (Object)request, observer);
                        return;
                    }
                    list = this.parseConfig(request.getConfig());
                    log.info("update raft request: {}, list: {}", (Object)request.getConfig(), (Object)list);
                    response = Pdpb.UpdatePdRaftResponse.newBuilder().setHeader(this.okHeader).build();
                    List leaders = list.stream().filter(s -> ((String)s.getKey()).equals("leader")).collect(Collectors.toList());
                    node = RaftEngine.getInstance().getRaftNode();
                    if (leaders.size() != 1) break block5;
                    PeerId leaderPeer = (PeerId)((KVPair)leaders.get(0)).getValue();
                    HashSet peers = new HashSet(node.listPeers());
                    if (this.peerEquals(leaderPeer, node.getLeaderId())) break block6;
                    if (peers.contains(leaderPeer)) {
                        log.info("updatePdRaft, transfer to {}", (Object)leaderPeer);
                        node.transferLeadershipTo(leaderPeer);
                    } else {
                        response = Pdpb.UpdatePdRaftResponse.newBuilder().setHeader(this.newErrorHeader(6667, "new leader not in raft peers")).build();
                    }
                    break block7;
                }
                response = Pdpb.UpdatePdRaftResponse.newBuilder().setHeader(this.newErrorHeader(6666, "leader size != 1")).build();
                break block7;
            }
            Configuration config = new Configuration();
            for (KVPair peer : list) {
                if (!((String)peer.getKey()).equals("learner")) {
                    config.addPeer((PeerId)peer.getValue());
                    continue;
                }
                config.addLearner((PeerId)peer.getValue());
            }
            log.info("pd raft update with new config: {}", (Object)config);
            node.changePeers(config, status -> {
                if (status.isOk()) {
                    log.info("updatePdRaft, change peers success");
                } else {
                    log.error("changePeers status: {}, msg:{}, code: {}, raft error:{}", new Object[]{status, status.getErrorMsg(), status.getCode(), status.getRaftError()});
                }
            });
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getCache(Pdpb.GetGraphRequest request, StreamObserver<Pdpb.CacheResponse> observer) {
        Pdpb.CacheResponse response;
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetCacheMethod(), (Object)request, observer);
            return;
        }
        try {
            response = Pdpb.CacheResponse.newBuilder().mergeFrom(this.storeNodeService.getCache()).setHeader(this.okHeader).build();
        }
        catch (PDException e) {
            log.error("get cache exception, ", (Throwable)e);
            response = Pdpb.CacheResponse.newBuilder().setHeader(this.newErrorHeader(e)).build();
        }
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getPartitions(Pdpb.GetGraphRequest request, StreamObserver<Pdpb.CachePartitionResponse> observer) {
        if (!this.isLeader()) {
            this.redirectToLeader(PDGrpc.getGetPartitionsMethod(), (Object)request, observer);
            return;
        }
        List partitions = this.partitionService.getPartitions(request.getGraphName());
        Pdpb.CachePartitionResponse response = Pdpb.CachePartitionResponse.newBuilder().addAllPartitions((Iterable)partitions).setHeader(this.okHeader).build();
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    private List<KVPair<String, PeerId>> parseConfig(String conf) {
        LinkedList<KVPair<String, PeerId>> result = new LinkedList<KVPair<String, PeerId>>();
        if (conf != null && conf.length() > 0) {
            for (String s : conf.split(",")) {
                if (s.endsWith("/leader")) {
                    result.add((KVPair<String, PeerId>)new KVPair((Object)"leader", (Object)JRaftUtils.getPeerId((String)s.substring(0, s.length() - 7))));
                    continue;
                }
                if (s.endsWith("/learner")) {
                    result.add((KVPair<String, PeerId>)new KVPair((Object)"learner", (Object)JRaftUtils.getPeerId((String)s.substring(0, s.length() - 8))));
                    continue;
                }
                if (s.endsWith("/follower")) {
                    result.add((KVPair<String, PeerId>)new KVPair((Object)"follower", (Object)JRaftUtils.getPeerId((String)s.substring(0, s.length() - 9))));
                    continue;
                }
                result.add((KVPair<String, PeerId>)new KVPair((Object)"follower", (Object)JRaftUtils.getPeerId((String)s)));
            }
        }
        return result;
    }

    private boolean peerEquals(PeerId p1, PeerId p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return Objects.equals(p1.getIp(), p2.getIp()) && Objects.equals(p1.getPort(), p2.getPort());
    }
}

