/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.dist;

import com.sun.management.ThreadMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class MemoryMonitor {
    private static final Logger LOG = Log.logger(MemoryMonitor.class);
    private final double MEMORY_MONITOR_THRESHOLD;
    private final int MEMORY_MONITOR_DETECT_PERIOD;
    private final ScheduledExecutorService scheduler;

    public MemoryMonitor(String restServerConf) {
        HugeConfig restServerConfig = new HugeConfig(restServerConf);
        this.MEMORY_MONITOR_THRESHOLD = (Double)restServerConfig.get((TypedOption)ServerOptions.JVM_MEMORY_MONITOR_THRESHOLD);
        this.MEMORY_MONITOR_DETECT_PERIOD = (Integer)restServerConfig.get((TypedOption)ServerOptions.JVM_MEMORY_MONITOR_DETECT_PERIOD);
        this.scheduler = ExecutorUtil.newScheduledThreadPool((String)"memory-monitor-thread-%d");
    }

    private void runMemoryDetect() {
        double memoryUsagePercentage = this.getMemoryUsageRatio();
        if (memoryUsagePercentage > this.MEMORY_MONITOR_THRESHOLD) {
            LOG.warn("JVM memory usage is '{}', exceeding the threshold of '{}'.", (Object)memoryUsagePercentage, (Object)this.MEMORY_MONITOR_THRESHOLD);
            System.gc();
            LOG.warn("Trigger System.gc()");
            double doubleCheckUsage = this.getMemoryUsageRatio();
            if (doubleCheckUsage > this.MEMORY_MONITOR_THRESHOLD) {
                LOG.warn("JVM memory usage is '{}', exceeding the threshold of '{}'.", (Object)doubleCheckUsage, (Object)this.MEMORY_MONITOR_THRESHOLD);
                this.interruptHighestMemoryThread();
            }
        }
    }

    private double getMemoryUsageRatio() {
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return (double)heapMemoryUsage.getUsed() / (double)heapMemoryUsage.getMax();
    }

    private Thread getHighestMemoryThread() {
        long highestMemory = 0L;
        Thread highestThread = null;
        ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            long threadMemory;
            if (thread.getState() != Thread.State.RUNNABLE || thread.getName() == null || !thread.getName().startsWith("grizzly-http-server-") || (threadMemory = threadMXBean.getThreadAllocatedBytes(thread.getId())) <= highestMemory) continue;
            highestMemory = threadMemory;
            highestThread = thread;
        }
        return highestThread;
    }

    private void interruptHighestMemoryThread() {
        Thread targetThread = this.getHighestMemoryThread();
        if (targetThread != null) {
            targetThread.interrupt();
            LOG.warn("Send interrupt to '{}' thread", (Object)targetThread.getName());
        }
    }

    public void start() {
        if (this.MEMORY_MONITOR_THRESHOLD >= 1.0) {
            LOG.info("Invalid parameter, MEMORY_MONITOR_THRESHOLD should \u2264 1.0.");
            return;
        }
        this.scheduler.scheduleAtFixedRate(this::runMemoryDetect, 0L, this.MEMORY_MONITOR_DETECT_PERIOD, TimeUnit.MILLISECONDS);
        LOG.info("Memory monitoring started.");
    }

    public void stop() {
        if (this.MEMORY_MONITOR_THRESHOLD >= 1.0) {
            return;
        }
        this.scheduler.shutdownNow();
        LOG.info("Memory monitoring stopped.");
    }
}

