/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Characters;

public class AnyOfMatcher
extends AbstractMatcher {
    public final Characters characters;

    public AnyOfMatcher(Characters characters) {
        super(Preconditions.checkArgNotNull(characters, "characters").toString());
        Preconditions.checkArgument(!characters.equals(Characters.NONE));
        this.characters = characters;
    }

    public boolean match(MatcherContext matcherContext) {
        if (!this.characters.contains(matcherContext.getCurrentChar())) {
            return false;
        }
        matcherContext.advanceIndex(1);
        matcherContext.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> matcherVisitor) {
        Preconditions.checkArgNotNull(matcherVisitor, "visitor");
        return matcherVisitor.visit(this);
    }
}

