/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf.pojo;

import org.ansj.app.crf.Model;

public class Element {
    public char name;
    private int tag = -1;
    public int len = 1;
    public String nature;
    public float[] tagScore;
    public int[] from;

    public Element(char name) {
        this.name = name;
    }

    public Element(Character name, int tag) {
        this.name = name.charValue();
        this.tag = tag;
    }

    public int getTag() {
        return this.tag;
    }

    public Element updateTag(int tag) {
        this.tag = tag;
        return this;
    }

    public Element updateNature(String nature) {
        this.nature = nature;
        return this;
    }

    public String toString() {
        return this.name + "/" + this.len + "/" + this.tag;
    }

    public char getName() {
        return this.name;
    }

    public String nameStr() {
        if (this.name >= '\u0082' && this.name < '\u008c') {
            return "num" + (this.name - 130);
        }
        if (this.name >= '\u008c' && this.name < '\u0096') {
            return "en" + (this.name - 140);
        }
        return String.valueOf(this.name);
    }

    public void maxFrom(Model model, Element element) {
        if (this.from == null) {
            this.from = new int[4];
        }
        float[] pTagScore = element.tagScore;
        for (int i = 0; i < 4; ++i) {
            float maxValue = 0.0f;
            for (int j = 0; j < 4; ++j) {
                float value = pTagScore[j] + this.tagScore[i] + model.tagRate(j, i);
                if (this.tagScore.length > 4) {
                    value += this.tagScore[4 + j * 4 + i];
                }
                if (!(value > maxValue)) continue;
                maxValue = value;
                this.from[i] = j;
            }
            this.tagScore[i] = maxValue;
        }
    }
}

