/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.postgresql;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.mysql.MysqlSessions;
import org.apache.hugegraph.backend.store.mysql.MysqlStoreProvider;
import org.apache.hugegraph.backend.store.mysql.MysqlTable;
import org.apache.hugegraph.backend.store.postgresql.PostgresqlStore;
import org.apache.hugegraph.backend.store.postgresql.PostgresqlTables;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PostgresqlStoreProvider
extends MysqlStoreProvider {
    private static final Logger LOG = Log.logger(PostgresqlStoreProvider.class);

    protected BackendStore newSchemaStore(HugeConfig config, String store) {
        return new PostgresqlSchemaStore((BackendStoreProvider)this, this.database(), store);
    }

    protected BackendStore newGraphStore(HugeConfig config, String store) {
        return new PostgresqlGraphStore((BackendStoreProvider)this, this.database(), store);
    }

    protected BackendStore newSystemStore(HugeConfig config, String store) {
        return new PostgresqlSystemStore((BackendStoreProvider)this, this.database(), store);
    }

    public String type() {
        return "postgresql";
    }

    public String driverVersion() {
        return "1.9";
    }

    public static class PostgresqlSystemStore
    extends PostgresqlGraphStore {
        private final PostgresqlTables.Meta meta = new PostgresqlTables.Meta();

        public PostgresqlSystemStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
        }

        public void init() {
            super.init();
            this.checkOpened();
            MysqlSessions.Session session = this.session(HugeType.META);
            String driverVersion = this.provider().driverVersion();
            this.meta.writeVersion(session, driverVersion);
            LOG.info("Write down the backend version: {}", (Object)driverVersion);
        }

        public String storedVersion() {
            super.init();
            this.checkOpened();
            MysqlSessions.Session session = this.session(HugeType.META);
            return this.meta.readVersion(session);
        }

        protected Collection<MysqlTable> tables() {
            ArrayList<MysqlTable> tables = new ArrayList<MysqlTable>(super.tables());
            tables.add(this.meta);
            return tables;
        }
    }

    public static class PostgresqlGraphStore
    extends PostgresqlStore {
        public PostgresqlGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, new PostgresqlTables.Vertex(store));
            this.registerTableManager(HugeType.EDGE_OUT, new PostgresqlTables.Edge(store, Directions.OUT));
            this.registerTableManager(HugeType.EDGE_IN, new PostgresqlTables.Edge(store, Directions.IN));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new PostgresqlTables.SecondaryIndex(store));
            this.registerTableManager(HugeType.RANGE_INT_INDEX, new PostgresqlTables.RangeIntIndex(store));
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, new PostgresqlTables.RangeFloatIndex(store));
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, new PostgresqlTables.RangeLongIndex(store));
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, new PostgresqlTables.RangeDoubleIndex(store));
            this.registerTableManager(HugeType.SEARCH_INDEX, new PostgresqlTables.SearchIndex(store));
            this.registerTableManager(HugeType.SHARD_INDEX, new PostgresqlTables.ShardIndex(store));
            this.registerTableManager(HugeType.UNIQUE_INDEX, new PostgresqlTables.UniqueIndex(store));
        }

        public boolean isSchemaStore() {
            return false;
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("PostgresqlGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long increment) {
            throw new UnsupportedOperationException("PostgresqlGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("PostgresqlGraphStore.getCounter()");
        }
    }

    public static class PostgresqlSchemaStore
    extends PostgresqlStore {
        private final PostgresqlTables.Counters counters = new PostgresqlTables.Counters();

        public PostgresqlSchemaStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, new PostgresqlTables.VertexLabel());
            this.registerTableManager(HugeType.EDGE_LABEL, new PostgresqlTables.EdgeLabel());
            this.registerTableManager(HugeType.PROPERTY_KEY, new PostgresqlTables.PropertyKey());
            this.registerTableManager(HugeType.INDEX_LABEL, new PostgresqlTables.IndexLabel());
        }

        protected Collection<MysqlTable> tables() {
            ArrayList<MysqlTable> tables = new ArrayList<MysqlTable>(super.tables());
            tables.add(this.counters);
            return tables;
        }

        public void increaseCounter(HugeType type, long increment) {
            this.checkOpened();
            MysqlSessions.Session session = this.session(type);
            this.counters.increaseCounter(session, type, increment);
        }

        public long getCounter(HugeType type) {
            this.checkOpened();
            MysqlSessions.Session session = this.session(type);
            return this.counters.getCounter(session, type);
        }

        public boolean isSchemaStore() {
            return true;
        }
    }
}

