/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import com.alipay.remoting.util.StringUtils;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.utils.Charsets;
import org.slf4j.Logger;

@Provider
@PreMatching
@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    public static final String BASIC_AUTH_PREFIX = "Basic ";
    public static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final Logger LOG = Log.logger(AuthenticationFilter.class);
    private static final List<String> WHITE_API_LIST = ImmutableList.of((Object)"auth/login", (Object)"versions", (Object)"openapi.json");
    private static String whiteIpStatus;
    private static final String STRING_WHITE_IP_LIST = "whiteiplist";
    private static final String STRING_ENABLE = "enable";
    @Context
    private jakarta.inject.Provider<GraphManager> managerProvider;
    @Context
    private jakarta.inject.Provider<Request> requestProvider;
    @Context
    private jakarta.inject.Provider<HugeConfig> configProvider;

    public void filter(ContainerRequestContext context) throws IOException {
        if (AuthenticationFilter.isWhiteAPI(context)) {
            return;
        }
        HugeAuthenticator.User user = this.authenticate(context);
        Authorizer authorizer = new Authorizer(user, context.getUriInfo());
        context.setSecurityContext((SecurityContext)authorizer);
    }

    protected HugeAuthenticator.User authenticate(ContainerRequestContext context) {
        GraphManager manager = (GraphManager)this.managerProvider.get();
        E.checkState((manager != null ? 1 : 0) != 0, (String)"Context GraphManager is absent", (Object[])new Object[0]);
        if (!manager.requireAuthentication()) {
            return HugeAuthenticator.User.ANONYMOUS;
        }
        Request request = (Request)this.requestProvider.get();
        String peer = null;
        String path = null;
        if (request != null) {
            peer = request.getRemoteAddr() + ":" + request.getRemotePort();
            path = request.getRequestURI();
        }
        if (whiteIpStatus == null) {
            whiteIpStatus = (String)((HugeConfig)this.configProvider.get()).get(ServerOptions.WHITE_IP_STATUS);
        }
        if (Objects.equals(whiteIpStatus, STRING_ENABLE) && request != null) {
            peer = request.getRemoteAddr() + ":" + request.getRemotePort();
            path = request.getRequestURI();
            String remoteIp = request.getRemoteAddr();
            Set whiteIpList = manager.authManager().listWhiteIPs();
            boolean whiteIpEnabled = manager.authManager().getWhiteIpStatus();
            if (!path.contains(STRING_WHITE_IP_LIST) && whiteIpEnabled && !whiteIpList.contains(remoteIp)) {
                throw new ForbiddenException(String.format("Remote ip '%s' is not permitted", remoteIp));
            }
        }
        HashMap<String, String> credentials = new HashMap<String, String>();
        String auth = context.getHeaderString("Authorization");
        if (auth == null) {
            throw new NotAuthorizedException("Authentication credentials are required", (Object)"Missing authentication credentials", new Object[0]);
        }
        if (auth.startsWith(BASIC_AUTH_PREFIX)) {
            auth = auth.substring(BASIC_AUTH_PREFIX.length());
            String[] values = (auth = new String(DatatypeConverter.parseBase64Binary((String)auth), Charsets.ASCII_CHARSET)).split(":");
            if (values.length != 2) {
                throw new BadRequestException("Invalid syntax for username and password");
            }
            String username = values[0];
            String password = values[1];
            if (StringUtils.isEmpty((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
                throw new BadRequestException("Invalid syntax for username and password");
            }
            credentials.put("username", username);
            credentials.put("password", password);
        } else if (auth.startsWith(BEARER_TOKEN_PREFIX)) {
            String token = auth.substring(BEARER_TOKEN_PREFIX.length());
            credentials.put("token", token);
        } else {
            throw new BadRequestException("Only HTTP Basic or Bearer authentication is supported");
        }
        credentials.put("address", peer);
        credentials.put("path", path);
        try {
            return manager.authenticate(credentials);
        }
        catch (AuthenticationException e) {
            throw new NotAuthorizedException("Authentication failed", (Object)e.getMessage(), new Object[0]);
        }
    }

    public static boolean isWhiteAPI(ContainerRequestContext context) {
        String path = context.getUriInfo().getPath();
        for (String whiteApi : WHITE_API_LIST) {
            if (!path.endsWith(whiteApi)) continue;
            return true;
        }
        return false;
    }

    public static class Authorizer
    implements SecurityContext {
        private final UriInfo uri;
        private final HugeAuthenticator.User user;
        private final Principal principal;

        public Authorizer(HugeAuthenticator.User user, UriInfo uri) {
            E.checkNotNull((Object)((Object)user), (String)"user");
            E.checkNotNull((Object)uri, (String)"uri");
            this.uri = uri;
            this.user = user;
            this.principal = new UserPrincipal();
        }

        public String username() {
            return this.user.username();
        }

        public RolePermission role() {
            return this.user.role();
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String required) {
            if (required.equals("$dynamic")) {
                return true;
            }
            return this.matchPermission(required);
        }

        public boolean isSecure() {
            return "https".equals(this.uri.getRequestUri().getScheme());
        }

        public String getAuthenticationScheme() {
            return "BASIC";
        }

        private boolean matchPermission(String required) {
            boolean valid;
            HugeAuthenticator.RequiredPerm requiredPerm;
            if (!required.startsWith("$owner")) {
                requiredPerm = new HugeAuthenticator.RequiredPerm();
                requiredPerm.owner(required);
            } else {
                requiredPerm = HugeAuthenticator.RequiredPerm.fromPermission(required);
                String owner = requiredPerm.owner();
                if (owner.startsWith("$")) {
                    int prefixLen = "$".length();
                    assert (owner.length() > prefixLen);
                    owner = owner.substring(prefixLen);
                    owner = this.getPathParameter(owner);
                    requiredPerm.owner(owner);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Verify permission {} {} for user '{}' with role {}", new Object[]{requiredPerm.action().string(), requiredPerm.resourceObject(), this.user.username(), this.user.role()});
            }
            if (!(valid = HugeAuthenticator.RolePerm.match(this.role(), requiredPerm)) && LOG.isInfoEnabled() && !required.equals("admin")) {
                LOG.info("User '{}' is denied to {} {}", new Object[]{this.user.username(), requiredPerm.action().string(), requiredPerm.resourceObject()});
            }
            return valid;
        }

        private String getPathParameter(String key) {
            List params = (List)this.uri.getPathParameters().get((Object)key);
            E.checkState((params != null && params.size() == 1 ? 1 : 0) != 0, (String)"There is no matched path parameter: '%s'", (Object[])new Object[]{key});
            return (String)params.get(0);
        }

        private final class UserPrincipal
        implements Principal {
            private UserPrincipal() {
            }

            @Override
            public String getName() {
                return Authorizer.this.user.getName();
            }

            @Override
            public String toString() {
                return Authorizer.this.user.toString();
            }

            @Override
            public int hashCode() {
                return Authorizer.this.user.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return Authorizer.this.user.equals(obj);
            }
        }
    }
}

