/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

public class RestClientConfig {
    private String user;
    private String password;
    private String token;
    private Integer timeout;
    private Integer maxConns;
    private Integer maxConnsPerRoute;
    private Integer idleTime = 30;
    private Integer maxIdleConns = 5;
    private String trustStoreFile;
    private String trustStorePassword;

    RestClientConfig(String user, String password, String token, Integer timeout, Integer maxConns, Integer maxConnsPerRoute, Integer idleTime, Integer maxIdleConns, String trustStoreFile, String trustStorePassword) {
        this.user = user;
        this.password = password;
        this.token = token;
        this.timeout = timeout;
        this.maxConns = maxConns;
        this.maxConnsPerRoute = maxConnsPerRoute;
        this.idleTime = idleTime;
        this.maxIdleConns = maxIdleConns;
        this.trustStoreFile = trustStoreFile;
        this.trustStorePassword = trustStorePassword;
    }

    public static RestClientConfigBuilder builder() {
        return new RestClientConfigBuilder();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getMaxConns() {
        return this.maxConns;
    }

    public Integer getMaxConnsPerRoute() {
        return this.maxConnsPerRoute;
    }

    public Integer getIdleTime() {
        return this.idleTime;
    }

    public Integer getMaxIdleConns() {
        return this.maxIdleConns;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxConns(Integer maxConns) {
        this.maxConns = maxConns;
    }

    public void setMaxConnsPerRoute(Integer maxConnsPerRoute) {
        this.maxConnsPerRoute = maxConnsPerRoute;
    }

    public void setIdleTime(Integer idleTime) {
        this.idleTime = idleTime;
    }

    public void setMaxIdleConns(Integer maxIdleConns) {
        this.maxIdleConns = maxIdleConns;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public static class RestClientConfigBuilder {
        private String user;
        private String password;
        private String token;
        private Integer timeout;
        private Integer maxConns;
        private Integer maxConnsPerRoute;
        private Integer idleTime;
        private Integer maxIdleConns;
        private String trustStoreFile;
        private String trustStorePassword;

        RestClientConfigBuilder() {
        }

        public RestClientConfigBuilder user(String user) {
            this.user = user;
            return this;
        }

        public RestClientConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RestClientConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public RestClientConfigBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public RestClientConfigBuilder maxConns(Integer maxConns) {
            this.maxConns = maxConns;
            return this;
        }

        public RestClientConfigBuilder maxConnsPerRoute(Integer maxConnsPerRoute) {
            this.maxConnsPerRoute = maxConnsPerRoute;
            return this;
        }

        public RestClientConfigBuilder idleTime(Integer idleTime) {
            this.idleTime = idleTime;
            return this;
        }

        public RestClientConfigBuilder maxIdleConns(Integer maxIdleConns) {
            this.maxIdleConns = maxIdleConns;
            return this;
        }

        public RestClientConfigBuilder trustStoreFile(String trustStoreFile) {
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public RestClientConfigBuilder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public RestClientConfig build() {
            return new RestClientConfig(this.user, this.password, this.token, this.timeout, this.maxConns, this.maxConnsPerRoute, this.idleTime, this.maxIdleConns, this.trustStoreFile, this.trustStorePassword);
        }

        public String toString() {
            return "RestClientConfig.RestClientConfigBuilder(user=" + this.user + ", password=" + this.password + ", token=" + this.token + ", timeout=" + this.timeout + ", maxConns=" + this.maxConns + ", maxConnsPerRoute=" + this.maxConnsPerRoute + ", idleTime=" + this.idleTime + ", maxIdleConns=" + this.maxIdleConns + ", trustStoreFile=" + this.trustStoreFile + ", trustStorePassword=" + this.trustStorePassword + ")";
        }
    }
}

