/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hugegraph.util.E;

public final class CompressUtil {
    public static void compressTar(String inputDir, String outputFile, Checksum checksum) throws IOException {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        int blockSize = 8192;
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             CheckedOutputStream cos = new CheckedOutputStream(fos, checksum);
             BufferedOutputStream bos = new BufferedOutputStream(cos);
             LZ4BlockOutputStream lz4os = new LZ4BlockOutputStream((OutputStream)bos, blockSize, compressor);
             TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)lz4os);){
            Path source = Paths.get(inputDir, new String[0]);
            CompressUtil.tarDir(source, tos);
            tos.flush();
            fos.getFD().sync();
        }
    }

    private static void tarDir(final Path source, final TarArchiveOutputStream tos) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String entryName = CompressUtil.buildTarEntryName(source, dir);
                if (!entryName.isEmpty()) {
                    TarArchiveEntry entry = new TarArchiveEntry(dir.toFile(), entryName);
                    tos.putArchiveEntry((ArchiveEntry)entry);
                    tos.closeArchiveEntry();
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                if (attributes.isSymbolicLink()) {
                    return FileVisitResult.CONTINUE;
                }
                String targetFile = CompressUtil.buildTarEntryName(source, file);
                TarArchiveEntry entry = new TarArchiveEntry(file.toFile(), targetFile);
                tos.putArchiveEntry((ArchiveEntry)entry);
                Files.copy(file, (OutputStream)tos);
                tos.closeArchiveEntry();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) {
                return FileVisitResult.TERMINATE;
            }
        });
    }

    private static String buildTarEntryName(Path topLevel, Path current) {
        return topLevel.getFileName().resolve(topLevel.relativize(current)).toString();
    }

    public static void decompressTar(String sourceFile, String outputDir, Checksum checksum) throws IOException {
        Path source = Paths.get(sourceFile, new String[0]);
        Path target = Paths.get(outputDir, new String[0]);
        if (Files.notExists(source, new LinkOption[0])) {
            throw new IOException(String.format("The source file %s doesn't exists", source));
        }
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        try (InputStream fis = Files.newInputStream(source, new OpenOption[0]);
             CheckedInputStream cis = new CheckedInputStream(fis, checksum);
             BufferedInputStream bis = new BufferedInputStream(cis);
             LZ4BlockInputStream lz4is = new LZ4BlockInputStream((InputStream)bis, decompressor);
             TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)lz4is);){
            ArchiveEntry entry;
            while ((entry = tis.getNextEntry()) != null) {
                Path newPath = CompressUtil.zipSlipProtect(entry, target);
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                Path parent = newPath.toAbsolutePath().getParent();
                if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy((InputStream)tis, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static Path zipSlipProtect(ArchiveEntry entry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(entry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir.normalize())) {
            throw new IOException(String.format("Bad entry: %s", entry.getName()));
        }
        return normalizePath;
    }

    public static void compressZip(String inputDir, String outputFile, Checksum checksum) throws IOException {
        String rootDir = Paths.get(inputDir, new String[0]).toAbsolutePath().getParent().toString();
        String sourceDir = Paths.get(inputDir, new String[0]).getFileName().toString();
        CompressUtil.compressZip(rootDir, sourceDir, outputFile, checksum);
    }

    public static void compressZip(String rootDir, String sourceDir, String outputFile, Checksum checksum) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             CheckedOutputStream cos = new CheckedOutputStream(fos, checksum);
             BufferedOutputStream bos = new BufferedOutputStream(cos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            CompressUtil.zipDir(rootDir, sourceDir, zos);
            zos.flush();
            fos.getFD().sync();
        }
    }

    private static void zipDir(String rootDir, String sourceDir, ZipOutputStream zos) throws IOException {
        String dir = Paths.get(rootDir, sourceDir).toString();
        File[] files = new File(dir).listFiles();
        E.checkNotNull((Object)files, (String)"files");
        for (File file : files) {
            String child = Paths.get(sourceDir, file.getName()).toString();
            if (file.isDirectory()) {
                CompressUtil.zipDir(rootDir, child, zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(child));
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                IOUtils.copy((InputStream)bis, (OutputStream)zos);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompressZip(String sourceFile, String outputDir, Checksum checksum) throws IOException {
        try (FileInputStream fis = new FileInputStream(sourceFile);
             CheckedInputStream cis = new CheckedInputStream(fis, checksum);
             BufferedInputStream bis = new BufferedInputStream(cis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                FileOutputStream fos;
                block71: {
                    String fileName = entry.getName();
                    File entryFile = new File(Paths.get(outputDir, fileName).toString());
                    FileUtils.forceMkdir((File)entryFile.getParentFile());
                    fos = new FileOutputStream(entryFile);
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            IOUtils.copy((InputStream)zis, (OutputStream)bos);
                            bos.flush();
                            fos.getFD().sync();
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block71;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable == null) {
                                fos.close();
                                throw throwable3;
                            }
                            try {
                                fos.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            IOUtils.copy((InputStream)cis, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            return;
        }
    }
}

