/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SubGraphTraverser
extends HugeTraverser {
    public SubGraphTraverser(HugeGraph graph) {
        super(graph);
    }

    private static boolean hasMultiEdges(List<Edge> edges, Id target) {
        boolean hasOutEdge = false;
        boolean hasInEdge = false;
        for (Edge edge : edges) {
            if (!((HugeEdge)edge).id().otherVertexId().equals(target)) continue;
            if (((HugeEdge)edge).direction() == Directions.OUT) {
                hasOutEdge = true;
            } else {
                hasInEdge = true;
            }
            if (!hasOutEdge || !hasInEdge) continue;
            return true;
        }
        return false;
    }

    public HugeTraverser.PathSet rays(Id sourceV, Directions dir, String label, int depth, long degree, long capacity, long limit) {
        return this.subGraphPaths(sourceV, dir, label, depth, degree, capacity, limit, false, false);
    }

    public HugeTraverser.PathSet rings(Id sourceV, Directions dir, String label, int depth, boolean sourceInRing, long degree, long capacity, long limit) {
        return this.subGraphPaths(sourceV, dir, label, depth, degree, capacity, limit, true, sourceInRing);
    }

    private HugeTraverser.PathSet subGraphPaths(Id sourceV, Directions dir, String label, int depth, long degree, long capacity, long limit, boolean rings, boolean sourceInRing) {
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        SubGraphTraverser.checkPositive(depth, "max depth");
        SubGraphTraverser.checkDegree(degree);
        SubGraphTraverser.checkCapacity(capacity);
        SubGraphTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelId(label);
        Traverser traverser = new Traverser(sourceV, labelId, depth, degree, capacity, limit, rings, sourceInRing);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        do {
            paths.addAll(traverser.forward(dir));
        } while (--depth > 0 && !traverser.reachLimit() && !traverser.finished());
        this.vertexIterCounter.addAndGet(traverser.accessedVertices.size());
        this.edgeIterCounter.addAndGet(traverser.edgeCount);
        paths.setEdges(traverser.edgeRecord.getEdges(paths));
        return paths;
    }

    private class Traverser {
        private final Id source;
        private final Id label;
        private final long degree;
        private final long capacity;
        private final long limit;
        private final boolean rings;
        private final boolean sourceInRing;
        private final Set<Id> accessedVertices = HugeTraverser.newIdSet();
        private final HugeTraverser.EdgeRecord edgeRecord;
        private MultivaluedMap<Id, HugeTraverser.Node> sources = HugeTraverser.newMultivalueMap();
        private int depth;
        private long pathCount;
        private long edgeCount;

        public Traverser(Id sourceV, Id label, int depth, long degree, long capacity, long limit, boolean rings, boolean sourceInRing) {
            this.source = sourceV;
            this.sources.add((Object)sourceV, (Object)new HugeTraverser.Node(sourceV));
            this.accessedVertices.add(sourceV);
            this.label = label;
            this.depth = depth;
            this.degree = degree;
            this.capacity = capacity;
            this.limit = limit;
            this.rings = rings;
            this.sourceInRing = sourceInRing;
            this.pathCount = 0L;
            this.edgeCount = 0L;
            this.edgeRecord = new HugeTraverser.EdgeRecord(false);
        }

        public HugeTraverser.PathSet forward(Directions direction) {
            HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
            MultivaluedMap newVertices = HugeTraverser.newMultivalueMap();
            for (Map.Entry entry : this.sources.entrySet()) {
                Id vid = (Id)entry.getKey();
                List edgeList = IteratorUtils.list(SubGraphTraverser.this.edgesOfVertex(vid, direction, this.label, this.degree));
                Iterator edges = edgeList.iterator();
                if (!edges.hasNext()) {
                    if (this.rings) continue;
                    for (HugeTraverser.Node n : (List)entry.getValue()) {
                        paths.add(new HugeTraverser.Path(n.path()));
                        ++this.pathCount;
                        if (!this.reachLimit()) continue;
                        return paths;
                    }
                }
                int neighborCount = 0;
                Set<Id> currentNeighbors = HugeTraverser.newIdSet();
                while (edges.hasNext()) {
                    ++neighborCount;
                    HugeEdge edge = (HugeEdge)edges.next();
                    ++this.edgeCount;
                    Id target = edge.id().otherVertexId();
                    this.edgeRecord.addEdge(vid, target, edge);
                    if (currentNeighbors.contains(target)) continue;
                    currentNeighbors.add(target);
                    this.accessedVertices.add(target);
                    for (HugeTraverser.Node node : (List)entry.getValue()) {
                        boolean bothBack;
                        if (!node.contains(target)) {
                            newVertices.add((Object)target, (Object)new HugeTraverser.Node(target, node));
                            continue;
                        }
                        boolean uniqueEdge = neighborCount == 1 && !edges.hasNext();
                        boolean bl = bothBack = target.equals(node.parent().id()) && direction == Directions.BOTH;
                        if (!this.rings && bothBack && uniqueEdge) {
                            paths.add(new HugeTraverser.Path(node.path()));
                            ++this.pathCount;
                            if (this.reachLimit()) {
                                return paths;
                            }
                        }
                        if (!this.rings) continue;
                        boolean ringsFound = false;
                        if (!this.sourceInRing || target.equals(this.source)) {
                            if (!target.equals(node.parent().id())) {
                                ringsFound = true;
                            } else if (direction != Directions.BOTH) {
                                ringsFound = true;
                            } else if (SubGraphTraverser.hasMultiEdges(edgeList, target)) {
                                ringsFound = true;
                            }
                        }
                        if (!ringsFound) continue;
                        List<Id> path = node.path();
                        path.add(target);
                        paths.add(new RingPath(null, path));
                        ++this.pathCount;
                        if (!this.reachLimit()) continue;
                        return paths;
                    }
                }
            }
            this.sources = newVertices;
            if (!this.rings && --this.depth <= 0) {
                for (List list : newVertices.values()) {
                    for (HugeTraverser.Node n : list) {
                        paths.add(new HugeTraverser.Path(n.path()));
                        ++this.pathCount;
                        if (!this.reachLimit()) continue;
                        return paths;
                    }
                }
            }
            return paths;
        }

        private boolean reachLimit() {
            HugeTraverser.checkCapacity(this.capacity, this.accessedVertices.size(), this.rings ? "rings" : "rays");
            return this.limit != -1L && this.pathCount >= this.limit;
        }

        private boolean finished() {
            return this.sources.isEmpty();
        }
    }

    private static class RingPath
    extends HugeTraverser.Path {
        public RingPath(Id crosspoint, List<Id> vertices) {
            super(crosspoint, vertices);
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (Id id : this.vertices()) {
                hashCode ^= id.hashCode();
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object other) {
            List<Id> otherVertices;
            if (!(other instanceof RingPath)) {
                return false;
            }
            List<Id> vertices = this.vertices();
            if (vertices.equals(otherVertices = ((HugeTraverser.Path)other).vertices())) {
                return true;
            }
            if (vertices.size() != otherVertices.size()) {
                return false;
            }
            int size = vertices.size();
            for (int i = 0; i < size; ++i) {
                int j = size - i - 1;
                if (vertices.get(i).equals(otherVertices.get(j))) continue;
                return false;
            }
            return true;
        }
    }
}

