/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.core.MultivaluedHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class FusiformSimilarityTraverser
extends HugeTraverser {
    private long accessed = 0L;

    public FusiformSimilarityTraverser(HugeGraph graph) {
        super(graph);
    }

    private static void checkGroupArgs(String groupProperty, int minGroups) {
        if (groupProperty == null) {
            E.checkArgument((minGroups == 0 ? 1 : 0) != 0, (String)"Can't set min group count when group property not set", (Object[])new Object[0]);
        } else {
            E.checkArgument((!groupProperty.isEmpty() ? 1 : 0) != 0, (String)"The group property can't be empty", (Object[])new Object[0]);
            E.checkArgument((minGroups > 0 ? 1 : 0) != 0, (String)"Must set min group count when group property set", (Object[])new Object[0]);
        }
    }

    public SimilarsMap fusiformSimilarity(Iterator<Vertex> vertices, Directions direction, String label, int minNeighbors, double alpha, int minSimilars, int top, String groupProperty, int minGroups, long degree, long capacity, long limit, boolean withIntermediary) {
        FusiformSimilarityTraverser.checkCapacity(capacity);
        FusiformSimilarityTraverser.checkLimit(limit);
        FusiformSimilarityTraverser.checkGroupArgs(groupProperty, minGroups);
        int foundCount = 0;
        SimilarsMap results = new SimilarsMap();
        while (vertices.hasNext()) {
            FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
            HugeVertex vertex = (HugeVertex)vertices.next();
            Set<Similar> result = this.fusiformSimilarityForVertex(vertex, direction, label, minNeighbors, alpha, minSimilars, top, groupProperty, minGroups, degree, capacity, withIntermediary);
            if (result.isEmpty()) continue;
            results.put(vertex.id(), result);
            if (limit == -1L || (long)(++foundCount) < limit) continue;
            break;
        }
        this.reset();
        return results;
    }

    private Set<Similar> fusiformSimilarityForVertex(HugeVertex vertex, Directions direction, String label, int minNeighbors, double alpha, int minSimilars, int top, String groupProperty, int minGroups, long degree, long capacity, boolean withIntermediary) {
        boolean matched = this.matchMinNeighborCount(vertex, direction, label, minNeighbors, degree);
        if (!matched) {
            return ImmutableSet.of();
        }
        Id labelId = this.getEdgeLabelId(label);
        Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, degree);
        Map<Id, MutableInt> similars = FusiformSimilarityTraverser.newMap();
        MultivaluedHashMap intermediaries = new MultivaluedHashMap();
        Set<Id> neighbors = FusiformSimilarityTraverser.newIdSet();
        long vertexCount = 1L;
        while (edges.hasNext()) {
            Id target = ((HugeEdge)edges.next()).id().otherVertexId();
            if (neighbors.contains(target)) continue;
            neighbors.add(target);
            FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
            Directions backDir = direction.opposite();
            Iterator<Edge> backEdges = this.edgesOfVertex(target, backDir, labelId, degree);
            ++vertexCount;
            Set<Id> currentSimilars = FusiformSimilarityTraverser.newIdSet();
            while (backEdges.hasNext()) {
                MutableInt count;
                Id node = ((HugeEdge)backEdges.next()).id().otherVertexId();
                if (currentSimilars.contains(node)) continue;
                currentSimilars.add(node);
                if (withIntermediary) {
                    intermediaries.add((Object)node, (Object)target);
                }
                if ((count = (MutableInt)similars.get(node)) == null) {
                    count = new MutableInt(0);
                    similars.put(node, count);
                    FusiformSimilarityTraverser.checkCapacity(capacity, ++this.accessed, "fusiform similarity");
                }
                count.increment();
            }
        }
        this.edgeIterCounter.addAndGet(this.accessed);
        this.vertexIterCounter.addAndGet(vertexCount);
        assert (similars.containsKey(vertex.id()));
        similars.remove(vertex.id());
        if (similars.isEmpty()) {
            return ImmutableSet.of();
        }
        double neighborNum = neighbors.size();
        Map matchedAlpha = FusiformSimilarityTraverser.newMap();
        for (Map.Entry entry : similars.entrySet()) {
            double score = (double)((MutableInt)entry.getValue()).intValue() / neighborNum;
            if (!(score >= alpha)) continue;
            matchedAlpha.put(entry.getKey(), score);
        }
        if (matchedAlpha.size() < minSimilars) {
            return ImmutableSet.of();
        }
        Map topN = top > 0 ? FusiformSimilarityTraverser.topN(matchedAlpha, true, top) : matchedAlpha;
        if (groupProperty != null) {
            Set values = FusiformSimilarityTraverser.newSet();
            values.add(vertex.value(groupProperty));
            for (Id id : topN.keySet()) {
                Vertex v = this.graph().vertices(id).next();
                values.add(v.value(groupProperty));
            }
            if (values.size() < minGroups) {
                return ImmutableSet.of();
            }
        }
        Set result = InsertionOrderUtil.newSet();
        for (Map.Entry entry : topN.entrySet()) {
            Id similar = (Id)entry.getKey();
            double score = (Double)entry.getValue();
            ImmutableList inters = withIntermediary ? (List)intermediaries.get((Object)similar) : ImmutableList.of();
            result.add(new Similar(similar, score, (List<Id>)inters));
        }
        return result;
    }

    private boolean matchMinNeighborCount(HugeVertex vertex, Directions direction, String label, int minNeighbors, long degree) {
        long neighborCount;
        EdgeLabel edgeLabel = null;
        Id labelId = null;
        if (label != null) {
            edgeLabel = this.graph().edgeLabel(label);
            labelId = edgeLabel.id();
        }
        if (edgeLabel != null && edgeLabel.frequency() == Frequency.SINGLE) {
            Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, (long)minNeighbors);
            neighborCount = IteratorUtils.count(edges);
        } else {
            Iterator<Edge> edges = this.edgesOfVertex(vertex.id(), direction, labelId, degree);
            Set<Id> neighbors = FusiformSimilarityTraverser.newIdSet();
            while (edges.hasNext()) {
                Id target = ((HugeEdge)edges.next()).id().otherVertexId();
                neighbors.add(target);
                if (neighbors.size() < minNeighbors) continue;
                break;
            }
            neighborCount = neighbors.size();
        }
        return neighborCount >= (long)minNeighbors;
    }

    private void reset() {
        this.accessed = 0L;
    }

    public static class SimilarsMap {
        private final Map<Id, Set<Similar>> similars = HugeTraverser.newMap();

        public int size() {
            return this.similars.size();
        }

        public Set<Map.Entry<Id, Set<Similar>>> entrySet() {
            return this.similars.entrySet();
        }

        public void put(Id id, Set<Similar> similars) {
            this.similars.put(id, similars);
        }

        public Set<Id> vertices() {
            Set<Id> vertices = HugeTraverser.newIdSet();
            vertices.addAll(this.similars.keySet());
            for (Set<Similar> similars : this.similars.values()) {
                for (Similar similar : similars) {
                    vertices.add(similar.id());
                    vertices.addAll(similar.intermediaries());
                }
            }
            return vertices;
        }

        public Map<Id, Set<Map<String, Object>>> toMap() {
            Map<Id, Set<Map<String, Object>>> results = HugeTraverser.newMap();
            for (Map.Entry<Id, Set<Similar>> entry : this.similars.entrySet()) {
                Id source = entry.getKey();
                Set<Similar> similars = entry.getValue();
                Set result = InsertionOrderUtil.newSet();
                for (Similar similar : similars) {
                    result.add(similar.toMap());
                }
                results.put(source, result);
            }
            return results;
        }

        public boolean isEmpty() {
            return this.similars.isEmpty();
        }
    }

    public static class Similar {
        private final Id id;
        private final double score;
        private final List<Id> intermediaries;

        public Similar(Id id, double score, List<Id> intermediaries) {
            this.id = id;
            this.score = score;
            assert (HugeTraverser.newSet(intermediaries).size() == intermediaries.size()) : "Invalid intermediaries";
            this.intermediaries = intermediaries;
        }

        public Id id() {
            return this.id;
        }

        public double score() {
            return this.score;
        }

        public List<Id> intermediaries() {
            return this.intermediaries;
        }

        public Map<String, Object> toMap() {
            return ImmutableMap.of((Object)"id", (Object)this.id, (Object)"score", (Object)this.score, (Object)"intermediaries", this.intermediaries);
        }
    }
}

