/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.SchemaTransaction;
import org.apache.hugegraph.job.schema.SchemaJob;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.LockUtil;

public class IndexLabelRebuildJob
extends SchemaJob {
    @Override
    public String type() {
        return "rebuild_index";
    }

    @Override
    public Object execute() {
        SchemaElement schema = this.schemaElement();
        if (schema != null) {
            this.rebuildIndex(schema);
        }
        return null;
    }

    private void rebuildIndex(SchemaElement schema) {
        switch (schema.type()) {
            case INDEX_LABEL: {
                SchemaLabel label;
                IndexLabel indexLabel = (IndexLabel)schema;
                if (indexLabel.baseType() == HugeType.VERTEX_LABEL) {
                    label = this.graph().vertexLabel(indexLabel.baseValue());
                } else {
                    assert (indexLabel.baseType() == HugeType.EDGE_LABEL);
                    label = this.graph().edgeLabel(indexLabel.baseValue());
                }
                assert (label != null);
                this.rebuildIndex(label, (Collection<Id>)ImmutableSet.of((Object)indexLabel.id()));
                break;
            }
            case VERTEX_LABEL: 
            case EDGE_LABEL: {
                SchemaLabel label = (SchemaLabel)schema;
                this.rebuildIndex(label, label.indexLabels());
                break;
            }
            default: {
                assert (schema.type() == HugeType.PROPERTY_KEY);
                throw new AssertionError((Object)String.format("The %s can't rebuild index", schema.type()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndex(SchemaLabel label, Collection<Id> indexLabelIds) {
        SchemaTransaction schemaTx = this.params().schemaTransaction();
        GraphTransaction graphTx = this.params().graphTransaction();
        Consumer<Object> indexUpdater = elem -> {
            for (Id id : indexLabelIds) {
                graphTx.updateIndex(id, (HugeElement)elem, false);
            }
        };
        LockUtil.Locks locks = new LockUtil.Locks(schemaTx.graphName());
        try {
            locks.lockWrites("il_rebuild", indexLabelIds);
            Set ils = indexLabelIds.stream().map(this.graph()::indexLabel).collect(Collectors.toSet());
            for (Object il : ils) {
                if (((SchemaElement)il).status() == SchemaStatus.CREATING) continue;
                schemaTx.updateSchemaStatus((SchemaElement)il, SchemaStatus.REBUILDING);
            }
            this.removeIndex(indexLabelIds);
            graphTx.commit();
            try {
                Consumer<Object> consumer;
                if (label.type() == HugeType.VERTEX_LABEL) {
                    consumer = indexUpdater;
                    graphTx.traverseVerticesByLabel((VertexLabel)label, consumer, false);
                } else {
                    assert (label.type() == HugeType.EDGE_LABEL);
                    consumer = indexUpdater;
                    graphTx.traverseEdgesByLabel((EdgeLabel)label, consumer, false);
                }
                graphTx.commit();
            }
            catch (Throwable e) {
                for (IndexLabel il : ils) {
                    schemaTx.updateSchemaStatus(il, SchemaStatus.INVALID);
                }
                throw e;
            }
            for (Object il : ils) {
                schemaTx.updateSchemaStatus((SchemaElement)il, SchemaStatus.CREATED);
            }
        }
        finally {
            locks.unlock();
        }
    }

    private void removeIndex(Collection<Id> indexLabelIds) {
        SchemaTransaction schemaTx = this.params().schemaTransaction();
        GraphTransaction graphTx = this.params().graphTransaction();
        for (Id id : indexLabelIds) {
            IndexLabel il = schemaTx.getIndexLabel(id);
            if (il == null || il.status() == SchemaStatus.CREATING) continue;
            LockUtil.Locks locks = new LockUtil.Locks(schemaTx.graphName());
            try {
                locks.lockWrites("il_delete", indexLabelIds);
                graphTx.removeIndex(il);
            }
            catch (Throwable e) {
                schemaTx.updateSchemaStatus(il, SchemaStatus.INVALID);
                throw e;
            }
            finally {
                locks.unlock();
            }
        }
    }

    private SchemaElement schemaElement() {
        HugeType type = this.schemaType();
        Id id = this.schemaId();
        switch (type) {
            case VERTEX_LABEL: {
                return this.graph().vertexLabel(id);
            }
            case EDGE_LABEL: {
                return this.graph().edgeLabel(id);
            }
            case INDEX_LABEL: {
                return this.graph().indexLabel(id);
            }
        }
        throw new AssertionError((Object)String.format("Invalid HugeType '%s' for rebuild", type));
    }
}

