/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.BfsTraverser;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ClosenessCentralityAlgorithmV2
extends AbstractCentAlgorithm {
    @Override
    public String name() {
        return "closeness_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        super.checkParameters(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.closenessCentrality(ClosenessCentralityAlgorithmV2.direction(parameters), ClosenessCentralityAlgorithmV2.edgeLabel(parameters), ClosenessCentralityAlgorithmV2.depth(parameters), ClosenessCentralityAlgorithmV2.degree(parameters), ClosenessCentralityAlgorithmV2.sample(parameters), ClosenessCentralityAlgorithmV2.sourceLabel(parameters), ClosenessCentralityAlgorithmV2.sourceSample(parameters), ClosenessCentralityAlgorithmV2.sourceCLabel(parameters), ClosenessCentralityAlgorithmV2.top(parameters));
            return object;
        }
    }

    private static class Traverser
    extends BfsTraverser<BfsTraverser.Node> {
        private final Map<Id, Float> globalCloseness = new HashMap<Id, Float>();
        private float startVertexCloseness;

        private Traverser(UserJob<Object> job) {
            super(job);
        }

        private Object closenessCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            Id edgeLabelId = null;
            if (label != null) {
                edgeLabelId = this.graph().edgeLabel(label).id();
            }
            Iterator<Vertex> startVertices = this.vertices(sourceLabel, sourceCLabel, Long.MAX_VALUE);
            while (startVertices.hasNext()) {
                this.startVertexCloseness = 0.0f;
                Id startVertex = ((HugeVertex)startVertices.next()).id();
                this.traverse(startVertex, direction, edgeLabelId, degree, (long)depth);
                this.globalCloseness.put(startVertex, Float.valueOf(this.startVertexCloseness));
            }
            if (topN > 0L || topN == -1L) {
                return HugeTraverser.topN(this.globalCloseness, true, topN);
            }
            return this.globalCloseness;
        }

        @Override
        protected BfsTraverser.Node createStartNode() {
            return new BfsTraverser.Node(1, 0);
        }

        @Override
        protected BfsTraverser.Node createNode(BfsTraverser.Node parentNode) {
            return new BfsTraverser.Node(parentNode);
        }

        @Override
        protected void meetNode(Id currentVertex, BfsTraverser.Node currentNode, Id parentVertex, BfsTraverser.Node parentNode, boolean firstTime) {
            if (firstTime) {
                this.startVertexCloseness += 1.0f / (float)currentNode.distance();
            }
        }

        @Override
        protected void backtrack(Id startVertex, Id currentVertex, Map<Id, BfsTraverser.Node> localNodes) {
            throw new NotSupportException("backtrack()");
        }
    }
}

