/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.BfsTraverser;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class BetweennessCentralityAlgorithmV2
extends AbstractCentAlgorithm {
    @Override
    public String name() {
        return "betweenness_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        super.checkParameters(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.betweenessCentrality(BetweennessCentralityAlgorithmV2.direction(parameters), BetweennessCentralityAlgorithmV2.edgeLabel(parameters), BetweennessCentralityAlgorithmV2.depth(parameters), BetweennessCentralityAlgorithmV2.degree(parameters), BetweennessCentralityAlgorithmV2.sample(parameters), BetweennessCentralityAlgorithmV2.sourceLabel(parameters), BetweennessCentralityAlgorithmV2.sourceSample(parameters), BetweennessCentralityAlgorithmV2.sourceCLabel(parameters), BetweennessCentralityAlgorithmV2.top(parameters));
            return object;
        }
    }

    private static class BetweennessNode
    extends BfsTraverser.Node {
        private float betweenness = 0.0f;

        public BetweennessNode(BetweennessNode parentNode) {
            this(0, parentNode.distance() + 1);
        }

        public BetweennessNode(int pathCount, int distance) {
            super(pathCount, distance);
        }

        public void increaseBetweenness(BetweennessNode childNode) {
            float increase = (float)this.pathCount() / (float)childNode.pathCount() * (1.0f + childNode.betweenness);
            this.betweenness += increase;
        }

        public float betweenness() {
            return this.betweenness;
        }
    }

    private static class Traverser
    extends BfsTraverser<BetweennessNode> {
        private Map<Id, MutableFloat> globalBetweennesses;

        private Traverser(UserJob<Object> job) {
            super(job);
        }

        private Object betweenessCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            this.globalBetweennesses = new HashMap<Id, MutableFloat>();
            Id edgeLabelId = null;
            if (label != null) {
                edgeLabelId = this.graph().edgeLabel(label).id();
            }
            Iterator<Vertex> startVertices = this.vertices(sourceLabel, sourceCLabel, Long.MAX_VALUE);
            while (startVertices.hasNext()) {
                Id startVertex = ((HugeVertex)startVertices.next()).id();
                this.globalBetweennesses.putIfAbsent(startVertex, new MutableFloat());
                this.compute(startVertex, direction, edgeLabelId, degree, depth);
            }
            if (topN > 0L || topN == -1L) {
                return HugeTraverser.topN(this.globalBetweennesses, true, topN);
            }
            return this.globalBetweennesses;
        }

        @Override
        protected BetweennessNode createNode(BetweennessNode parentNode) {
            return new BetweennessNode(parentNode);
        }

        @Override
        protected void meetNode(Id currentVertex, BetweennessNode currentNode, Id parentVertex, BetweennessNode parentNode, boolean firstTime) {
            currentNode.addParentNode(parentNode, parentVertex);
        }

        @Override
        protected BetweennessNode createStartNode() {
            return new BetweennessNode(1, 0);
        }

        @Override
        protected void backtrack(Id startVertex, Id currentVertex, Map<Id, BetweennessNode> localNodes) {
            if (startVertex.equals(currentVertex)) {
                return;
            }
            MutableFloat betweenness = this.globalBetweennesses.get(currentVertex);
            if (betweenness == null) {
                betweenness = new MutableFloat(0.0f);
                this.globalBetweennesses.put(currentVertex, betweenness);
            }
            BetweennessNode node = localNodes.get(currentVertex);
            betweenness.add(node.betweenness());
            for (Id v : node.parents()) {
                BetweennessNode parentNode = localNodes.get(v);
                parentNode.increaseBetweenness(node);
            }
        }
    }
}

