/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft;

import com.alipay.remoting.rpc.RpcServer;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.raft.RaftBackendStore;
import org.apache.hugegraph.backend.store.raft.RaftClosure;
import org.apache.hugegraph.backend.store.raft.RaftContext;
import org.apache.hugegraph.backend.store.raft.RaftGroupManager;
import org.apache.hugegraph.backend.store.raft.RaftStoreClosure;
import org.apache.hugegraph.backend.store.raft.StoreCommand;
import org.apache.hugegraph.backend.store.raft.rpc.RaftRequests;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.event.EventListener;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class RaftBackendStoreProvider
implements BackendStoreProvider {
    private static final Logger LOG = Log.logger(RaftBackendStoreProvider.class);
    private final BackendStoreProvider provider;
    private final RaftContext context;
    private RaftBackendStore schemaStore;
    private RaftBackendStore graphStore;
    private RaftBackendStore systemStore;

    public RaftBackendStoreProvider(HugeGraphParams params, BackendStoreProvider provider) {
        this.provider = provider;
        this.schemaStore = null;
        this.graphStore = null;
        this.systemStore = null;
        this.context = new RaftContext(params);
    }

    public RaftGroupManager raftNodeManager() {
        return this.context().raftNodeManager();
    }

    private RaftContext context() {
        if (this.context == null) {
            E.checkState((boolean)false, (String)"Please ensure init raft context", (Object[])new Object[0]);
        }
        return this.context;
    }

    private Set<RaftBackendStore> stores() {
        return ImmutableSet.of((Object)this.schemaStore, (Object)this.graphStore, (Object)this.systemStore);
    }

    private void checkOpened() {
        E.checkState((this.graph() != null && this.schemaStore != null && this.graphStore != null && this.systemStore != null ? 1 : 0) != 0, (String)"The RaftBackendStoreProvider has not been opened", (Object[])new Object[0]);
    }

    private void checkNonSharedStore(BackendStore store) {
        E.checkArgument((!store.features().supportsSharedStorage() ? 1 : 0) != 0, (String)"Can't enable raft mode with %s backend", (Object[])new Object[]{this.type()});
    }

    @Override
    public String type() {
        return this.provider.type();
    }

    @Override
    public String driverVersion() {
        return this.provider.driverVersion();
    }

    @Override
    public String storedVersion() {
        return this.provider.storedVersion();
    }

    @Override
    public String graph() {
        return this.provider.graph();
    }

    @Override
    public synchronized BackendStore loadSchemaStore(HugeConfig config) {
        if (this.schemaStore == null) {
            LOG.info("Init raft backend schema store");
            BackendStore store = this.provider.loadSchemaStore(config);
            this.checkNonSharedStore(store);
            this.schemaStore = new RaftBackendStore(store, this.context());
            this.context().addStore(RaftRequests.StoreType.SCHEMA, this.schemaStore);
        }
        return this.schemaStore;
    }

    @Override
    public synchronized BackendStore loadGraphStore(HugeConfig config) {
        if (this.graphStore == null) {
            LOG.info("Init raft backend graph store");
            BackendStore store = this.provider.loadGraphStore(config);
            this.checkNonSharedStore(store);
            this.graphStore = new RaftBackendStore(store, this.context());
            this.context().addStore(RaftRequests.StoreType.GRAPH, this.graphStore);
        }
        return this.graphStore;
    }

    @Override
    public synchronized BackendStore loadSystemStore(HugeConfig config) {
        if (this.systemStore == null) {
            LOG.info("Init raft backend system store");
            BackendStore store = this.provider.loadSystemStore(config);
            this.checkNonSharedStore(store);
            this.systemStore = new RaftBackendStore(store, this.context());
            this.context().addStore(RaftRequests.StoreType.SYSTEM, this.systemStore);
        }
        return this.systemStore;
    }

    @Override
    public void open(String name) {
        this.provider.open(name);
    }

    @Override
    public void waitReady(RpcServer rpcServer) {
        this.context().initRaftNode(rpcServer);
        LOG.info("The raft node is initialized");
        this.context().waitRaftNodeStarted();
        LOG.info("The raft store is started");
    }

    @Override
    public void close() {
        this.provider.close();
        if (this.context != null) {
            this.context.close();
        }
    }

    @Override
    public void init() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.init();
        }
        this.notifyAndWaitEvent("store.init");
        LOG.debug("Graph '{}' store has been initialized", (Object)this.graph());
    }

    @Override
    public void clear() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.clear(false);
        }
        for (RaftBackendStore store : this.stores()) {
            store.clear(true);
        }
        this.notifyAndWaitEvent("store.clear");
        LOG.debug("Graph '{}' store has been cleared", (Object)this.graph());
    }

    @Override
    public void truncate() {
        this.checkOpened();
        for (RaftBackendStore store : this.stores()) {
            store.truncate();
        }
        this.notifyAndWaitEvent("store.truncate");
        LOG.debug("Graph '{}' store has been truncated", (Object)this.graph());
        this.createSnapshot();
    }

    @Override
    public boolean initialized() {
        return this.provider.initialized() && this.context != null;
    }

    @Override
    public void createSnapshot() {
        StoreCommand command = new StoreCommand(RaftRequests.StoreType.GRAPH, RaftRequests.StoreAction.SNAPSHOT, null);
        RaftStoreClosure closure = new RaftStoreClosure(command);
        RaftClosure future = (RaftClosure)this.context().node().submitAndWait(command, closure);
        E.checkState((future != null ? 1 : 0) != 0, (String)"The snapshot future can't be null", (Object[])new Object[0]);
        try {
            future.waitFinished();
            LOG.debug("Graph '{}' has writed snapshot", (Object)this.graph());
        }
        catch (Throwable e) {
            throw new BackendException("Failed to create snapshot", e);
        }
    }

    @Override
    public void onCloneConfig(HugeConfig config, String newGraph) {
        this.provider.onCloneConfig(config, newGraph);
    }

    @Override
    public void onDeleteConfig(HugeConfig config) {
        this.provider.onDeleteConfig(config);
    }

    @Override
    public void resumeSnapshot() {
        throw new UnsupportedOperationException("resumeSnapshot");
    }

    @Override
    public void listen(EventListener listener) {
        this.provider.listen(listener);
    }

    @Override
    public void unlisten(EventListener listener) {
        this.provider.unlisten(listener);
    }

    @Override
    public EventHub storeEventHub() {
        return this.provider.storeEventHub();
    }

    protected final void notifyAndWaitEvent(String event) {
        Future future = this.storeEventHub().notify(event, new Object[]{this});
        try {
            future.get();
        }
        catch (Throwable e) {
            LOG.warn("Error when waiting for event execution: {}", (Object)event, (Object)e);
        }
    }
}

