/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.query;

import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.type.define.Directions;

public class EdgesQueryIterator
implements Iterator<Query> {
    private final List<Id> labels;
    private final Directions directions;
    private final long limit;
    private final Iterator<Id> sources;

    public EdgesQueryIterator(Iterator<Id> sources, Directions directions, List<Id> labels, long limit) {
        this.sources = sources;
        this.labels = labels;
        this.directions = directions;
        this.limit = limit < 0L ? Long.MAX_VALUE : limit;
    }

    @Override
    public boolean hasNext() {
        return this.sources.hasNext();
    }

    @Override
    public Query next() {
        Id sourceId = this.sources.next();
        ConditionQuery query = GraphTransaction.constructEdgesQuery(sourceId, this.directions, this.labels);
        if (this.limit != Long.MAX_VALUE) {
            query.limit(this.limit);
            query.capacity(this.limit);
        } else {
            query.capacity(-1L);
        }
        return query;
    }
}

