/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.option.SnapshotCopierOptions;
import com.alipay.sofa.jraft.storage.SnapshotStorage;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotCopier;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshot;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotStorage;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotWriter;
import com.alipay.sofa.jraft.storage.snapshot.remote.RemoteFileCopier;
import com.alipay.sofa.jraft.storage.snapshot.remote.Session;
import com.alipay.sofa.jraft.util.ArrayDeque;
import com.alipay.sofa.jraft.util.ByteBufferCollector;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.Utils;
import com.google.protobuf.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSnapshotCopier
extends SnapshotCopier {
    private static final Logger LOG = LoggerFactory.getLogger(LocalSnapshotCopier.class);
    private final Lock lock = new ReentrantLock();
    private volatile Future<?> future;
    private boolean cancelled;
    private LocalSnapshotWriter writer;
    private volatile LocalSnapshotReader reader;
    private LocalSnapshotStorage storage;
    private boolean filterBeforeCopyRemote;
    private LocalSnapshot remoteSnapshot;
    private RemoteFileCopier copier;
    private Session curSession;
    private SnapshotThrottle snapshotThrottle;

    public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        this.snapshotThrottle = snapshotThrottle;
    }

    private void startCopy() {
        try {
            this.internalCopy();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.error("Fail to start copy job", (Throwable)e);
        }
    }

    private void internalCopy() throws IOException, InterruptedException {
        this.loadMetaTable();
        if (this.isOk()) {
            this.filter();
            if (this.isOk()) {
                Set<String> files = this.remoteSnapshot.listFiles();
                for (String file : files) {
                    this.copyFile(file);
                }
            }
        }
        if (!this.isOk() && this.writer != null && this.writer.isOk()) {
            this.writer.setError(this.getCode(), this.getErrorMsg(), new Object[0]);
        }
        if (this.writer != null) {
            Utils.closeQuietly(this.writer);
            this.writer = null;
        }
        if (this.isOk()) {
            this.reader = (LocalSnapshotReader)this.storage.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyFile(String fileName) throws IOException, InterruptedException {
        block23: {
            block21: {
                block20: {
                    if (this.writer.getFileMeta(fileName) != null) {
                        LocalSnapshotCopier.LOG.info("Skipped downloading {}", (Object)fileName);
                        return;
                    }
                    if (!this.checkFile(fileName)) {
                        return;
                    }
                    filePath = this.writer.getPath() + File.separator + fileName;
                    subPath = Paths.get(filePath, new String[0]);
                    if (!(subPath.equals(subPath.getParent()) || subPath.getParent().getFileName().toString().equals(".") || (parentDir = subPath.getParent().toFile()).exists() || parentDir.mkdirs())) {
                        LocalSnapshotCopier.LOG.error("Fail to create directory for {}", (Object)filePath);
                        this.setError(RaftError.EIO, "Fail to create directory", new Object[0]);
                        return;
                    }
                    meta = (LocalFileMetaOutter.LocalFileMeta)this.remoteSnapshot.getFileMeta(fileName);
                    session = null;
                    try {
                        this.lock.lock();
                        if (this.cancelled) {
                            if (this.isOk()) {
                                this.setError(RaftError.ECANCELED, "ECANCELED", new Object[0]);
                            }
                            this.lock.unlock();
                            if (session == null) return;
                            break block20;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var8_8) {
                        if (session == null) throw var8_8;
                        Utils.closeQuietly(session);
                        throw var8_8;
                    }
                }
                Utils.closeQuietly(session);
                return;
lbl-1000:
                // 1 sources

                {
                    session = this.copier.startCopyToFile(fileName, filePath, null);
                    if (session != null) break block21;
                    LocalSnapshotCopier.LOG.error("Fail to copy {}", (Object)fileName);
                    this.setError(-1, "Fail to copy %s", new Object[]{fileName});
                    this.lock.unlock();
                    if (session == null) return;
                }
                Utils.closeQuietly(session);
                return;
            }
            ** try [egrp 5[TRYBLOCK] [2 : 302->308)] { 
lbl46:
            // 1 sources

            break block23;
lbl47:
            // 1 sources

            finally {
                this.lock.unlock();
            }
        }
        this.curSession = session;
        session.join();
        this.lock.lock();
        try {
            this.curSession = null;
        }
        finally {
            this.lock.unlock();
        }
        if (session.status().isOk() || !this.isOk()) ** GOTO lbl-1000
        this.setError(session.status().getCode(), session.status().getErrorMsg(), new Object[0]);
        if (session == null) return;
        Utils.closeQuietly(session);
        return;
lbl-1000:
        // 1 sources

        {
            if (this.writer.addFile(fileName, (Message)meta)) ** GOTO lbl-1000
            this.setError(RaftError.EIO, "Fail to add file to writer", new Object[0]);
            if (session == null) return;
        }
        Utils.closeQuietly(session);
        return;
lbl-1000:
        // 1 sources

        {
            if (!this.writer.sync()) {
                this.setError(RaftError.EIO, "Fail to sync writer", new Object[0]);
            }
            if (session == null) return;
        }
        Utils.closeQuietly(session);
    }

    private boolean checkFile(String fileName) {
        try {
            String parentCanonicalPath = Paths.get(this.writer.getPath(), new String[0]).toFile().getCanonicalPath();
            Path filePath = Paths.get(parentCanonicalPath, fileName);
            File file = filePath.toFile();
            String fileAbsolutePath = file.getAbsolutePath();
            String fileCanonicalPath = file.getCanonicalPath();
            if (!fileAbsolutePath.equals(fileCanonicalPath)) {
                LOG.error("File[{}] are not allowed to be created outside of directory[{}].", (Object)fileAbsolutePath, (Object)fileCanonicalPath);
                this.setError(RaftError.EIO, "File[%s] are not allowed to be created outside of directory.", fileAbsolutePath, fileCanonicalPath);
                return false;
            }
        }
        catch (IOException e) {
            LOG.error("Failed to check file: {}, writer path: {}.", new Object[]{fileName, this.writer.getPath(), e});
            this.setError(RaftError.EIO, "Failed to check file: {}, writer path: {}.", fileName, this.writer.getPath());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMetaTable() throws InterruptedException {
        Session session;
        block17: {
            ByteBufferCollector metaBuf;
            block16: {
                block14: {
                    block13: {
                        metaBuf = ByteBufferCollector.allocate(0);
                        session = null;
                        this.lock.lock();
                        if (!this.cancelled) break block13;
                        if (this.isOk()) {
                            this.setError(RaftError.ECANCELED, "ECANCELED", new Object[0]);
                        }
                        this.lock.unlock();
                        if (session == null) return;
                        Utils.closeQuietly(session);
                        return;
                    }
                    this.curSession = session = this.copier.startCopy2IoBuffer("__raft_snapshot_meta", metaBuf, null);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                session.join();
                this.lock.lock();
                try {
                    this.curSession = null;
                }
                finally {
                    this.lock.unlock();
                }
                if (session.status().isOk() || !this.isOk()) break block16;
                LOG.warn("Fail to copy meta file: {}", (Object)session.status());
                this.setError(session.status().getCode(), session.status().getErrorMsg(), new Object[0]);
                if (session == null) return;
                Utils.closeQuietly(session);
                return;
            }
            try {
                if (this.remoteSnapshot.getMetaTable().loadFromIoBufferAsRemote(metaBuf.getBuffer())) break block17;
                LOG.warn("Bad meta_table format");
                this.setError(-1, "Bad meta_table format from remote", new Object[0]);
                if (session == null) return;
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                Utils.closeQuietly(session);
                throw throwable;
            }
            Utils.closeQuietly(session);
            return;
        }
        Requires.requireTrue(this.remoteSnapshot.getMetaTable().hasMeta(), "Invalid remote snapshot meta:%s", this.remoteSnapshot.getMetaTable().getMeta());
        if (session == null) return;
        Utils.closeQuietly(session);
    }

    boolean filterBeforeCopy(LocalSnapshotWriter writer, SnapshotReader lastSnapshot) throws IOException {
        Set<String> existingFiles = writer.listFiles();
        ArrayDeque<String> toRemove = new ArrayDeque<String>();
        for (String file : existingFiles) {
            if (this.remoteSnapshot.getFileMeta(file) != null) continue;
            toRemove.add(file);
            writer.removeFile(file);
        }
        Set<String> remoteFiles = this.remoteSnapshot.listFiles();
        for (String fileName : remoteFiles) {
            LocalFileMetaOutter.LocalFileMeta remoteMeta = (LocalFileMetaOutter.LocalFileMeta)this.remoteSnapshot.getFileMeta(fileName);
            Requires.requireNonNull(remoteMeta, "remoteMeta");
            if (!remoteMeta.hasChecksum()) {
                writer.removeFile(fileName);
                toRemove.add(fileName);
                continue;
            }
            LocalFileMetaOutter.LocalFileMeta localMeta = (LocalFileMetaOutter.LocalFileMeta)writer.getFileMeta(fileName);
            if (localMeta != null) {
                if (localMeta.hasChecksum() && localMeta.getChecksum().equals(remoteMeta.getChecksum())) {
                    LOG.info("Keep file={} checksum={} in {}", new Object[]{fileName, remoteMeta.getChecksum(), writer.getPath()});
                    continue;
                }
                writer.removeFile(fileName);
                toRemove.add(fileName);
            }
            if (lastSnapshot == null || (localMeta = (LocalFileMetaOutter.LocalFileMeta)lastSnapshot.getFileMeta(fileName)) == null || !localMeta.hasChecksum() || !localMeta.getChecksum().equals(remoteMeta.getChecksum())) continue;
            LOG.info("Found the same file ={} checksum={} in lastSnapshot={}", new Object[]{fileName, remoteMeta.getChecksum(), lastSnapshot.getPath()});
            if (localMeta.getSource() == LocalFileMetaOutter.FileSource.FILE_SOURCE_LOCAL) {
                String sourcePath = lastSnapshot.getPath() + File.separator + fileName;
                String destPath = writer.getPath() + File.separator + fileName;
                FileUtils.deleteQuietly((File)new File(destPath));
                try {
                    Files.createLink(Paths.get(destPath, new String[0]), Paths.get(sourcePath, new String[0]));
                }
                catch (IOException e) {
                    LOG.error("Fail to link {} to {}", new Object[]{sourcePath, destPath, e});
                    continue;
                }
                if (!toRemove.isEmpty() && ((String)toRemove.peekLast()).equals(fileName)) {
                    toRemove.pollLast();
                }
            }
            writer.addFile(fileName, (Message)localMeta);
        }
        if (!writer.sync()) {
            LOG.error("Fail to sync writer on path={}", (Object)writer.getPath());
            return false;
        }
        for (String fileName : toRemove) {
            String removePath = writer.getPath() + File.separator + fileName;
            FileUtils.deleteQuietly((File)new File(removePath));
            LOG.info("Deleted file: {}", (Object)removePath);
        }
        return true;
    }

    private void filter() throws IOException {
        this.writer = (LocalSnapshotWriter)this.storage.create(!this.filterBeforeCopyRemote);
        if (this.writer == null) {
            this.setError(RaftError.EIO, "Fail to create snapshot writer", new Object[0]);
            return;
        }
        if (this.filterBeforeCopyRemote) {
            SnapshotReader reader = this.storage.open();
            if (!this.filterBeforeCopy(this.writer, reader)) {
                LOG.warn("Fail to filter writer before copying, destroy and create a new writer.");
                this.writer.setError(-1, "Fail to filter", new Object[0]);
                Utils.closeQuietly(this.writer);
                this.writer = (LocalSnapshotWriter)this.storage.create(true);
            }
            if (reader != null) {
                Utils.closeQuietly(reader);
            }
            if (this.writer == null) {
                this.setError(RaftError.EIO, "Fail to create snapshot writer", new Object[0]);
                return;
            }
        }
        this.writer.saveMeta(this.remoteSnapshot.getMetaTable().getMeta());
        if (!this.writer.sync()) {
            LOG.error("Fail to sync snapshot writer path={}", (Object)this.writer.getPath());
            this.setError(RaftError.EIO, "Fail to sync snapshot writer", new Object[0]);
        }
    }

    public boolean init(String uri, SnapshotCopierOptions opts) {
        this.copier = new RemoteFileCopier();
        this.cancelled = false;
        this.filterBeforeCopyRemote = opts.getNodeOptions().isFilterBeforeCopyRemote();
        this.remoteSnapshot = new LocalSnapshot(opts.getRaftOptions());
        return this.copier.init(uri, this.snapshotThrottle, opts);
    }

    public SnapshotStorage getStorage() {
        return this.storage;
    }

    public void setStorage(SnapshotStorage storage) {
        this.storage = (LocalSnapshotStorage)storage;
    }

    public boolean isFilterBeforeCopyRemote() {
        return this.filterBeforeCopyRemote;
    }

    public void setFilterBeforeCopyRemote(boolean filterBeforeCopyRemote) {
        this.filterBeforeCopyRemote = filterBeforeCopyRemote;
    }

    @Override
    public void close() throws IOException {
        this.cancel();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void start() {
        this.future = Utils.runInThread(this::startCopy);
    }

    @Override
    public void cancel() {
        this.lock.lock();
        try {
            if (this.cancelled) {
                return;
            }
            if (this.isOk()) {
                this.setError(RaftError.ECANCELED, "Cancel the copier manually.", new Object[0]);
            }
            this.cancelled = true;
            if (this.curSession != null) {
                this.curSession.cancel();
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.future != null) {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (CancellationException e) {
            }
            catch (Exception e) {
                LOG.error("Fail to join on copier", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public SnapshotReader getReader() {
        return this.reader;
    }
}

