/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hugegraph.computer.core.store.FileGenerator;

public class SuperstepFileGenerator {
    private final FileGenerator fileGenerator;
    private final int superstep;

    public SuperstepFileGenerator(FileGenerator fileGenerator, int superstep) {
        this.fileGenerator = fileGenerator;
        this.superstep = superstep;
    }

    public String nextPath(String type) {
        String[] paths = new String[]{type, Integer.toString(this.superstep), UUID.randomUUID().toString()};
        return this.fileGenerator.nextDirectory(paths);
    }

    public List<String> superstepDirs(int superstep, String type) {
        ArrayList<String> superstepDirs = new ArrayList<String>();
        String[] paths = new String[]{type, Integer.toString(superstep)};
        for (String dir : this.fileGenerator.dirs()) {
            superstepDirs.add(Paths.get(dir, paths).toString());
        }
        return superstepDirs;
    }
}

