/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.sorting;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.sort.sorting.AbstractInputsSorting;

public final class HeapInputsSorting<T>
extends AbstractInputsSorting<T> {
    private final Object[] data;
    private int size;

    public HeapInputsSorting(Collection<? extends Iterator<T>> sources) {
        this(sources, null);
    }

    public HeapInputsSorting(Collection<? extends Iterator<T>> sources, Comparator<? super T> comparator) {
        super(sources, comparator);
        this.size = sources.size();
        this.data = new Object[this.size];
        this.constructHeap();
    }

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public T next() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object top = this.data[0];
        Iterator topSource = this.sources[0];
        if (topSource.hasNext()) {
            this.data[0] = topSource.next();
        } else {
            --this.size;
            if (this.size > 0) {
                this.sources[0] = this.sources[this.size];
                this.data[0] = this.data[this.size];
            }
        }
        this.adjustHeap(0);
        return (T)top;
    }

    private void constructHeap() {
        int i = 0;
        int len = this.sources.length - 1;
        while (i <= len) {
            if (!this.sources[i].hasNext()) {
                System.arraycopy(this.sources, i + 1, this.sources, i, len - i);
                --this.size;
                --len;
                continue;
            }
            this.data[i] = this.sources[i].next();
            ++i;
        }
        for (int index = (this.size >> 1) - 1; index >= 0; --index) {
            this.adjustHeap(index);
        }
    }

    private void adjustHeap(int parent) {
        int child;
        while ((child = (parent << 1) + 1) < this.size) {
            if (child < this.size - 1 && this.compare(this.data[child], this.data[child + 1]) > 0) {
                ++child;
            }
            if (this.compare(this.data[parent], this.data[child]) <= 0) break;
            this.swap(parent, child);
            parent = child;
        }
    }

    private void swap(int i, int j) {
        Object dataTmp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = dataTmp;
        Iterator sourceTmp = this.sources[i];
        this.sources[i] = this.sources[j];
        this.sources[j] = sourceTmp;
    }

    private boolean isEmpty() {
        return this.size <= 0;
    }
}

