/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.util.Map;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.edge.Edges;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.StructGraphOutput;
import org.apache.hugegraph.computer.core.io.StructRandomAccessOutput;

public class CsvStructGraphOutput
extends StructGraphOutput {
    public CsvStructGraphOutput(ComputerContext context, StructRandomAccessOutput out) {
        super(context, out);
    }

    public void writeVertex(Vertex vertex) throws IOException {
        this.writeLineStart();
        this.writeId(vertex.id());
        this.writeSplitter();
        this.writeValue(vertex.value());
        if (this.config.outputVertexAdjacentEdges().booleanValue()) {
            this.writeSplitter();
            this.writeEdges(vertex.edges());
        }
        if (this.config.outputVertexProperties().booleanValue()) {
            this.writeSplitter();
            this.writeProperties(vertex.properties());
        }
        this.writeLineEnd();
    }

    public void writeEdges(Edges edges) throws IOException {
        this.writeArrayStart();
        int size = edges.size();
        int i = 0;
        for (Edge edge : edges) {
            this.writeEdge(edge);
            if (++i >= size) continue;
            this.writeSplitter();
        }
        this.writeArrayEnd();
    }

    public void writeEdge(Edge edge) throws IOException {
        this.writeObjectStart();
        this.writeId(edge.targetId());
        this.writeSplitter();
        this.out.writeString(edge.label());
        this.writeSplitter();
        this.out.writeString(edge.name());
        if (this.config.outputEdgeProperties().booleanValue()) {
            this.writeSplitter();
            this.writeProperties(edge.properties());
        }
        this.writeObjectEnd();
    }

    public void writeProperties(Properties properties) throws IOException {
        this.writeObjectStart();
        int size = properties.get().size();
        int i = 0;
        for (Map.Entry entry : properties.get().entrySet()) {
            this.writeValue((Value)entry.getValue());
            if (++i >= size) continue;
            this.writeSplitter();
        }
        this.writeObjectEnd();
    }

    @Override
    public void writeObjectStart() throws IOException {
        this.out.writeRawString("{");
    }

    @Override
    public void writeObjectEnd() throws IOException {
        this.out.writeRawString("}");
    }

    @Override
    public void writeArrayStart() throws IOException {
        this.out.writeRawString("[");
    }

    @Override
    public void writeArrayEnd() throws IOException {
        this.out.writeRawString("]");
    }

    @Override
    public void writeKey(String key) throws IOException {
    }

    @Override
    public void writeJoiner() throws IOException {
    }

    @Override
    public void writeSplitter() throws IOException {
        this.out.writeRawString(",");
    }
}

