/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hugegraph.computer.core.io.AbstractBufferedFileOutput;
import org.apache.hugegraph.util.E;

public class BufferedFileOutput
extends AbstractBufferedFileOutput {
    private final int bufferCapacity;
    private final RandomAccessFile file;

    public BufferedFileOutput(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"), 8192);
    }

    public BufferedFileOutput(RandomAccessFile file, int bufferCapacity) {
        super(bufferCapacity);
        E.checkArgument((bufferCapacity >= 8 ? 1 : 0) != 0, (String)"The parameter bufferSize must be >= 8", (Object[])new Object[0]);
        this.bufferCapacity = bufferCapacity;
        this.file = file;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.bufferAvailable()) {
            super.write(b, off, len);
            return;
        }
        this.flushBuffer();
        if (len <= this.bufferCapacity) {
            super.write(b, off, len);
        } else {
            this.file.write(b, off, len);
            this.fileOffset += (long)len;
        }
    }

    @Override
    public void seek(long position) throws IOException {
        if (this.fileOffset <= position && position <= this.position()) {
            super.seek(position - this.fileOffset);
            return;
        }
        this.flushBuffer();
        this.file.seek(position);
        this.fileOffset = position;
    }

    @Override
    protected void flushBuffer() throws IOException {
        int bufferSize = super.bufferSize();
        if (bufferSize == 0) {
            return;
        }
        this.file.write(this.buffer(), 0, bufferSize);
        this.fileOffset += (long)bufferSize;
        super.seek(0L);
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.file.close();
    }
}

