/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.compute.input;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.compute.input.ReusablePointer;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.EdgeFrequency;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.edge.Edges;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.io.BufferedFileInput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.StreamGraphInput;
import org.apache.hugegraph.config.TypedOption;

public class EdgesInput {
    private RandomAccessInput input;
    private final ReusablePointer idPointer;
    private final ReusablePointer valuePointer;
    private final File edgeFile;
    private final GraphFactory graphFactory;
    private final int flushThreshold;
    private final EdgeFrequency frequency;

    public EdgesInput(ComputerContext context, File edgeFile) {
        this.graphFactory = context.graphFactory();
        this.idPointer = new ReusablePointer();
        this.valuePointer = new ReusablePointer();
        this.edgeFile = edgeFile;
        this.flushThreshold = (Integer)context.config().get((TypedOption)ComputerOptions.INPUT_MAX_EDGES_IN_ONE_VERTEX);
        this.frequency = (EdgeFrequency)context.config().get((TypedOption)ComputerOptions.INPUT_EDGE_FREQ);
    }

    public void init() throws IOException {
        this.input = new BufferedFileInput(this.edgeFile);
    }

    public void close() throws IOException {
        this.input.close();
    }

    public Edges edges(ReusablePointer vidPointer) {
        try {
            while (this.input.available() > 0L) {
                long startPosition = this.input.position();
                this.idPointer.read(this.input);
                int status = vidPointer.compareTo(this.idPointer);
                if (status < 0) {
                    this.input.seek(startPosition);
                    return EmptyEdges.instance();
                }
                if (status == 0) {
                    this.valuePointer.read(this.input);
                    Edges edges = this.readEdges(this.valuePointer.input());
                    if (edges.size() < this.flushThreshold) {
                        return edges;
                    }
                    return new SuperEdges(vidPointer, edges, startPosition);
                }
                int valueLength = this.input.readFixedInt();
                this.input.skip((long)valueLength);
            }
            return EmptyEdges.instance();
        }
        catch (IOException e) {
            throw new ComputerException("Can't read from edges input '%s'", (Throwable)e, new Object[]{this.edgeFile.getAbsoluteFile()});
        }
    }

    private Edges readEdges(RandomAccessInput in) {
        try {
            int count = in.readFixedInt();
            Edges edges = this.graphFactory.createEdges(count);
            if (this.frequency == EdgeFrequency.SINGLE) {
                for (int i = 0; i < count; ++i) {
                    Edge edge = this.graphFactory.createEdge();
                    edge.targetId(StreamGraphInput.readId(in));
                    Properties props = this.graphFactory.createProperties();
                    props.read(in);
                    edge.properties(props);
                    edges.add(edge);
                }
            } else if (this.frequency == EdgeFrequency.SINGLE_PER_LABEL) {
                for (int i = 0; i < count; ++i) {
                    Edge edge = this.graphFactory.createEdge();
                    edge.label(StreamGraphInput.readLabel(in));
                    edge.targetId(StreamGraphInput.readId(in));
                    Properties props = this.graphFactory.createProperties();
                    props.read(in);
                    edge.properties(props);
                    edges.add(edge);
                }
            } else {
                assert (this.frequency == EdgeFrequency.MULTIPLE);
                for (int i = 0; i < count; ++i) {
                    Edge edge = this.graphFactory.createEdge();
                    edge.label(StreamGraphInput.readLabel(in));
                    edge.name(StreamGraphInput.readLabel(in));
                    edge.targetId(StreamGraphInput.readId(in));
                    Properties props = this.graphFactory.createProperties();
                    props.read(in);
                    edge.properties(props);
                    edges.add(edge);
                }
            }
            return edges;
        }
        catch (IOException e) {
            throw new ComputerException("Failed to read edges from input '%s'", (Throwable)e, new Object[]{this.edgeFile.getAbsoluteFile()});
        }
    }

    public static class EmptyEdges
    implements Edges {
        private static final EmptyEdges INSTANCE = new EmptyEdges();

        private EmptyEdges() {
        }

        public static EmptyEdges instance() {
            return INSTANCE;
        }

        public int size() {
            return 0;
        }

        public void add(Edge edge) {
            throw new ComputerException("Not support adding edges during computing");
        }

        public Iterator<Edge> iterator() {
            return Collections.emptyIterator();
        }
    }

    private class SuperEdges
    implements Edges {
        private final ReusablePointer vid;
        private final long startPosition;
        private Iterator<Edge> currentEdgesIter;
        private int size;
        private int iterationTime;

        SuperEdges(ReusablePointer vid, Edges edges, long startPosition) {
            this.vid = vid;
            this.startPosition = startPosition;
            this.currentEdgesIter = edges.iterator();
            this.size = 0;
            this.iterationTime = 0;
        }

        public int size() {
            if (this.size == 0) {
                this.calculateSize();
            }
            return this.size;
        }

        private void calculateSize() {
            long currentPosition = EdgesInput.this.input.position();
            try {
                EdgesInput.this.input.seek(this.startPosition);
                EdgesInput.this.idPointer.read(EdgesInput.this.input);
                while (EdgesInput.this.idPointer.compareTo(this.vid) == 0) {
                    long valueLength = EdgesInput.this.input.readFixedInt();
                    this.size += EdgesInput.this.input.readInt();
                    long bytesToSkip = valueLength - 4L;
                    EdgesInput.this.input.skip(bytesToSkip);
                    if (EdgesInput.this.input.available() <= 0L) break;
                    EdgesInput.this.idPointer.read(EdgesInput.this.input);
                }
                EdgesInput.this.input.seek(currentPosition);
            }
            catch (IOException e) {
                throw new ComputerException("Compute size of edges failed", (Throwable)e);
            }
        }

        public void add(Edge edge) {
            throw new ComputerException("Not support adding edges during computing");
        }

        @Nonnull
        public Iterator<Edge> iterator() {
            try {
                if (this.iterationTime != 0) {
                    EdgesInput.this.input.seek(this.startPosition);
                }
                ++this.iterationTime;
            }
            catch (IOException e) {
                throw new ComputerException("Can't seek to %s", (Throwable)e, new Object[]{this.startPosition});
            }
            return new EdgesIterator();
        }

        private class EdgesIterator
        implements Iterator<Edge> {
            private EdgesIterator() {
            }

            @Override
            public boolean hasNext() {
                if (SuperEdges.this.currentEdgesIter.hasNext()) {
                    return true;
                }
                long currentPosition = EdgesInput.this.input.position();
                try {
                    if (EdgesInput.this.input.available() > 0L) {
                        EdgesInput.this.idPointer.read(EdgesInput.this.input);
                        if (EdgesInput.this.idPointer.compareTo(SuperEdges.this.vid) == 0) {
                            EdgesInput.this.valuePointer.read(EdgesInput.this.input);
                            SuperEdges.this.currentEdgesIter = EdgesInput.this.readEdges(EdgesInput.this.valuePointer.input()).iterator();
                        } else {
                            EdgesInput.this.input.seek(currentPosition);
                        }
                    }
                }
                catch (IOException e) {
                    throw new ComputerException("Error occurred when read edges from edges input '%s' at position %s", (Throwable)e, new Object[]{EdgesInput.this.edgeFile.getAbsoluteFile(), currentPosition});
                }
                return SuperEdges.this.currentEdgesIter.hasNext();
            }

            @Override
            public Edge next() {
                return SuperEdges.this.currentEdgesIter.next();
            }
        }
    }
}

