/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface WALActionsListener {
    default public void preLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    default public void postLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    default public void preLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    default public void postLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    default public void logRollRequested(boolean tooFewReplicas) {
    }

    default public void logCloseRequested() {
    }

    default public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
    }

    default public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
    }

    default public void postAppend(long entryLen, long elapsedTimeMillis, WALKey logKey, WALEdit logEdit) throws IOException {
    }

    default public void postSync(long timeInNanos, int handlerSyncs) {
    }
}

