/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api;

import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.util.E;

public abstract class API {
    public static final String CHARSET = "UTF-8";
    public static final String BATCH_ENCODING = "gzip";
    public static final long NO_LIMIT = -1L;
    public static final String PATH_SPLITOR = "/";
    protected final RestClient client;
    private String path;

    public API(RestClient client) {
        E.checkNotNull((Object)((Object)client), (String)"client");
        this.client = client;
        this.path = null;
    }

    public String path() {
        E.checkState((this.path != null ? 1 : 0) != 0, (String)"Path can't be null", (Object[])new Object[0]);
        return this.path;
    }

    protected void path(String path) {
        this.path = path;
    }

    protected void path(String pathTemplate, Object ... args) {
        this.path = String.format(pathTemplate, args);
    }

    protected abstract String type();

    protected static void checkOffset(long value) {
        E.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"Offset must be >= 0, but got: %s", (Object[])new Object[]{value});
    }

    protected static void checkLimit(long value, String name) {
        E.checkArgument((value > 0L || value == -1L ? 1 : 0) != 0, (String)"%s must be > 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }
}

