/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class PrimitiveMapper {
    public static final Map<Class, Class> primitiveToClassMap = PrimitiveMapper.getPrimitiveToClassMap();
    public static final Map<Class, Object> primitiveToDefaultValueMap = PrimitiveMapper.getPrimitiveToDefaultValueMap();

    private static Map<Class, Class> getPrimitiveToClassMap() {
        WeakHashMap<Class<Comparable<Boolean>>, Class> m3 = new WeakHashMap<Class<Comparable<Boolean>>, Class>();
        m3.put(Boolean.TYPE, Boolean.class);
        m3.put(Byte.TYPE, Byte.class);
        m3.put(Character.TYPE, Character.class);
        m3.put(Short.TYPE, Short.class);
        m3.put(Integer.TYPE, Integer.class);
        m3.put(Long.TYPE, Long.class);
        m3.put(Float.TYPE, Float.class);
        m3.put(Double.TYPE, Double.class);
        return Collections.unmodifiableMap(m3);
    }

    private static Map<Class, Object> getPrimitiveToDefaultValueMap() {
        WeakHashMap<Class, Comparable<Boolean>> m3 = new WeakHashMap<Class, Comparable<Boolean>>();
        m3.put(Boolean.class, Boolean.valueOf(false));
        m3.put(Byte.class, Byte.valueOf((byte)0));
        m3.put(Character.class, Character.valueOf('\u0000'));
        m3.put(Short.class, Short.valueOf((short)0));
        m3.put(Integer.class, Integer.valueOf(0));
        m3.put(Long.class, Long.valueOf(0L));
        m3.put(Float.class, Float.valueOf(0.0f));
        m3.put(Double.class, Double.valueOf(0.0));
        return Collections.unmodifiableMap(m3);
    }

    private PrimitiveMapper() {
    }
}

