/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.util.NumericUtil;

public final class ReflectionUtil {
    public static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || type.equals(String.class) || type.equals(Boolean.class) || type.equals(Character.class) || NumericUtil.isNumber(type);
    }

    public static List<Method> getMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> annotation, boolean withSuperClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Class<?> klass = type;
        do {
            for (Method method : klass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
        } while ((klass = klass.getSuperclass()) != Object.class && withSuperClass);
        return methods;
    }

    public static List<CtMethod> getMethodsAnnotatedWith(CtClass type, Class<? extends Annotation> annotation, boolean withSuperClass) throws NotFoundException {
        LinkedList<CtMethod> methods = new LinkedList<CtMethod>();
        CtClass klass = type;
        do {
            for (CtMethod method : klass.getDeclaredMethods()) {
                if (!method.hasAnnotation(annotation)) continue;
                methods.add(method);
            }
        } while ((klass = klass.getSuperclass()) != null && withSuperClass);
        return methods;
    }

    public static Iterator<ClassPath.ClassInfo> classes(String ... packages) throws IOException {
        ClassPath path = ClassPath.from(ReflectionUtil.class.getClassLoader());
        ExtendableIterator<ClassPath.ClassInfo> results = new ExtendableIterator<ClassPath.ClassInfo>();
        for (String p : packages) {
            results.extend(path.getTopLevelClassesRecursive(p).iterator());
        }
        return results;
    }

    public static List<String> superClasses(String clazz) throws NotFoundException {
        CtClass klass = ClassPool.getDefault().get(clazz);
        LinkedList<String> results = new LinkedList<String>();
        for (CtClass parent = klass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            results.add(parent.getName());
        }
        return Lists.reverse(results);
    }

    public static List<String> nestedClasses(String clazz) throws NotFoundException {
        CtClass klass = ClassPool.getDefault().get(clazz);
        LinkedList<String> results = new LinkedList<String>();
        for (CtClass nested : klass.getNestedClasses()) {
            results.add(nested.getName());
        }
        return results;
    }

    public static String packageName(String clazz) {
        int offset = clazz.lastIndexOf(".");
        if (offset > 0) {
            return clazz.substring(0, offset);
        }
        return "";
    }
}

