/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.structure.Element;
import org.apache.hugegraph.structure.constant.GraphAttachable;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ReflectionUtil;

public abstract class GraphElement
extends Element
implements GraphAttachable {
    protected GraphManager manager;
    @JsonProperty(value="label")
    protected String label;
    @JsonProperty(value="type")
    protected String type;
    @JsonProperty(value="properties")
    protected Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    @Override
    public void attachManager(GraphManager manager) {
        this.manager = manager;
    }

    public String label() {
        return this.label;
    }

    @Override
    public String type() {
        return this.type;
    }

    protected boolean fresh() {
        return this.manager == null;
    }

    public Object property(String key) {
        return this.properties.get(key);
    }

    public GraphElement property(String name, Object value) {
        E.checkArgumentNotNull(name, "property name", new Object[0]);
        E.checkArgumentNotNull(value, "property value", new Object[0]);
        Class<?> clazz = value.getClass();
        E.checkArgument(ReflectionUtil.isSimpleType(clazz) || clazz.equals(UUID.class) || clazz.equals(Date.class) || value instanceof List || value instanceof Set, "Invalid property value type: '%s'", clazz);
        this.properties.put(name, value);
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    protected abstract GraphElement setProperty(String var1, Object var2);

    public abstract GraphElement removeProperty(String var1);

    public int sizeOfProperties() {
        return this.properties.size();
    }
}

