/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.combiner.OverwritePropertiesCombiner;
import org.apache.hugegraph.computer.core.config.EdgeFrequency;
import org.apache.hugegraph.computer.core.config.Null;
import org.apache.hugegraph.computer.core.master.DefaultMasterComputation;
import org.apache.hugegraph.config.ConfigConvOption;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ComputerOptions
extends OptionHolder {
    private static final Logger LOG = Log.logger(ComputerOptions.class);
    public static final int TRANSPORT_DEFAULT_THREADS = 4;
    public static final String RPC_SERVER_HOST_NAME = "rpc.server_host";
    public static final String RPC_SERVER_PORT_NAME = "rpc.server_port";
    public static final String RPC_REMOTE_URL_NAME = "rpc.remote_url";
    private static volatile ComputerOptions INSTANCE;
    public static final ConfigOption<Class<?>> ALGORITHM_PARAMS_CLASS;
    public static final ConfigOption<Class<?>> ALGORITHM_RESULT_CLASS;
    public static final ConfigOption<Class<?>> ALGORITHM_MESSAGE_CLASS;
    public static final ConfigOption<String> INPUT_SOURCE_TYPE;
    public static final ConfigOption<Integer> INPUT_SPLIT_FETCH_TIMEOUT;
    public static final ConfigOption<Long> INPUT_SPLITS_SIZE;
    public static final ConfigOption<Integer> INPUT_MAX_SPLITS;
    public static final ConfigOption<Integer> INPUT_SPLIT_PAGE_SIZE;
    public static final ConfigOption<Class<?>> INPUT_FILTER_CLASS;
    public static final ConfigConvOption<String, Direction> INPUT_EDGE_DIRECTION;
    public static final ConfigConvOption<String, EdgeFrequency> INPUT_EDGE_FREQ;
    public static final ConfigOption<Integer> INPUT_MAX_EDGES_IN_ONE_VERTEX;
    public static final ConfigOption<String> INPUT_LOADER_STRUCT_PATH;
    public static final ConfigOption<String> INPUT_LOADER_SCHEMA_PATH;
    public static final ConfigOption<Integer> SORT_THREAD_NUMS;
    public static final ConfigOption<Class<?>> OUTPUT_CLASS;
    public static final ConfigOption<String> OUTPUT_RESULT_NAME;
    public static final ConfigOption<Boolean> OUTPUT_WITH_ADJACENT_EDGES;
    public static final ConfigOption<Boolean> OUTPUT_WITH_VERTEX_PROPERTIES;
    public static final ConfigOption<Boolean> OUTPUT_WITH_EDGE_PROPERTIES;
    public static final ConfigOption<String> OUTPUT_RESULT_WRITE_TYPE;
    public static final ConfigOption<Integer> OUTPUT_BATCH_SIZE;
    public static final ConfigOption<Integer> OUTPUT_BATCH_THREADS;
    public static final ConfigOption<Integer> OUTPUT_SINGLE_THREADS;
    public static final ConfigOption<Integer> OUTPUT_THREAD_POOL_SHUTDOWN_TIMEOUT;
    public static final ConfigOption<Integer> OUTPUT_RETRY_TIMES;
    public static final ConfigOption<Integer> OUTPUT_RETRY_INTERVAL;
    public static final ConfigOption<String> OUTPUT_HDFS_URL;
    public static final ConfigOption<String> OUTPUT_HDFS_USER;
    public static final ConfigOption<String> OUTPUT_HDFS_CORE_SITE_PATH;
    public static final ConfigOption<String> OUTPUT_HDFS_SITE_PATH;
    public static final ConfigOption<Short> OUTPUT_HDFS_REPLICATION;
    public static final ConfigOption<String> OUTPUT_HDFS_DIR;
    public static final ConfigOption<String> OUTPUT_HDFS_DELIMITER;
    public static final ConfigOption<Boolean> OUTPUT_HDFS_MERGE;
    public static final ConfigOption<Boolean> OUTPUT_HDFS_KERBEROS_ENABLE;
    public static final ConfigOption<String> OUTPUT_HDFS_KRB5_CONF;
    public static final ConfigOption<String> OUTPUT_HDFS_KERBEROS_PRINCIPAL;
    public static final ConfigOption<String> OUTPUT_HDFS_KERBEROS_KEYTAB;
    public static final ConfigOption<Integer> ALLOCATOR_MAX_VERTICES_PER_THREAD;
    public static final ConfigOption<String> JOB_ID;
    public static final ConfigOption<Integer> JOB_WORKERS_COUNT;
    public static final ConfigOption<Integer> JOB_PARTITIONS_COUNT;
    public static final ConfigOption<Integer> PARTITIONS_COMPUTE_THREAD_NUMS;
    public static final ConfigOption<Integer> BSP_MAX_SUPER_STEP;
    public static final ConfigOption<String> BSP_ETCD_ENDPOINTS;
    public static final ConfigOption<Long> BSP_REGISTER_TIMEOUT;
    public static final ConfigOption<Long> BSP_WAIT_WORKERS_TIMEOUT;
    public static final ConfigOption<Long> BSP_WAIT_MASTER_TIMEOUT;
    public static final ConfigOption<Long> BSP_LOG_INTERVAL;
    public static final ConfigOption<Class<?>> WORKER_PARTITIONER;
    public static final ConfigOption<Class<?>> WORKER_COMPUTATION_CLASS;
    public static final ConfigOption<Class<?>> WORKER_COMBINER_CLASS;
    public static final ConfigOption<Class<?>> WORKER_VERTEX_PROPERTIES_COMBINER_CLASS;
    public static final ConfigOption<Class<?>> WORKER_EDGE_PROPERTIES_COMBINER_CLASS;
    public static final ConfigOption<Long> WORKER_RECEIVED_BUFFERS_BYTES_LIMIT;
    public static final ConfigOption<Long> WORKER_WAIT_SORT_TIMEOUT;
    public static final ConfigOption<Long> WORKER_WAIT_FINISH_MESSAGES_TIMEOUT;
    public static final ConfigListOption<String> WORKER_DATA_DIRS;
    public static final ConfigOption<Integer> WORKER_WRITE_BUFFER_THRESHOLD;
    public static final ConfigOption<Integer> WORKER_WRITE_BUFFER_INIT_CAPACITY;
    public static final ConfigOption<Class<?>> MASTER_COMPUTATION_CLASS;
    public static final ConfigOption<String> HUGEGRAPH_URL;
    public static final ConfigOption<String> HUGEGRAPH_GRAPH_NAME;
    public static final ConfigOption<String> TRANSPORT_SERVER_HOST;
    public static final ConfigOption<Integer> TRANSPORT_SERVER_PORT;
    public static final ConfigOption<Integer> TRANSPORT_SERVER_THREADS;
    public static final ConfigOption<Integer> TRANSPORT_CLIENT_THREADS;
    public static final ConfigOption<Class<?>> TRANSPORT_PROVIDER_CLASS;
    public static final ConfigOption<String> TRANSPORT_IO_MODE;
    public static final ConfigOption<Boolean> TRANSPORT_EPOLL_LT;
    public static final ConfigOption<Boolean> TRANSPORT_RECV_FILE_MODE;
    public static final ConfigOption<Boolean> TRANSPORT_TCP_KEEP_ALIVE;
    public static final ConfigOption<Integer> TRANSPORT_MAX_SYN_BACKLOG;
    public static final ConfigOption<Integer> TRANSPORT_RECEIVE_BUFFER_SIZE;
    public static final ConfigOption<Integer> TRANSPORT_SEND_BUFFER_SIZE;
    public static final ConfigOption<Long> TRANSPORT_CLIENT_CONNECT_TIMEOUT;
    public static final ConfigOption<Long> TRANSPORT_CLOSE_TIMEOUT;
    public static final ConfigOption<Long> TRANSPORT_SYNC_REQUEST_TIMEOUT;
    public static final ConfigOption<Long> TRANSPORT_FINISH_SESSION_TIMEOUT;
    public static final ConfigOption<Long> TRANSPORT_WRITE_SOCKET_TIMEOUT;
    public static final ConfigOption<Integer> TRANSPORT_NETWORK_RETRIES;
    public static final ConfigOption<Integer> TRANSPORT_WRITE_BUFFER_HIGH_MARK;
    public static final ConfigOption<Integer> TRANSPORT_WRITE_BUFFER_LOW_MARK;
    public static final ConfigOption<Integer> TRANSPORT_MAX_PENDING_REQUESTS;
    public static final ConfigOption<Integer> TRANSPORT_MIN_PENDING_REQUESTS;
    public static final ConfigOption<Long> TRANSPORT_MIN_ACK_INTERVAL;
    public static final ConfigOption<Long> TRANSPORT_SERVER_IDLE_TIMEOUT;
    public static final ConfigOption<Long> TRANSPORT_HEARTBEAT_INTERVAL;
    public static final ConfigOption<Integer> TRANSPORT_MAX_TIMEOUT_HEARTBEAT_COUNT;
    public static final ConfigOption<Long> HGKV_MAX_FILE_SIZE;
    public static final ConfigOption<Long> HGKV_DATABLOCK_SIZE;
    public static final ConfigOption<Integer> HGKV_MERGE_FILES_NUM;
    public static final ConfigOption<String> HGKV_TEMP_DIR;
    public static final ConfigOption<Long> VALUE_FILE_MAX_SEGMENT_SIZE;
    public static Set<String> REQUIRED_OPTIONS;
    public static final Set<String> COMPUTER_PROHIBIT_USER_OPTIONS;
    public static final Set<String> COMPUTER_REQUIRED_USER_OPTIONS;

    private ComputerOptions() {
    }

    public static synchronized ComputerOptions instance() {
        if (INSTANCE == null) {
            INSTANCE = new ComputerOptions();
            INSTANCE.registerOptions();
        }
        return INSTANCE;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Load class {} failed, use Null.class", (Object)className);
            return Null.class;
        }
    }

    static {
        ALGORITHM_PARAMS_CLASS = new ConfigOption<Class<Null>>("algorithm.params_class", "The class used to transfer algorithms' parameters before algorithm been run.", OptionChecker.disallowEmpty(), Null.class);
        ALGORITHM_RESULT_CLASS = new ConfigOption<Class<Null>>("algorithm.result_class", "The class of vertex's value, the instance is used to store computation result for the vertex.", OptionChecker.disallowEmpty(), Null.class);
        ALGORITHM_MESSAGE_CLASS = new ConfigOption<Class<Null>>("algorithm.message_class", "The class of message passed when compute vertex.", OptionChecker.disallowEmpty(), Null.class);
        INPUT_SOURCE_TYPE = new ConfigOption<String>("input.source_type", "The source type to load input data", OptionChecker.allowValues("hugegraph-server", "hugegraph-loader"), "hugegraph-server");
        INPUT_SPLIT_FETCH_TIMEOUT = new ConfigOption<Integer>("input.split_fetch_timeout", "The timeout in seconds to fetch input splits", OptionChecker.positiveInt(), 300);
        INPUT_SPLITS_SIZE = new ConfigOption<Long>("input.split_size", "The input split size in bytes", OptionChecker.positiveInt(), 0x100000L);
        INPUT_MAX_SPLITS = new ConfigOption<Integer>("input.split_max_splits", "The maximum number of input splits", OptionChecker.positiveInt(), 10000000);
        INPUT_SPLIT_PAGE_SIZE = new ConfigOption<Integer>("input.split_page_size", "The page size for streamed load input split data", OptionChecker.positiveInt(), 500);
        INPUT_FILTER_CLASS = new ConfigOption("input.filter_class", "The class to create input-filter object, input-filter is used to Filter vertex edges according to user needs.", OptionChecker.disallowEmpty(), ComputerOptions.loadClass("org.apache.hugegraph.computer.core.input.filter.DefaultInputFilter"));
        INPUT_EDGE_DIRECTION = new ConfigConvOption<String, Direction>("input.edge_direction", "The data of the edge in which direction is loaded, when the value is BOTH, the edges in both OUT and IN direction will be loaded.", OptionChecker.allowValues("OUT", "IN", "BOTH"), Direction::valueOf, "OUT");
        INPUT_EDGE_FREQ = new ConfigConvOption<String, EdgeFrequency>("input.edge_freq", "The frequency of edges can exist between a pair of vertices, allowed values: [SINGLE, SINGLE_PER_LABEL, MULTIPLE]. SINGLE means that only one edge can exist between a pair of vertices, use sourceId + targetId to identify it; SINGLE_PER_LABEL means that each edge label can exist one edge between a pair of vertices, use sourceId + edgelabel + targetId to identify it; MULTIPLE means that many edge can exist between a pair of vertices, use sourceId + edgelabel + sortValues + targetId to identify it.", OptionChecker.allowValues("SINGLE", "SINGLE_PER_LABEL", "MULTIPLE"), EdgeFrequency::valueOf, "MULTIPLE");
        INPUT_MAX_EDGES_IN_ONE_VERTEX = new ConfigOption<Integer>("input.max_edges_in_one_vertex", "The maximum number of adjacent edges allowed to be attached to a vertex, the adjacent edges will be stored and transferred together as a batch unit.", OptionChecker.positiveInt(), 200);
        INPUT_LOADER_STRUCT_PATH = new ConfigOption<String>("input.loader_struct_path", "The struct path of loader input, only takes effect when the input.source_type=loader is enabled", null, "");
        INPUT_LOADER_SCHEMA_PATH = new ConfigOption<String>("input.loader_schema_path", "The schema path of loader input, only takes effect when the input.source_type=loader is enabled", null, "");
        SORT_THREAD_NUMS = new ConfigOption<Integer>("sort.thread_nums", "The number of threads performing internal sorting.", OptionChecker.positiveInt(), 4);
        OUTPUT_CLASS = new ConfigOption("output.output_class", "The class to output the computation result of each vertex. Be called after iteration computation.", OptionChecker.disallowEmpty(), ComputerOptions.loadClass("org.apache.hugegraph.computer.core.output.LogOutput"));
        OUTPUT_RESULT_NAME = new ConfigOption<String>("output.result_name", "The value is assigned dynamically by #name() of instance created by WORKER_COMPUTATION_CLASS.", OptionChecker.disallowEmpty(), "value");
        OUTPUT_WITH_ADJACENT_EDGES = new ConfigOption<Boolean>("output.with_adjacent_edges", "Output the adjacent edges of the vertex or not", OptionChecker.allowValues(true, false), false);
        OUTPUT_WITH_VERTEX_PROPERTIES = new ConfigOption<Boolean>("output.with_vertex_properties", "Output the properties of the vertex or not", OptionChecker.allowValues(true, false), false);
        OUTPUT_WITH_EDGE_PROPERTIES = new ConfigOption<Boolean>("output.with_edge_properties", "Output the properties of the edge or not", OptionChecker.allowValues(true, false), false);
        OUTPUT_RESULT_WRITE_TYPE = new ConfigOption<String>("output.result_write_type", "The result write-type to output to hugegraph, allowed values are: [OLAP_COMMON, OLAP_SECONDARY, OLAP_RANGE].", OptionChecker.allowValues("OLAP_COMMON", "OLAP_SECONDARY", "OLAP_RANGE"), "OLAP_COMMON");
        OUTPUT_BATCH_SIZE = new ConfigOption<Integer>("output.batch_size", "The batch size of output", OptionChecker.positiveInt(), 500);
        OUTPUT_BATCH_THREADS = new ConfigOption<Integer>("output.batch_threads", "The threads number used to batch output", OptionChecker.positiveInt(), 1);
        OUTPUT_SINGLE_THREADS = new ConfigOption<Integer>("output.single_threads", "The threads number used to single output", OptionChecker.positiveInt(), 1);
        OUTPUT_THREAD_POOL_SHUTDOWN_TIMEOUT = new ConfigOption<Integer>("output.thread_pool_shutdown_timeout", "The timeout seconds of output threads pool shutdown", OptionChecker.positiveInt(), 60);
        OUTPUT_RETRY_TIMES = new ConfigOption<Integer>("output.retry_times", "The retry times when output failed", OptionChecker.positiveInt(), 3);
        OUTPUT_RETRY_INTERVAL = new ConfigOption<Integer>("output.retry_interval", "The retry interval when output failed", OptionChecker.positiveInt(), 10);
        OUTPUT_HDFS_URL = new ConfigOption<String>("output.hdfs_url", "The hdfs url of output.", OptionChecker.disallowEmpty(), "hdfs://127.0.0.1:9000");
        OUTPUT_HDFS_USER = new ConfigOption<String>("output.hdfs_user", "The hdfs user of output.", OptionChecker.disallowEmpty(), "hadoop");
        OUTPUT_HDFS_CORE_SITE_PATH = new ConfigOption<String>("output.hdfs_core_site_path", "The hdfs core site path.", null, "");
        OUTPUT_HDFS_SITE_PATH = new ConfigOption<String>("output.hdfs_site_path", "The hdfs site path.", null, "");
        OUTPUT_HDFS_REPLICATION = new ConfigOption<Short>("output.hdfs_replication", "The replication number of hdfs.", OptionChecker.positiveInt(), (short)3);
        OUTPUT_HDFS_DIR = new ConfigOption<String>("output.hdfs_path_prefix", "The directory of hdfs output result.", OptionChecker.disallowEmpty(), "/hugegraph-computer/results");
        OUTPUT_HDFS_DELIMITER = new ConfigOption<String>("output.hdfs_delimiter", "The delimiter of hdfs output.", OptionChecker.disallowEmpty(), ",");
        OUTPUT_HDFS_MERGE = new ConfigOption<Boolean>("output.hdfs_merge_partitions", "Whether merge output files of multiple partitions.", OptionChecker.allowValues(true, false), true);
        OUTPUT_HDFS_KERBEROS_ENABLE = new ConfigOption<Boolean>("output.hdfs_kerberos_enable", "Is Kerberos authentication enabled for Hdfs.", OptionChecker.allowValues(true, false), false);
        OUTPUT_HDFS_KRB5_CONF = new ConfigOption<String>("output.hdfs_krb5_conf", "Kerberos configuration file.", OptionChecker.disallowEmpty(), "/etc/krb5.conf");
        OUTPUT_HDFS_KERBEROS_PRINCIPAL = new ConfigOption<String>("output.hdfs_kerberos_principal", "The Hdfs's principal for kerberos authentication.", null, "");
        OUTPUT_HDFS_KERBEROS_KEYTAB = new ConfigOption<String>("output.hdfs_kerberos_keytab", "The Hdfs's key tab file for kerberos authentication.", null, "");
        ALLOCATOR_MAX_VERTICES_PER_THREAD = new ConfigOption<Integer>("allocator.max_vertices_per_thread", "Maximum number of vertices per thread processed in each memory allocator", OptionChecker.positiveInt(), 10000);
        JOB_ID = new ConfigOption<String>("job.id", "The job id on Yarn cluster or K8s cluster.", OptionChecker.disallowEmpty(), "local_0001");
        JOB_WORKERS_COUNT = new ConfigOption<Integer>("job.workers_count", "The workers count for computing one graph algorithm job.", OptionChecker.positiveInt(), 1);
        JOB_PARTITIONS_COUNT = new ConfigOption<Integer>("job.partitions_count", "The partitions count for computing one graph algorithm job.", OptionChecker.positiveInt(), 1);
        PARTITIONS_COMPUTE_THREAD_NUMS = new ConfigOption<Integer>("job.partitions_thread_nums", "The number of threads for partition parallel compute.", OptionChecker.positiveInt(), 4);
        BSP_MAX_SUPER_STEP = new ConfigOption<Integer>("bsp.max_super_step", "The max super step of the algorithm.", OptionChecker.positiveInt(), 10);
        BSP_ETCD_ENDPOINTS = new ConfigOption<String>("bsp.etcd_endpoints", "The end points to access etcd.", OptionChecker.disallowEmpty(), "http://localhost:2379");
        BSP_REGISTER_TIMEOUT = new ConfigOption<Long>("bsp.register_timeout", "The max timeout to wait for master and works to register.", OptionChecker.positiveInt(), TimeUnit.MINUTES.toMillis(5L));
        BSP_WAIT_WORKERS_TIMEOUT = new ConfigOption<Long>("bsp.wait_workers_timeout", "The max timeout to wait for workers bsp event.", OptionChecker.positiveInt(), TimeUnit.HOURS.toMillis(24L));
        BSP_WAIT_MASTER_TIMEOUT = new ConfigOption<Long>("bsp.wait_master_timeout", "The max timeout(in ms) to wait for master bsp event.", OptionChecker.positiveInt(), TimeUnit.HOURS.toMillis(24L));
        BSP_LOG_INTERVAL = new ConfigOption<Long>("bsp.log_interval", "The log interval(in ms) to print the log while waiting bsp event.", OptionChecker.positiveInt(), TimeUnit.SECONDS.toMillis(30L));
        WORKER_PARTITIONER = new ConfigOption("worker.partitioner", "The partitioner that decides which partition a vertex should be in, and which worker a partition should be in.", OptionChecker.disallowEmpty(), ComputerOptions.loadClass("org.apache.hugegraph.computer.core.graph.partition.HashPartitioner"));
        WORKER_COMPUTATION_CLASS = new ConfigOption<Class<Null>>("worker.computation_class", "The class to create worker-computation object, worker-computation is used to compute each vertex in each superstep.", OptionChecker.disallowEmpty(), Null.class);
        WORKER_COMBINER_CLASS = new ConfigOption<Class<Null>>("worker.combiner_class", "Combiner can combine messages into one value for a vertex, for example page-rank algorithm can combine messages of a vertex to a sum value.", OptionChecker.disallowEmpty(), Null.class);
        WORKER_VERTEX_PROPERTIES_COMBINER_CLASS = new ConfigOption<Class<OverwritePropertiesCombiner>>("worker.vertex_properties_combiner_class", "The combiner can combine several properties of the same vertex into one properties at inputstep.", OptionChecker.disallowEmpty(), OverwritePropertiesCombiner.class);
        WORKER_EDGE_PROPERTIES_COMBINER_CLASS = new ConfigOption<Class<OverwritePropertiesCombiner>>("worker.edge_properties_combiner_class", "The combiner can combine several properties of the same edge into one properties at inputstep.", OptionChecker.disallowEmpty(), OverwritePropertiesCombiner.class);
        WORKER_RECEIVED_BUFFERS_BYTES_LIMIT = new ConfigOption<Long>("worker.received_buffers_bytes_limit", "The limit bytes of buffers of received data, the total size of all buffers can't excess this limit. If received buffers reach this limit, they will be merged into a file.", OptionChecker.positiveInt(), 0x6400000L);
        WORKER_WAIT_SORT_TIMEOUT = new ConfigOption<Long>("worker.wait_sort_timeout", "The max timeout(in ms) message-handler wait for sort-thread to sort one batch of buffers.", OptionChecker.positiveInt(), TimeUnit.MINUTES.toMillis(10L));
        WORKER_WAIT_FINISH_MESSAGES_TIMEOUT = new ConfigOption<Long>("worker.wait_finish_messages_timeout", "The max timeout(in ms) message-handler wait for finish-message of all workers.", OptionChecker.positiveInt(), TimeUnit.HOURS.toMillis(24L));
        WORKER_DATA_DIRS = new ConfigListOption<String>("worker.data_dirs", true, "The directories separated by ',' that received vertices and messages can persist into.", OptionChecker.disallowEmpty(), String.class, ImmutableList.of("jobs"));
        WORKER_WRITE_BUFFER_THRESHOLD = new ConfigOption<Integer>("worker.write_buffer_threshold", "The threshold of write buffer, exceeding it will trigger sorting, the write buffer is used to store vertex or message.", OptionChecker.positiveInt(), 0x3200000);
        WORKER_WRITE_BUFFER_INIT_CAPACITY = new ConfigOption<Integer>("worker.write_buffer_capacity", "The initial size of write buffer that used to store vertex or message.", OptionChecker.positiveInt(), 0x3200000);
        MASTER_COMPUTATION_CLASS = new ConfigOption<Class<DefaultMasterComputation>>("master.computation_class", "Master-computation is computation that can determine whether to continue next superstep. It runs at the end of each superstep on master.", OptionChecker.disallowEmpty(), DefaultMasterComputation.class);
        HUGEGRAPH_URL = new ConfigOption<String>("hugegraph.url", "The hugegraph url to load data and write results back.", OptionChecker.disallowEmpty(), "http://127.0.0.1:8080");
        HUGEGRAPH_GRAPH_NAME = new ConfigOption<String>("hugegraph.name", "The graph name to load data and write results back.", OptionChecker.disallowEmpty(), "hugegraph");
        TRANSPORT_SERVER_HOST = new ConfigOption<String>("transport.server_host", "The server hostname or ip to listen on to transfer data.", OptionChecker.disallowEmpty(), "127.0.0.1");
        TRANSPORT_SERVER_PORT = new ConfigOption<Integer>("transport.server_port", "The server port to listen on to transfer data. The system will assign a random port if it's set to 0.", OptionChecker.nonNegativeInt(), 0);
        TRANSPORT_SERVER_THREADS = new ConfigOption<Integer>("transport.server_threads", "The number of transport threads for server.", OptionChecker.positiveInt(), 4);
        TRANSPORT_CLIENT_THREADS = new ConfigOption<Integer>("transport.client_threads", "The number of transport threads for client.", OptionChecker.positiveInt(), 4);
        TRANSPORT_PROVIDER_CLASS = new ConfigOption("transport.provider_class", "The transport provider, currently only supports Netty.", OptionChecker.disallowEmpty(), ComputerOptions.loadClass("org.apache.hugegraph.computer.core.network.netty.NettyTransportProvider"));
        TRANSPORT_IO_MODE = new ConfigOption<String>("transport.io_mode", "The network IO Mode, either 'NIO', 'EPOLL', 'AUTO', the 'AUTO' means selecting the property mode automatically.", OptionChecker.allowValues("NIO", "EPOLL", "AUTO"), "AUTO");
        TRANSPORT_EPOLL_LT = new ConfigOption<Boolean>("transport.transport_epoll_lt", "Whether enable EPOLL level-trigger.", OptionChecker.allowValues(true, false), false);
        TRANSPORT_RECV_FILE_MODE = new ConfigOption<Boolean>("transport.recv_file_mode", "Whether enable receive buffer-file mode, it will receive buffer write file from socket by zero-copy if enable.", OptionChecker.allowValues(true, false), true);
        TRANSPORT_TCP_KEEP_ALIVE = new ConfigOption<Boolean>("transport.tcp_keep_alive", "Whether enable TCP keep-alive.", OptionChecker.allowValues(true, false), true);
        TRANSPORT_MAX_SYN_BACKLOG = new ConfigOption<Integer>("transport.max_syn_backlog", "The capacity of SYN queue on server side, 0 means using system default value.", OptionChecker.nonNegativeInt(), 511);
        TRANSPORT_RECEIVE_BUFFER_SIZE = new ConfigOption<Integer>("transport.receive_buffer_size", "The size of socket receive-buffer in bytes, 0 means using system default value.", OptionChecker.nonNegativeInt(), 0);
        TRANSPORT_SEND_BUFFER_SIZE = new ConfigOption<Integer>("transport.send_buffer_size", "The size of socket send-buffer in bytes, 0 means using system default value.", OptionChecker.nonNegativeInt(), 0);
        TRANSPORT_CLIENT_CONNECT_TIMEOUT = new ConfigOption<Long>("transport.client_connect_timeout", "The timeout(in ms) of client connect to server.", OptionChecker.positiveInt(), 3000L);
        TRANSPORT_CLOSE_TIMEOUT = new ConfigOption<Long>("transport.close_timeout", "The timeout(in ms) of close server or close client.", OptionChecker.positiveInt(), 10000L);
        TRANSPORT_SYNC_REQUEST_TIMEOUT = new ConfigOption<Long>("transport.sync_request_timeout", "The timeout(in ms) to wait response after sending sync-request.", OptionChecker.positiveInt(), 10000L);
        TRANSPORT_FINISH_SESSION_TIMEOUT = new ConfigOption<Long>("transport.finish_session_timeout", "The timeout(in ms) to finish session, 0 means using (transport.sync_request_timeout * transport.max_pending_requests).", OptionChecker.nonNegativeInt(), 0L);
        TRANSPORT_WRITE_SOCKET_TIMEOUT = new ConfigOption<Long>("transport.write_socket_timeout", "The timeout(in ms) to write data to socket buffer.", OptionChecker.positiveInt(), 3000L);
        TRANSPORT_NETWORK_RETRIES = new ConfigOption<Integer>("transport.network_retries", "The number of retry attempts for network communication,if network unstable.", OptionChecker.nonNegativeInt(), 3);
        TRANSPORT_WRITE_BUFFER_HIGH_MARK = new ConfigOption<Integer>("transport.write_buffer_high_mark", "The high water mark for write buffer in bytes, it will trigger the sending unavailable if the number of queued bytes > write_buffer_high_mark.", OptionChecker.nonNegativeInt(), 0x4000000);
        TRANSPORT_WRITE_BUFFER_LOW_MARK = new ConfigOption<Integer>("transport.write_buffer_low_mark", "The low water mark for write buffer in bytes, it will trigger the sending available if the number of queued bytes < write_buffer_low_mark." + OptionChecker.nonNegativeInt(), 0x2000000);
        TRANSPORT_MAX_PENDING_REQUESTS = new ConfigOption<Integer>("transport.max_pending_requests", "The max number of client unreceived ack, it will trigger the sending unavailable if the number of unreceived ack >= max_pending_requests.", OptionChecker.positiveInt(), 8);
        TRANSPORT_MIN_PENDING_REQUESTS = new ConfigOption<Integer>("transport.min_pending_requests", "The minimum number of client unreceived ack, it will trigger the sending available if the number of unreceived ack < min_pending_requests.", OptionChecker.positiveInt(), 6);
        TRANSPORT_MIN_ACK_INTERVAL = new ConfigOption<Long>("transport.min_ack_interval", "The minimum interval(in ms) of server reply ack.", OptionChecker.positiveInt(), 200L);
        TRANSPORT_SERVER_IDLE_TIMEOUT = new ConfigOption<Long>("transport.server_idle_timeout", "The max timeout(in ms) of server idle.", OptionChecker.positiveInt(), 360000L);
        TRANSPORT_HEARTBEAT_INTERVAL = new ConfigOption<Long>("transport.heartbeat_interval", "The minimum interval(in ms) between heartbeats on client side.", OptionChecker.positiveInt(), 20000L);
        TRANSPORT_MAX_TIMEOUT_HEARTBEAT_COUNT = new ConfigOption<Integer>("transport.max_timeout_heartbeat_count", "The maximum times of timeout heartbeat on client side, if the number of timeouts waiting for heartbeat response continuously > max_heartbeat_timeouts the channel will be closed from client side.", OptionChecker.positiveInt(), 120);
        HGKV_MAX_FILE_SIZE = new ConfigOption<Long>("hgkv.max_file_size", "The max number of bytes in each hgkv-file.", OptionChecker.positiveInt(), 0x80000000L);
        HGKV_DATABLOCK_SIZE = new ConfigOption<Long>("hgkv.max_data_block_size", "The max byte size of hgkv-file data block.", OptionChecker.positiveInt(), 65536L);
        HGKV_MERGE_FILES_NUM = new ConfigOption<Integer>("hgkv.max_merge_files", "The max number of files to merge at one time.", OptionChecker.positiveInt(), 10);
        HGKV_TEMP_DIR = new ConfigOption<String>("hgkv.temp_file_dir", "This folder is used to store temporary files, temporary files will be generated during the file merging process.", OptionChecker.disallowEmpty(), "/tmp/hgkv");
        VALUE_FILE_MAX_SEGMENT_SIZE = new ConfigOption<Long>("valuefile.max_segment_size", "The max number of bytes in each segment of value-file.", OptionChecker.positiveInt(), 0x40000000L);
        REQUIRED_OPTIONS = ImmutableSet.of();
        COMPUTER_PROHIBIT_USER_OPTIONS = ImmutableSet.of(BSP_ETCD_ENDPOINTS.name(), TRANSPORT_SERVER_HOST.name(), TRANSPORT_SERVER_PORT.name(), JOB_ID.name(), JOB_WORKERS_COUNT.name(), RPC_SERVER_HOST_NAME, new String[]{RPC_SERVER_PORT_NAME, RPC_REMOTE_URL_NAME});
        COMPUTER_REQUIRED_USER_OPTIONS = ImmutableSet.of(ALGORITHM_PARAMS_CLASS.name());
    }
}

