/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.schema.SchemaElementAPI;
import org.apache.hugegraph.api.task.TaskAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.util.E;

public class EdgeLabelAPI
extends SchemaElementAPI {
    public EdgeLabelAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.EDGE_LABEL.string();
    }

    public EdgeLabel create(EdgeLabel edgeLabel) {
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.post(this.path(), el);
        return result.readObject(EdgeLabel.class);
    }

    public EdgeLabel append(EdgeLabel edgeLabel) {
        String id = edgeLabel.name();
        ImmutableMap<String, Object> params = ImmutableMap.of("action", "append");
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.put(this.path(), id, el, params);
        return result.readObject(EdgeLabel.class);
    }

    public EdgeLabel eliminate(EdgeLabel edgeLabel) {
        String id = edgeLabel.name();
        ImmutableMap<String, Object> params = ImmutableMap.of("action", "eliminate");
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.put(this.path(), id, el, params);
        return result.readObject(EdgeLabel.class);
    }

    public EdgeLabel get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return result.readObject(EdgeLabel.class);
    }

    public List<EdgeLabel> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), EdgeLabel.class);
    }

    public List<EdgeLabel> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument(names != null && !names.isEmpty(), "The edge label names can't be null or empty", new Object[0]);
        ImmutableMap<String, Object> params = ImmutableMap.of("names", names);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), EdgeLabel.class);
    }

    public long delete(String name) {
        RestResult result = this.client.delete(this.path(), name);
        Map task = result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        EdgeLabel edgeLabel;
        SchemaLabel el = edgeLabel = (EdgeLabel)schemaElement;
        if (this.client.apiVersionLt("0.54")) {
            E.checkArgument(edgeLabel.ttl() == 0L && edgeLabel.ttlStartTime() == null, "Not support ttl until api version 0.54", new Object[0]);
            el = edgeLabel.switchV53();
        }
        return el;
    }
}

