/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import java.util.Map;
import java.util.UUID;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.glassfish.jersey.uri.UriComponent;

public abstract class GraphAPI
extends API {
    private static final String PATH = "graphs/%s/graph/%s";
    private final String batchPath;

    public GraphAPI(RestClient client, String graph) {
        super(client);
        this.path(PATH, graph, this.type());
        this.batchPath = String.join((CharSequence)"/", this.path(), "batch");
    }

    public String batchPath() {
        return this.batchPath;
    }

    public static String formatVertexId(Object id) {
        return GraphAPI.formatVertexId(id, false);
    }

    public static String formatVertexId(Object id, boolean allowNull) {
        if (!allowNull) {
            E.checkArgumentNotNull(id, "The vertex id can't be null", new Object[0]);
        } else if (id == null) {
            return null;
        }
        boolean uuid = id instanceof UUID;
        if (uuid) {
            id = id.toString();
        }
        E.checkArgument(id instanceof String || id instanceof Number, "The vertex id must be either String or Number, but got '%s'", id);
        return (uuid ? "U" : "") + JsonUtil.toJson(id);
    }

    public static String formatProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        String json = JsonUtil.toJson(properties);
        return GraphAPI.encode(json);
    }

    public static String encode(String raw) {
        return UriComponent.encode(raw, UriComponent.Type.QUERY_PARAM_SPACE_ENCODED);
    }
}

