/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.testutil;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class Assert
extends org.junit.Assert {
    public static void assertThrows(Class<? extends Throwable> throwable, ThrowableRunnable runnable) {
        CompletableFuture<Throwable> future = Assert.assertThrowsFuture(throwable, runnable);
        future.thenAccept(System.err::println);
    }

    public static void assertThrows(Class<? extends Throwable> throwable, ThrowableRunnable runnable, Consumer<Throwable> exceptionConsumer) {
        CompletableFuture<Throwable> future = Assert.assertThrowsFuture(throwable, runnable);
        future.thenAccept((Consumer)exceptionConsumer);
    }

    public static CompletableFuture<Throwable> assertThrowsFuture(Class<? extends Throwable> clazz, ThrowableRunnable runnable) {
        CompletableFuture<Throwable> future = new CompletableFuture<Throwable>();
        boolean fail = false;
        try {
            runnable.run();
            fail = true;
        }
        catch (Throwable e) {
            if (!clazz.isInstance(e)) {
                Assert.fail((String)String.format("Bad exception type %s(expected %s)", e.getClass().getName(), clazz.getName()));
            }
            future.complete(e);
        }
        if (fail) {
            String msg = String.format("No exception was thrown(expected %s)", clazz.getName());
            future.completeExceptionally((Throwable)((Object)new AssertionError((Object)msg)));
            Assert.fail((String)msg);
        }
        return future;
    }

    public static void assertEquals(byte expected, Object actual) {
        org.junit.Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(short expected, Object actual) {
        org.junit.Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(char expected, Object actual) {
        org.junit.Assert.assertEquals((Object)Character.valueOf(expected), (Object)actual);
    }

    public static void assertEquals(int expected, Object actual) {
        org.junit.Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(long expected, Object actual) {
        org.junit.Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertEquals(float expected, Object actual) {
        org.junit.Assert.assertEquals((Object)Float.valueOf(expected), (Object)actual);
    }

    public static void assertEquals(double expected, Object actual) {
        org.junit.Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static void assertGt(Number expected, Object actual) {
        org.junit.Assert.assertThat((Object)actual, (Matcher)new NumberMatcher(expected, cmp -> cmp > 0, ">"));
    }

    public static void assertGte(Number expected, Object actual) {
        org.junit.Assert.assertThat((Object)actual, (Matcher)new NumberMatcher(expected, cmp -> cmp >= 0, ">="));
    }

    public static void assertLt(Number expected, Object actual) {
        org.junit.Assert.assertThat((Object)actual, (Matcher)new NumberMatcher(expected, cmp -> cmp < 0, "<"));
    }

    public static void assertLte(Number expected, Object actual) {
        org.junit.Assert.assertThat((Object)actual, (Matcher)new NumberMatcher(expected, cmp -> cmp <= 0, "<="));
    }

    public static void assertContains(String sub, String actual) {
        org.junit.Assert.assertThat((Object)actual, (Matcher)CoreMatchers.containsString((String)sub));
    }

    public static void assertInstanceOf(Class<?> clazz, Object object) {
        org.junit.Assert.assertThat((Object)object, (Matcher)CoreMatchers.instanceOf(clazz));
    }

    private static class NumberMatcher
    extends BaseMatcher<Object> {
        private final String symbol;
        private final Number expected;
        private final Function<Integer, Boolean> cmp;

        NumberMatcher(Number expected, Function<Integer, Boolean> cmp, String symbol) {
            this.expected = expected;
            this.cmp = cmp;
            this.symbol = symbol;
        }

        public boolean matches(Object actual) {
            Assert.assertInstanceOf(this.expected.getClass(), actual);
            Assert.assertInstanceOf(Comparable.class, actual);
            int cmp = ((Comparable)actual).compareTo(this.expected);
            return this.cmp.apply(cmp);
        }

        public void describeTo(Description desc) {
            desc.appendText("a number ").appendText(this.symbol).appendText(" ").appendText(this.expected.toString());
        }
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Throwable;
    }
}

