/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import io.grpc.Attributes;
import io.grpc.ChannelLogger;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.JettyTlsUtil;
import io.grpc.netty.NettyClientTransport;
import io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

final class ProtocolNegotiators {
    private static final Logger log = Logger.getLogger(ProtocolNegotiators.class.getName());

    private ProtocolNegotiators() {
    }

    static ChannelLogger negotiationLogger(ChannelHandlerContext ctx) {
        return ProtocolNegotiators.negotiationLogger((AttributeMap)ctx.channel());
    }

    private static ChannelLogger negotiationLogger(AttributeMap attributeMap) {
        Attribute attr = attributeMap.attr(NettyClientTransport.LOGGER_KEY);
        ChannelLogger channelLogger = (ChannelLogger)attr.get();
        if (channelLogger != null) {
            return channelLogger;
        }
        final class NoopChannelLogger
        extends ChannelLogger {
            NoopChannelLogger() {
            }

            public void log(ChannelLogger.ChannelLogLevel level, String message) {
            }

            public void log(ChannelLogger.ChannelLogLevel level, String messageFormat, Object ... args) {
            }
        }
        return new NoopChannelLogger();
    }

    public static ProtocolNegotiator serverPlaintext() {
        return new PlaintextProtocolNegotiator();
    }

    public static ProtocolNegotiator serverTls(final SslContext sslContext, final ObjectPool<? extends Executor> executorPool) {
        Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        final Executor executor = executorPool != null ? (Executor)executorPool.getObject() : null;
        return new ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler handler) {
                GrpcNegotiationHandler gnh = new GrpcNegotiationHandler(handler);
                ServerTlsHandler sth = new ServerTlsHandler((ChannelHandler)gnh, sslContext, (ObjectPool<? extends Executor>)executorPool);
                return new WaitUntilActiveHandler((ChannelHandler)sth);
            }

            @Override
            public void close() {
                if (executorPool != null && executor != null) {
                    executorPool.returnObject((Object)executor);
                }
            }

            @Override
            public AsciiString scheme() {
                return Utils.HTTPS;
            }
        };
    }

    public static ProtocolNegotiator serverTls(SslContext sslContext) {
        return ProtocolNegotiators.serverTls(sslContext, null);
    }

    public static ProtocolNegotiator httpProxy(final SocketAddress proxyAddress, final @Nullable String proxyUsername, final @Nullable String proxyPassword, final ProtocolNegotiator negotiator) {
        Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        Preconditions.checkNotNull((Object)proxyAddress, (Object)"proxyAddress");
        final AsciiString scheme = negotiator.scheme();
        class ProxyNegotiator
        implements ProtocolNegotiator {
            ProxyNegotiator() {
            }

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler http2Handler) {
                ChannelHandler protocolNegotiationHandler = negotiator.newHandler(http2Handler);
                return new ProxyProtocolNegotiationHandler(proxyAddress, proxyUsername, proxyPassword, protocolNegotiationHandler);
            }

            @Override
            public AsciiString scheme() {
                return scheme;
            }

            @Override
            public void close() {
                negotiator.close();
            }
        }
        return new ProxyNegotiator();
    }

    @VisibleForTesting
    static HostPort parseAuthority(String authority) {
        int port;
        String host;
        URI uri = GrpcUtil.authorityToUri((String)((String)Preconditions.checkNotNull((Object)authority, (Object)"authority")));
        if (uri.getHost() != null) {
            host = uri.getHost();
            port = uri.getPort();
        } else {
            host = authority;
            port = -1;
        }
        return new HostPort(host, port);
    }

    public static ProtocolNegotiator tls(SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
        return new ClientTlsProtocolNegotiator(sslContext, executorPool);
    }

    public static ProtocolNegotiator tls(SslContext sslContext) {
        return ProtocolNegotiators.tls(sslContext, null);
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new PlaintextUpgradeProtocolNegotiator();
    }

    public static ProtocolNegotiator plaintext() {
        return new PlaintextProtocolNegotiator();
    }

    private static RuntimeException unavailableException(String msg) {
        return Status.UNAVAILABLE.withDescription(msg).asRuntimeException();
    }

    @VisibleForTesting
    static void logSslEngineDetails(Level level, ChannelHandlerContext ctx, String msg, @Nullable Throwable t) {
        if (!log.isLoggable(level)) {
            return;
        }
        SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
        SSLEngine engine = sslHandler.engine();
        StringBuilder builder = new StringBuilder(msg);
        builder.append("\nSSLEngine Details: [\n");
        if (engine instanceof OpenSslEngine) {
            builder.append("    OpenSSL, ");
            builder.append("Version: 0x").append(Integer.toHexString(OpenSsl.version()));
            builder.append(" (").append(OpenSsl.versionString()).append("), ");
            builder.append("ALPN supported: ").append(SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL));
        } else if (JettyTlsUtil.isJettyAlpnConfigured()) {
            builder.append("    Jetty ALPN");
        } else if (JettyTlsUtil.isJettyNpnConfigured()) {
            builder.append("    Jetty NPN");
        } else if (JettyTlsUtil.isJava9AlpnAvailable()) {
            builder.append("    JDK9 ALPN");
        }
        builder.append("\n    TLS Protocol: ");
        builder.append(engine.getSession().getProtocol());
        builder.append("\n    Application Protocol: ");
        builder.append(sslHandler.applicationProtocol());
        builder.append("\n    Need Client Auth: ");
        builder.append(engine.getNeedClientAuth());
        builder.append("\n    Want Client Auth: ");
        builder.append(engine.getWantClientAuth());
        builder.append("\n    Supported protocols=");
        builder.append(Arrays.toString(engine.getSupportedProtocols()));
        builder.append("\n    Enabled protocols=");
        builder.append(Arrays.toString(engine.getEnabledProtocols()));
        builder.append("\n    Supported ciphers=");
        builder.append(Arrays.toString(engine.getSupportedCipherSuites()));
        builder.append("\n    Enabled ciphers=");
        builder.append(Arrays.toString(engine.getEnabledCipherSuites()));
        builder.append("\n]");
        log.log(level, builder.toString(), t);
    }

    static class ProtocolNegotiationHandler
    extends ChannelDuplexHandler {
        private final ChannelHandler next;
        private final String negotiatorName;
        private ProtocolNegotiationEvent pne;

        protected ProtocolNegotiationHandler(ChannelHandler next, String negotiatorName) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            this.negotiatorName = negotiatorName;
        }

        protected ProtocolNegotiationHandler(ChannelHandler next) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            this.negotiatorName = ((Object)((Object)this)).getClass().getSimpleName().replace("Handler", "");
        }

        public final void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.DEBUG, "{0} started", new Object[]{this.negotiatorName});
            this.handlerAdded0(ctx);
        }

        @ForOverride
        protected void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
        }

        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (String)"pre-existing negotiation: %s < %s", (Object)this.pne, (Object)evt);
                this.pne = (ProtocolNegotiationEvent)evt;
                this.protocolNegotiationEventTriggered(ctx);
            } else {
                this.userEventTriggered0(ctx, evt);
            }
        }

        protected void userEventTriggered0(ChannelHandlerContext ctx, Object evt) throws Exception {
            super.userEventTriggered(ctx, evt);
        }

        @ForOverride
        protected void protocolNegotiationEventTriggered(ChannelHandlerContext ctx) {
        }

        protected final ProtocolNegotiationEvent getProtocolNegotiationEvent() {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"previous protocol negotiation event hasn't triggered");
            return this.pne;
        }

        protected final void replaceProtocolNegotiationEvent(ProtocolNegotiationEvent pne) {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"previous protocol negotiation event hasn't triggered");
            this.pne = (ProtocolNegotiationEvent)Preconditions.checkNotNull((Object)pne);
        }

        protected final void fireProtocolNegotiationEvent(ChannelHandlerContext ctx) {
            Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"previous protocol negotiation event hasn't triggered");
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "{0} completed", new Object[]{this.negotiatorName});
            ctx.pipeline().replace(ctx.name(), null, this.next);
            ctx.fireUserEventTriggered((Object)this.pne);
        }
    }

    static final class WaitUntilActiveHandler
    extends ProtocolNegotiationHandler {
        boolean protocolNegotiationEventReceived;

        WaitUntilActiveHandler(ChannelHandler next) {
            super(next);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (this.protocolNegotiationEventReceived) {
                this.replaceOnActive(ctx);
                this.fireProtocolNegotiationEvent(ctx);
            }
            super.channelActive(ctx);
        }

        @Override
        protected void protocolNegotiationEventTriggered(ChannelHandlerContext ctx) {
            this.protocolNegotiationEventReceived = true;
            if (ctx.channel().isActive()) {
                this.replaceOnActive(ctx);
                this.fireProtocolNegotiationEvent(ctx);
            }
        }

        private void replaceOnActive(ChannelHandlerContext ctx) {
            ProtocolNegotiationEvent existingPne = this.getProtocolNegotiationEvent();
            Attributes attrs = existingPne.getAttributes().toBuilder().set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.NONE).build();
            this.replaceProtocolNegotiationEvent(existingPne.withAttributes(attrs));
        }
    }

    static final class PlaintextProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextProtocolNegotiator() {
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler grpcNegotiationHandler = new GrpcNegotiationHandler(grpcHandler);
            WaitUntilActiveHandler activeHandler = new WaitUntilActiveHandler((ChannelHandler)grpcNegotiationHandler);
            return activeHandler;
        }

        @Override
        public void close() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }
    }

    static final class GrpcNegotiationHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler next;

        public GrpcNegotiationHandler(GrpcHttp2ConnectionHandler next) {
            this.next = (GrpcHttp2ConnectionHandler)((Object)Preconditions.checkNotNull((Object)((Object)next), (Object)"next"));
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                ProtocolNegotiationEvent protocolNegotiationEvent = (ProtocolNegotiationEvent)evt;
                ctx.pipeline().replace(ctx.name(), null, (ChannelHandler)this.next);
                this.next.handleProtocolNegotiationCompleted(protocolNegotiationEvent.getAttributes(), protocolNegotiationEvent.getSecurity());
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class Http2UpgradeAndGrpcHandler
    extends ChannelInboundHandlerAdapter {
        private final String authority;
        private final GrpcHttp2ConnectionHandler next;
        private ProtocolNegotiationEvent pne;

        Http2UpgradeAndGrpcHandler(String authority, GrpcHttp2ConnectionHandler next) {
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
            this.next = (GrpcHttp2ConnectionHandler)((Object)Preconditions.checkNotNull((Object)((Object)next), (Object)"next"));
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade started");
            HttpClientCodec httpClientCodec = new HttpClientCodec();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)httpClientCodec);
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.next);
            HttpClientUpgradeHandler upgrader = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1000);
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)upgrader);
            DefaultHttpRequest upgradeTrigger = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            upgradeTrigger.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.authority);
            ctx.writeAndFlush((Object)upgradeTrigger).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            super.handlerAdded(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                Preconditions.checkState((this.pne == null ? 1 : 0) != 0, (Object)"negotiation already started");
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                Preconditions.checkState((this.pne != null ? 1 : 0) != 0, (Object)"negotiation not yet complete");
                ProtocolNegotiators.negotiationLogger(ctx).log(ChannelLogger.ChannelLogLevel.INFO, "Http2Upgrade finished");
                ctx.pipeline().remove(ctx.name());
                this.next.handleProtocolNegotiationCompleted(this.pne.getAttributes(), this.pne.getSecurity());
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                ctx.fireExceptionCaught((Throwable)ProtocolNegotiators.unavailableException("HTTP/2 upgrade rejected"));
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class PlaintextUpgradeProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextUpgradeProtocolNegotiator() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Http2UpgradeAndGrpcHandler upgradeHandler = new Http2UpgradeAndGrpcHandler(grpcHandler.getAuthority(), grpcHandler);
            return new WaitUntilActiveHandler((ChannelHandler)upgradeHandler);
        }

        @Override
        public void close() {
        }
    }

    @VisibleForTesting
    static final class HostPort {
        final String host;
        final int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static final class ClientTlsHandler
    extends ProtocolNegotiationHandler {
        private final SslContext sslContext;
        private final String host;
        private final int port;
        private Executor executor;

        ClientTlsHandler(ChannelHandler next, SslContext sslContext, String authority, Executor executor) {
            super(next);
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            HostPort hostPort = ProtocolNegotiators.parseAuthority(authority);
            this.host = hostPort.host;
            this.port = hostPort.port;
            this.executor = executor;
        }

        @Override
        protected void handlerAdded0(ChannelHandlerContext ctx) {
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc(), this.host, this.port);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)(this.executor != null ? new SslHandler(sslEngine, false, this.executor) : new SslHandler(sslEngine, false)));
        }

        @Override
        protected void userEventTriggered0(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    SslHandler handler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                    if (this.sslContext.applicationProtocolNegotiator().protocols().contains(handler.applicationProtocol())) {
                        ProtocolNegotiators.logSslEngineDetails(Level.FINER, ctx, "TLS negotiation succeeded.", null);
                        this.propagateTlsComplete(ctx, handler.engine().getSession());
                    } else {
                        RuntimeException ex = ProtocolNegotiators.unavailableException("Failed ALPN negotiation: Unable to find compatible protocol");
                        ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed.", ex);
                        ctx.fireExceptionCaught((Throwable)ex);
                    }
                } else {
                    Throwable t = handshakeEvent.cause();
                    if (t instanceof ClosedChannelException) {
                        t = Status.UNAVAILABLE.withDescription("Connection closed while performing TLS negotiation").withCause(t).asRuntimeException();
                    }
                    ctx.fireExceptionCaught(t);
                }
            } else {
                super.userEventTriggered0(ctx, evt);
            }
        }

        private void propagateTlsComplete(ChannelHandlerContext ctx, SSLSession session) {
            InternalChannelz.Security security = new InternalChannelz.Security(new InternalChannelz.Tls(session));
            ProtocolNegotiationEvent existingPne = this.getProtocolNegotiationEvent();
            Attributes attrs = existingPne.getAttributes().toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).build();
            this.replaceProtocolNegotiationEvent(existingPne.withAttributes(attrs).withSecurity(security));
            this.fireProtocolNegotiationEvent(ctx);
        }
    }

    static final class ClientTlsProtocolNegotiator
    implements ProtocolNegotiator {
        private final SslContext sslContext;
        private final ObjectPool<? extends Executor> executorPool;
        private Executor executor;

        public ClientTlsProtocolNegotiator(SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            this.executorPool = executorPool;
            if (this.executorPool != null) {
                this.executor = (Executor)this.executorPool.getObject();
            }
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTPS;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler gnh = new GrpcNegotiationHandler(grpcHandler);
            ClientTlsHandler cth = new ClientTlsHandler((ChannelHandler)gnh, this.sslContext, grpcHandler.getAuthority(), this.executor);
            return new WaitUntilActiveHandler((ChannelHandler)cth);
        }

        @Override
        public void close() {
            if (this.executorPool != null && this.executor != null) {
                this.executorPool.returnObject((Object)this.executor);
            }
        }
    }

    static final class ProxyProtocolNegotiationHandler
    extends ProtocolNegotiationHandler {
        private final SocketAddress address;
        @Nullable
        private final String userName;
        @Nullable
        private final String password;

        public ProxyProtocolNegotiationHandler(SocketAddress address, @Nullable String userName, @Nullable String password, ChannelHandler next) {
            super(next);
            this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.userName = userName;
            this.password = password;
        }

        @Override
        protected void protocolNegotiationEventTriggered(ChannelHandlerContext ctx) {
            HttpProxyHandler nettyProxyHandler = this.userName == null || this.password == null ? new HttpProxyHandler(this.address) : new HttpProxyHandler(this.address, this.userName, this.password);
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)nettyProxyHandler);
        }

        @Override
        protected void userEventTriggered0(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProxyConnectionEvent) {
                this.fireProtocolNegotiationEvent(ctx);
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class ServerTlsHandler
    extends ChannelInboundHandlerAdapter {
        private Executor executor;
        private final ChannelHandler next;
        private final SslContext sslContext;
        private ProtocolNegotiationEvent pne = ProtocolNegotiationEvent.DEFAULT;

        ServerTlsHandler(ChannelHandler next, SslContext sslContext, ObjectPool<? extends Executor> executorPool) {
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            if (executorPool != null) {
                this.executor = (Executor)executorPool.getObject();
            }
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)(this.executor != null ? new SslHandler(sslEngine, false, this.executor) : new SslHandler(sslEngine, false)));
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (!handshakeEvent.isSuccess()) {
                    ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed for new client.", null);
                    ctx.fireExceptionCaught(handshakeEvent.cause());
                    return;
                }
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                if (!this.sslContext.applicationProtocolNegotiator().protocols().contains(sslHandler.applicationProtocol())) {
                    ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed for new client.", null);
                    ctx.fireExceptionCaught((Throwable)ProtocolNegotiators.unavailableException("Failed protocol negotiation: Unable to find compatible protocol"));
                    return;
                }
                ctx.pipeline().replace(ctx.name(), null, this.next);
                this.fireProtocolNegotiationEvent(ctx, sslHandler.engine().getSession());
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, SSLSession session) {
            InternalChannelz.Security security = new InternalChannelz.Security(new InternalChannelz.Tls(session));
            Attributes attrs = this.pne.getAttributes().toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).build();
            ctx.fireUserEventTriggered((Object)this.pne.withAttributes(attrs).withSecurity(security));
        }
    }
}

