/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.metrics.LoadReport;
import org.apache.hugegraph.loader.metrics.LoadSummary;
import org.apache.hugegraph.loader.progress.LoadProgress;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.TimeUtil;
import org.slf4j.Logger;

public final class Printer {
    private static final Logger LOG = Log.logger(Printer.class);
    private static final String EMPTY_LINE = "";
    private static final String SLASH = "/";
    private static final String DIVIDE_LINE = StringUtils.repeat((char)'-', (int)50);

    public static void printRealtimeProgress(LoadContext context) {
        LoadOptions options = context.options();
        if (!options.printProgress) {
            return;
        }
        System.out.printf(">> HugeGraphLoader worked in %s%n", options.workModeString());
        if (options.incrementalMode) {
            LoadProgress progress = context.oldProgress();
            System.out.printf("vertices/edges loaded last time: %s/%s%n", progress.vertexLoaded(), progress.edgeLoaded());
        }
        System.out.print("vertices/edges loaded this time : ");
    }

    public static void printFinalProgress(LoadContext context) {
        LoadOptions options = context.options();
        if (!options.printProgress) {
            return;
        }
        LoadSummary summary = context.summary();
        long vertexLoaded = summary.vertexLoaded();
        long edgeLoaded = summary.edgeLoaded();
        System.out.println(vertexLoaded + SLASH + edgeLoaded);
    }

    public static void printSummary(LoadContext context) {
        LoadSummary summary = context.summary();
        Printer.log(DIVIDE_LINE);
        Printer.log("detail metrics");
        summary.inputMetricsMap().forEach((id, metrics) -> {
            Printer.log(EMPTY_LINE);
            Printer.log(String.format("input-struct '%s'", id));
            Printer.log("read success", metrics.readSuccess());
            Printer.log("read failure", metrics.readFailure());
            metrics.vertexMetrics().forEach((label, labelMetrics) -> {
                Printer.log(String.format("vertex '%s'", label));
                Printer.log("parse success", labelMetrics.parseSuccess());
                Printer.log("parse failure", labelMetrics.parseFailure());
                Printer.log("insert success", labelMetrics.insertSuccess());
                Printer.log("insert failure", labelMetrics.insertFailure());
            });
            metrics.edgeMetrics().forEach((label, labelMetrics) -> {
                Printer.log(String.format("edge '%s'", label));
                Printer.log("parse success", labelMetrics.parseSuccess());
                Printer.log("parse failure", labelMetrics.parseFailure());
                Printer.log("insert success", labelMetrics.insertSuccess());
                Printer.log("insert failure", labelMetrics.insertFailure());
            });
        });
        Printer.printAndLog(DIVIDE_LINE);
        Printer.printCountReport(LoadReport.collect(summary));
        Printer.printAndLog(DIVIDE_LINE);
        Printer.printMeterReport(summary);
    }

    private static void printCountReport(LoadReport report) {
        Printer.printAndLog("count metrics");
        Printer.printAndLog("input read success", report.readSuccess());
        Printer.printAndLog("input read failure", report.readFailure());
        Printer.printAndLog("vertex parse success", report.vertexParseSuccess());
        Printer.printAndLog("vertex parse failure", report.vertexParseFailure());
        Printer.printAndLog("vertex insert success", report.vertexInsertSuccess());
        Printer.printAndLog("vertex insert failure", report.vertexInsertFailure());
        Printer.printAndLog("edge parse success", report.edgeParseSuccess());
        Printer.printAndLog("edge parse failure", report.edgeParseFailure());
        Printer.printAndLog("edge insert success", report.edgeInsertSuccess());
        Printer.printAndLog("edge insert failure", report.edgeInsertFailure());
    }

    private static void printMeterReport(LoadSummary summary) {
        long totalTime = summary.totalTime();
        long vertexTime = summary.vertexTime();
        long edgeTime = summary.edgeTime();
        long loadTime = summary.loadTime();
        long readTime = totalTime - loadTime;
        Printer.printAndLog("meter metrics");
        Printer.printAndLog("total time", TimeUtil.readableTime((long)totalTime));
        Printer.printAndLog("read time", TimeUtil.readableTime((long)readTime));
        Printer.printAndLog("load time", TimeUtil.readableTime((long)loadTime));
        Printer.printAndLog("vertex load time", TimeUtil.readableTime((long)vertexTime));
        Printer.printAndLog("vertex load rate(vertices/s)", summary.loadRate(ElemType.VERTEX));
        Printer.printAndLog("edge load time", TimeUtil.readableTime((long)edgeTime));
        Printer.printAndLog("edge load rate(edges/s)", summary.loadRate(ElemType.EDGE));
    }

    public static void printError(String message, Object ... args) {
        String formatMsg = String.format(message, args);
        LOG.error(formatMsg);
        System.err.println();
        System.err.println(formatMsg);
    }

    public static void printError(String message, Throwable e) {
        String formatMsg = !StringUtils.isEmpty((CharSequence)e.getMessage()) ? String.format("%s, cause: %s", message, e.getMessage()) : String.format("%s, please see log for detail", message);
        LOG.error(formatMsg, e);
        System.err.println();
        System.err.println(formatMsg);
    }

    public static void printProgress(LoadContext context, ElemType type, long frequency, int batchSize) {
        long loadSuccess;
        LoadSummary summary = context.summary();
        long vertexLoaded = summary.vertexLoaded();
        long edgeLoaded = summary.edgeLoaded();
        if (context.options().printProgress) {
            Printer.printInBackward(vertexLoaded, edgeLoaded);
        }
        long l = loadSuccess = type.isVertex() ? vertexLoaded : edgeLoaded;
        if (loadSuccess % frequency < (long)batchSize) {
            LOG.info("{} has been loaded: {}, average load rate: {}/s", new Object[]{type.string(), loadSuccess, summary.loadRate(type)});
        }
    }

    private static void printInBackward(long vertexLoaded, long edgeLoaded) {
        int vLength = String.valueOf(vertexLoaded).length();
        int eLength = String.valueOf(edgeLoaded).length();
        System.out.print(vertexLoaded + SLASH + edgeLoaded + Printer.backward(vLength + 1 + eLength));
    }

    private static void log(String message) {
        LOG.info(message);
    }

    private static void log(String key, long value) {
        LOG.info(String.format("    %-30s: %-20d", key, value));
    }

    private static void log(String key, String value) {
        LOG.info(String.format("    %-30s: %-20s", key, value));
    }

    private static void printAndLog(String message) {
        LOG.info(message);
        System.out.println(message);
    }

    private static void printAndLog(String key, long value) {
        Printer.printAndLog(String.format("    %-30s: %-20d", key, value));
    }

    private static void printAndLog(String key, String value) {
        Printer.printAndLog(String.format("    %-30s: %-20s", key, value));
    }

    private static String backward(int length) {
        return StringUtils.repeat((char)'\b', (int)length);
    }
}

