/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.HugeClientBuilder;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.E;

public final class HugeClientHolder {
    public static HugeClient create(LoadOptions options) {
        boolean useHttps = options.protocol != null && options.protocol.equals("https");
        String address = options.host + ":" + options.port;
        if (!options.host.startsWith("http://") && !options.host.startsWith("https://")) {
            address = useHttps ? "https://" + address : "http://" + address;
        }
        String username = options.username != null ? options.username : options.graph;
        try {
            HugeClientBuilder builder = HugeClient.builder((String)address, (String)options.graph).configUser(username, options.token).configTimeout(options.timeout).configPool(options.maxConnections, options.maxConnectionsPerRoute);
            if (useHttps) {
                String trustFile;
                if (options.trustStoreFile == null) {
                    String homePath = System.getProperty("loader.home.path");
                    E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)homePath), (String)"The system property 'loader.home.path' can't be null or empty when enable https protocol", (Object[])new Object[0]);
                    trustFile = Paths.get(homePath, "conf/hugegraph.truststore").toString();
                } else {
                    trustFile = options.trustStoreFile;
                }
                String token = options.trustStoreToken == null ? "hugegraph" : options.trustStoreToken;
                builder.configSSL(trustFile, token);
            }
            return builder.build();
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("The version")) {
                throw new LoadException("The version of hugegraph-client and hugegraph-server don't match", e);
            }
            throw e;
        }
        catch (ServerException e) {
            String message = e.getMessage();
            if (401 == e.status() || message != null && message.startsWith("Authentication")) {
                throw new LoadException("Incorrect username or password", e);
            }
            throw e;
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause == null || cause.getMessage() == null) {
                throw e;
            }
            String message = cause.getMessage();
            if (message.contains("Connection refused")) {
                throw new LoadException("The service %s:%s is unavailable", (Throwable)e, options.host, options.port);
            }
            if (message.contains("java.net.UnknownHostException") || message.contains("Host name may not be null")) {
                throw new LoadException("The host %s is unknown", (Throwable)e, options.host);
            }
            if (message.contains("connect timed out")) {
                throw new LoadException("Connect service %s:%s timeout, please check service is available and network is unobstructed", (Throwable)e, options.host, options.port);
            }
            throw e;
        }
    }
}

