/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.spi.GeneratedDriverByteToMessageCodec;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;

public class GeneratedProtocolMessageCodec<BASE_PACKET_CLASS extends Message>
extends GeneratedDriverByteToMessageCodec<BASE_PACKET_CLASS> {
    private final ToIntFunction<ByteBuf> packetSizeEstimator;
    private final Consumer<ByteBuf> corruptPackageRemover;

    public GeneratedProtocolMessageCodec(Class<BASE_PACKET_CLASS> basePacketClass, MessageInput<BASE_PACKET_CLASS> messageInput, ByteOrder byteOrder, Object[] parserArgs, ToIntFunction<ByteBuf> packetSizeEstimator, Consumer<ByteBuf> corruptPackageRemover) {
        super(messageInput, null, basePacketClass, byteOrder, parserArgs);
        this.packetSizeEstimator = packetSizeEstimator;
        this.corruptPackageRemover = corruptPackageRemover;
    }

    public GeneratedProtocolMessageCodec(Class<BASE_PACKET_CLASS> basePacketClass, MessageInput<BASE_PACKET_CLASS> messageInput, MessageOutput<BASE_PACKET_CLASS> messageOutput, ByteOrder byteOrder, Object[] parserArgs, ToIntFunction<ByteBuf> packetSizeEstimator, Consumer<ByteBuf> corruptPackageRemover) {
        super(messageInput, messageOutput, basePacketClass, byteOrder, parserArgs);
        this.packetSizeEstimator = packetSizeEstimator;
        this.corruptPackageRemover = corruptPackageRemover;
    }

    @Override
    protected int getPacketSize(ByteBuf byteBuf) {
        if (this.packetSizeEstimator == null) {
            return byteBuf.readableBytes();
        }
        return this.packetSizeEstimator.applyAsInt(byteBuf);
    }

    @Override
    protected void removeRestOfCorruptPackage(ByteBuf byteBuf) {
        if (this.corruptPackageRemover != null) {
            this.corruptPackageRemover.accept(byteBuf);
        }
    }
}

