/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTcpServerThread;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportType;
import org.snmp4j.util.CommonTimer;
import org.snmp4j.util.WorkerTask;

public class DefaultTcpTransportMapping
extends TcpTransportMapping<SocketEntry> {
    public static final int DEFAULT_MAX_BUSY_LOOPS = 100;
    private static final LogAdapter logger = LogFactory.getLogger(DefaultTcpTransportMapping.class);
    protected ServerThread serverThread;
    private static final int MIN_SNMP_HEADER_LENGTH = 6;
    protected MessageLengthDecoder messageLengthDecoder = new SnmpMesssageLengthDecoder();
    private int maxBusyLoops = 100;

    public DefaultTcpTransportMapping() throws IOException {
        super(new TcpAddress(InetAddress.getLocalHost(), 0));
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress, boolean serverEnabled) throws IOException {
        super(serverAddress);
        this.serverEnabled = serverEnabled;
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress) throws IOException {
        super(serverAddress);
        this.serverEnabled = true;
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.listenWorkerTask != null) {
            throw new SocketException("Port already listening");
        }
        this.serverThread = new ServerThread();
        if (logger.isInfoEnabled()) {
            logger.info("TCP address " + this.getListenAddress() + " bound successfully");
        }
        this.listenWorkerTask = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultTCPTransportMapping_" + this.getAddress(), this.serverThread, true);
        if (this.getConnectionTimeout() > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.listenWorkerTask.run();
    }

    @Override
    public TransportType getSupportedTransportType() {
        return this.isServerEnabled() ? TransportType.any : TransportType.sender;
    }

    @Override
    protected WorkerTask getListenerWorkerTask() {
        return this.listenWorkerTask;
    }

    @Override
    public void close() {
        WorkerTask st = this.listenWorkerTask;
        if (st != null) {
            this.listenWorkerTask = null;
            st.terminate();
            st.interrupt();
            try {
                st.join();
            }
            catch (InterruptedException ex) {
                logger.warn(ex);
            }
            this.closeSockets(this.sockets);
            this.sockets.clear();
            if (this.socketCleaner != null) {
                this.socketCleaner.cancel();
            }
            this.socketCleaner = null;
        }
    }

    @Override
    public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (this.listenWorkerTask == null || this.serverThread == null) {
            if (this.isOpenSocketOnSending()) {
                this.listen();
            } else {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            }
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference);
            }
        }
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return this.messageLengthDecoder;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        if (messageLengthDecoder == null) {
            throw new NullPointerException();
        }
        this.messageLengthDecoder = messageLengthDecoder;
    }

    @Override
    public CommonTimer getSocketCleaner() {
        return this.socketCleaner;
    }

    @Override
    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    protected int getMaxBusyLoops() {
        return this.maxBusyLoops;
    }

    protected void setMaxBusyLoops(int maxBusyLoops) {
        this.maxBusyLoops = maxBusyLoops;
    }

    @Override
    public TcpAddress getListenAddress() {
        int port = this.tcpAddress.getPort();
        ServerThread serverThreadCopy = this.serverThread;
        try {
            port = ((InetSocketAddress)serverThreadCopy.ssc.getLocalAddress()).getPort();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new TcpAddress(this.tcpAddress.getInetAddress(), port);
    }

    protected TcpAddress createIncomingAddress(Socket s) {
        return new TcpAddress(s.getInetAddress(), s.getPort());
    }

    protected void addBufferToReadBuffer(SocketEntry entry, ByteBuffer byteBuffer) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Adding data " + byteBuffer + " to read buffer " + entry.getReadBuffer())));
        }
        int buflen = byteBuffer.position();
        if (entry.getReadBuffer() != null) {
            entry.getReadBuffer().put(byteBuffer.array(), 0, buflen);
        } else {
            byte[] message = new byte[byteBuffer.limit()];
            byteBuffer.flip();
            byteBuffer.get(message, 0, buflen);
            ByteBuffer newBuffer = ByteBuffer.wrap(message);
            newBuffer.position(buflen);
            entry.setReadBuffer(newBuffer);
        }
    }

    protected void socketClosedRemotely(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
        logger.debug((Serializable)((Object)"Socket closed remotely"));
        this.cancelNonServerSelectionKey(sk);
        readChannel.close();
        TransportStateEvent e = new TransportStateEvent(this, incomingAddress, 2, null);
        this.fireConnectionStateChanged(e);
        this.sockets.remove(incomingAddress);
    }

    protected class ServerThread
    extends AbstractTcpServerThread<SocketEntry> {
        protected byte[] buf;
        private volatile boolean stop;
        private Throwable lastError;
        private ServerSocketChannel ssc;

        public ServerThread() throws IOException {
            super(DefaultTcpTransportMapping.this);
            this.stop = false;
            this.lastError = null;
            this.buf = new byte[DefaultTcpTransportMapping.this.getMaxInboundMessageSize()];
            this.selector = Selector.open();
            if (DefaultTcpTransportMapping.this.isServerEnabled()) {
                this.ssc = ServerSocketChannel.open();
                try {
                    this.ssc.configureBlocking(false);
                    InetSocketAddress isa = new InetSocketAddress(DefaultTcpTransportMapping.this.tcpAddress.getInetAddress(), DefaultTcpTransportMapping.this.tcpAddress.getPort());
                    DefaultTcpTransportMapping.this.setSocketOptions(this.ssc.socket());
                    this.ssc.socket().bind(isa);
                    this.ssc.register(this.selector, 16);
                }
                catch (IOException iox) {
                    logger.warn((Serializable)((Object)("Socket bind failed for " + DefaultTcpTransportMapping.this.tcpAddress + ": " + iox.getMessage())));
                    try {
                        this.ssc.close();
                    }
                    catch (IOException ioxClose) {
                        logger.warn((Serializable)((Object)("Socket close failed after bind failure for " + DefaultTcpTransportMapping.this.tcpAddress + ": " + ioxClose.getMessage())));
                    }
                    throw iox;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPending() {
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                for (int i = 0; i < this.pending.size(); ++i) {
                    TransportStateEvent e;
                    SocketEntry entry = (SocketEntry)this.pending.get(i);
                    if (!entry.hasMessage()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Idle socket entry removed from pending message queue: " + entry)));
                        }
                        this.pending.remove(entry);
                        --i;
                        continue;
                    }
                    try {
                        if (entry.getSocket().isConnected()) {
                            entry.addRegistration(this.selector, 4);
                            continue;
                        }
                        entry.addRegistration(this.selector, 8);
                        continue;
                    }
                    catch (CancelledKeyException ckex) {
                        logger.warn(ckex);
                        this.pending.remove(entry);
                        --i;
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(DefaultTcpTransportMapping.this, (Address)entry.getPeerAddress(), 4, null, (List<byte[]>)entry.getMessages());
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        continue;
                    }
                    catch (IOException iox) {
                        logger.error(iox);
                        this.pending.remove(entry);
                        try {
                            entry.getSocket().getChannel().close();
                            e = new TransportStateEvent(DefaultTcpTransportMapping.this, (Address)entry.getPeerAddress(), 4, iox, (List<byte[]>)entry.getMessages());
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        this.lastError = iox;
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) break;
                        throw new RuntimeException(iox);
                    }
                }
            }
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Address address, byte[] message, TransportStateReference tmStateReference) throws IOException {
            Object object;
            Socket s = null;
            SocketEntry entry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Looking up connection for destination '" + address + "' returned: " + entry)));
                logger.debug((Serializable)((Object)DefaultTcpTransportMapping.this.sockets.toString()));
            }
            if (entry != null) {
                object = entry;
                synchronized (object) {
                    entry.used();
                    s = entry.getSocket();
                }
            }
            if (s == null || s.isClosed() || !s.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Socket for address '" + address + "' is closed, opening it...")));
                }
                object = this.pending;
                synchronized (object) {
                    this.pending.remove(entry);
                }
                SocketChannel sc = null;
                try {
                    InetSocketAddress targetAddress = new InetSocketAddress(((TcpAddress)address).getInetAddress(), ((TcpAddress)address).getPort());
                    if (s == null || s.isClosed()) {
                        sc = SocketChannel.open();
                        sc.configureBlocking(false);
                        sc.connect(targetAddress);
                    } else {
                        sc = s.getChannel();
                        sc.configureBlocking(false);
                        if (!sc.isConnectionPending()) {
                            sc.connect(targetAddress);
                        }
                    }
                    s = sc.socket();
                    entry = new SocketEntry((TcpAddress)address, s);
                    entry.addMessage(message);
                    this.connectSocketToSendMessage(address, message, s, entry, DefaultTcpTransportMapping.this.sockets);
                }
                catch (IOException iox) {
                    logger.error(iox);
                    throw iox;
                }
            }
            entry.addMessage(message);
            object = this.pending;
            synchronized (object) {
                this.pending.add(entry);
            }
            logger.debug((Serializable)((Object)"Waking up selector for new message"));
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    try {
                        if (this.selector.select() > 0) {
                            if (this.stop) break;
                            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                            Iterator<SelectionKey> it = readyKeys.iterator();
                            while (it.hasNext()) {
                                try {
                                    SelectionKey sk = it.next();
                                    it.remove();
                                    SocketChannel readChannel = null;
                                    TcpAddress incomingAddress = null;
                                    if (sk.isAcceptable()) {
                                        logger.debug((Serializable)((Object)"Key is acceptable"));
                                        ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                        Socket s = nextReady.accept().socket();
                                        readChannel = s.getChannel();
                                        readChannel.configureBlocking(false);
                                        incomingAddress = DefaultTcpTransportMapping.this.createIncomingAddress(s);
                                        SocketEntry entry = new SocketEntry(incomingAddress, s);
                                        entry.addRegistration(this.selector, 1);
                                        DefaultTcpTransportMapping.this.sockets.put(incomingAddress, entry);
                                        DefaultTcpTransportMapping.this.timeoutSocket(entry);
                                        TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 1, null);
                                        DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                                        if (e.isCancelled()) {
                                            logger.warn((Serializable)((Object)"Incoming connection cancelled"));
                                            s.close();
                                            this.removeSocketEntry(incomingAddress);
                                            readChannel = null;
                                        }
                                    } else if (sk.isWritable()) {
                                        logger.debug((Serializable)((Object)"Key is writable"));
                                        incomingAddress = this.writeData(sk, incomingAddress);
                                    } else if (sk.isReadable()) {
                                        logger.debug((Serializable)((Object)"Key is readable"));
                                        readChannel = (SocketChannel)sk.channel();
                                        incomingAddress = DefaultTcpTransportMapping.this.createIncomingAddress(readChannel.socket());
                                    } else if (sk.isConnectable()) {
                                        logger.debug((Serializable)((Object)"Key is connectable"));
                                        this.connectChannel(sk, incomingAddress);
                                    }
                                    if (readChannel == null) continue;
                                    logger.debug((Serializable)((Object)"Key is reading"));
                                    try {
                                        int busyLoops;
                                        SocketEntry entry;
                                        if (this.readMessage(sk, readChannel, incomingAddress) || (entry = (SocketEntry)sk.attachment()) == null || DefaultTcpTransportMapping.this.getMaxBusyLoops() <= 0 || (busyLoops = entry.nextBusyLoop()) <= DefaultTcpTransportMapping.this.getMaxBusyLoops()) continue;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Serializable)((Object)("After " + busyLoops + " read key has been removed: " + entry)));
                                        }
                                        entry.removeRegistration(this.selector, 1);
                                        entry.resetBusyLoops();
                                    }
                                    catch (IOException iox) {
                                        DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
                                    }
                                }
                                catch (CancelledKeyException ckex) {
                                    if (!logger.isDebugEnabled()) continue;
                                    logger.debug((Serializable)((Object)"Selection key cancelled, skipping it"));
                                }
                            }
                        }
                    }
                    catch (NullPointerException npex) {
                        npex.printStackTrace();
                        logger.warn((Serializable)((Object)"NullPointerException within select()?"));
                        this.stop = true;
                    }
                    if (this.stop) continue;
                    this.processPending();
                }
                if (this.ssc != null) {
                    this.ssc.close();
                }
                if (this.selector != null) {
                    this.selector.close();
                }
            }
            catch (IOException iox) {
                logger.error(iox);
                this.lastError = iox;
            }
            if (!this.stop) {
                this.stop = true;
                DefaultTcpTransportMapping defaultTcpTransportMapping = DefaultTcpTransportMapping.this;
                synchronized (defaultTcpTransportMapping) {
                    DefaultTcpTransportMapping.this.listenWorkerTask = null;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Worker task finished: " + this.getClass().getName())));
            }
        }

        @Override
        public SocketEntry removeSocketEntry(TcpAddress incomingAddress) {
            return (SocketEntry)DefaultTcpTransportMapping.this.sockets.remove(incomingAddress);
        }

        protected boolean readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
            long bytesRead;
            SocketEntry entry = (SocketEntry)sk.attachment();
            if (entry == null) {
                entry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(incomingAddress);
            }
            if (entry != null) {
                entry.used();
                ByteBuffer readBuffer = entry.getReadBuffer();
                if (readBuffer != null) {
                    int bytesRead2 = readChannel.read(readBuffer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Read " + bytesRead2 + " bytes from " + incomingAddress)));
                    }
                    if (bytesRead2 >= 0 && (readBuffer.hasRemaining() || readBuffer.position() < DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength())) {
                        entry.addRegistration(this.selector, 1);
                    } else if (bytesRead2 < 0) {
                        DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
                    } else {
                        this.readSnmpMessagePayload(readChannel, incomingAddress, entry, readBuffer);
                    }
                    if (bytesRead2 != 0) {
                        entry.resetBusyLoops();
                        return true;
                    }
                    return false;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf);
            byteBuffer.limit(DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength());
            if (!readChannel.isOpen()) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
                return false;
            }
            try {
                bytesRead = readChannel.read(byteBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Reading header " + bytesRead + " bytes from " + incomingAddress)));
                }
            }
            catch (ClosedChannelException ccex) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + incomingAddress)));
                }
                return false;
            }
            if (byteBuffer.position() >= DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength()) {
                this.readSnmpMessagePayload(readChannel, incomingAddress, entry, byteBuffer);
            } else if (bytesRead < 0L) {
                DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
            } else if (entry != null && bytesRead > 0L) {
                DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                entry.addRegistration(this.selector, 1);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("No socket entry found for incoming address " + incomingAddress + " for incomplete message with length " + bytesRead)));
            }
            if (entry != null && bytesRead != 0L) {
                entry.resetBusyLoops();
                return true;
            }
            return false;
        }

        protected void readSnmpMessagePayload(SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry entry, ByteBuffer byteBuffer) throws IOException {
            MessageLength messageLength = DefaultTcpTransportMapping.this.messageLengthDecoder.getMessageLength(ByteBuffer.wrap(byteBuffer.array()));
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Message length is " + messageLength)));
            }
            if (messageLength.getMessageLength() > DefaultTcpTransportMapping.this.getMaxInboundMessageSize() || messageLength.getMessageLength() <= 0) {
                Socket s;
                logger.error((Serializable)((Object)("Received message length " + messageLength + " is greater than inboundBufferSize " + DefaultTcpTransportMapping.this.getMaxInboundMessageSize())));
                if (entry != null && (s = entry.getSocket()) != null) {
                    s.close();
                    logger.info("Socket to " + entry.getPeerAddress() + " closed due to an error");
                }
            } else {
                long bytesRead;
                int messageSize = messageLength.getMessageLength();
                if (byteBuffer.position() < messageSize) {
                    if (byteBuffer.capacity() < messageSize) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Extending message buffer size according to message length to " + messageSize)));
                        }
                        byte[] newBuffer = new byte[messageSize];
                        int len = byteBuffer.position();
                        byteBuffer.flip();
                        byteBuffer.get(newBuffer, 0, len);
                        byteBuffer = ByteBuffer.wrap(newBuffer);
                        byteBuffer.position(len);
                        if (entry != null) {
                            byteBuffer.limit(messageSize);
                            entry.setReadBuffer(byteBuffer);
                        }
                    } else {
                        byteBuffer.limit(messageSize);
                    }
                    readChannel.read(byteBuffer);
                }
                if ((bytesRead = (long)byteBuffer.position()) >= (long)messageSize) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Message completed with " + bytesRead + " bytes and " + byteBuffer.limit() + " buffer limit")));
                    }
                    if (entry != null) {
                        entry.setReadBuffer(null);
                    }
                    this.dispatchMessage(incomingAddress, byteBuffer, bytesRead, entry);
                } else if (entry != null && byteBuffer != entry.getReadBuffer()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Adding buffer content to read buffer of entry " + entry + ", buffer " + byteBuffer)));
                    }
                    DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                }
                if (entry != null) {
                    entry.addRegistration(this.selector, 1);
                }
            }
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead, Object sessionID) {
            ByteBuffer bis;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received message from " + incomingAddress + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString())));
            }
            if (DefaultTcpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            TransportStateReference stateReference = new TransportStateReference(DefaultTcpTransportMapping.this, incomingAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, sessionID);
            DefaultTcpTransportMapping.this.fireProcessMessage(incomingAddress, bis, stateReference);
        }

        @Override
        public void close() {
            this.stop = true;
            WorkerTask st = DefaultTcpTransportMapping.this.listenWorkerTask;
            if (st != null) {
                st.terminate();
            }
        }

        @Override
        public void terminate() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void join() {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void interrupt() {
            this.stop = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
            }
            this.selector.wakeup();
        }
    }

    public static class SnmpMesssageLengthDecoder
    implements MessageLengthDecoder {
        @Override
        public int getMinHeaderLength() {
            return 6;
        }

        @Override
        public MessageLength getMessageLength(ByteBuffer buf) throws IOException {
            BER.MutableByte type = new BER.MutableByte();
            BERInputStream is = new BERInputStream(buf);
            int ml = BER.decodeHeader(is, type, false);
            int hl = (int)is.getPosition();
            MessageLength messageLength = new MessageLength(hl, ml);
            return messageLength;
        }
    }

    protected class SocketEntry
    extends AbstractSocketEntry {
        private ByteBuffer readBuffer;

        public SocketEntry(TcpAddress address, Socket socket) {
            super(address, socket);
            this.readBuffer = null;
        }

        public void closeSession() {
        }

        public void setReadBuffer(ByteBuffer byteBuffer) {
            this.readBuffer = byteBuffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        @Override
        public String toString() {
            return "SocketEntry[peerAddress=" + this.getPeerAddress() + ",socket=" + this.socket + ",lastUse=" + new Date(this.getLastUse() / 1000000L) + ",readBufferPosition=" + (this.readBuffer == null ? -1 : this.readBuffer.position()) + ",socketTimeout=" + this.getSocketTimeout() + "]";
        }
    }
}

