/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;

public final class ConstructorQueryMappings {
    private String className;
    private List<DatabaseMapping> mappings;
    private DatabaseQuery query;

    ConstructorQueryMappings(DatabaseQuery query) {
        this.query = query;
        this.mappings = new LinkedList<DatabaseMapping>();
    }

    public String getClassName() {
        return this.className;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public boolean isConstructorQuery() {
        return this.className != null;
    }

    public Iterable<DatabaseMapping> mappings() {
        if (this.mappings.isEmpty()) {
            return Collections.emptyList();
        }
        return new LinkedList<DatabaseMapping>(this.mappings);
    }

    void populate(JPQLGrammar jpqlGrammar) {
        JPQLQueryContext queryContext = new JPQLQueryContext(this.query, jpqlGrammar);
        ConstructorVisitor visitor = new ConstructorVisitor(queryContext);
        queryContext.getJPQLExpression().accept((ExpressionVisitor)visitor);
    }

    private class ConstructorVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private final JPQLQueryContext queryContext;

        ConstructorVisitor(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        private DynamicClassLoader classLoader() {
            return (DynamicClassLoader)this.queryContext.getSession().getProperty("eclipselink.classloader");
        }

        public void visit(ConstructorExpression expression) {
            ConstructorQueryMappings.this.className = expression.getClassName();
            ConstructorItemVisitor visitor = new ConstructorItemVisitor(this.queryContext);
            expression.getConstructorItems().accept((ExpressionVisitor)visitor);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            expression.getSelectClause().accept((ExpressionVisitor)this);
        }
    }

    private class ConstructorItemVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        private final JPQLQueryContext queryContext;

        ConstructorItemVisitor(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren((ExpressionVisitor)this);
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.visitPathExpression((AbstractPathExpression)expression);
        }

        private void visitPathExpression(AbstractPathExpression expression) {
            DatabaseMapping mapping = this.queryContext.resolveMapping((Expression)expression);
            if (mapping != null) {
                ConstructorQueryMappings.this.mappings.add(mapping);
            }
        }
    }
}

