/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hertzbeat.alert.dao.SingleAlertDao;
import org.apache.hertzbeat.alert.util.AlertUtil;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.springframework.stereotype.Component;

@Component
public class AlarmCacheManager {
    private final Map<String, SingleAlert> pendingAlertMap = new ConcurrentHashMap<String, SingleAlert>(8);
    private final Map<String, SingleAlert> firingAlertMap = new ConcurrentHashMap<String, SingleAlert>(8);

    public AlarmCacheManager(SingleAlertDao singleAlertDao) {
        List<SingleAlert> singleAlerts = singleAlertDao.querySingleAlertsByStatus("firing");
        for (SingleAlert singleAlert : singleAlerts) {
            String fingerprint = AlertUtil.calculateFingerprint(singleAlert.getLabels());
            singleAlert.setId(null);
            this.firingAlertMap.put(fingerprint, singleAlert);
        }
    }

    public void putPending(String fingerPrint, SingleAlert alert) {
        this.pendingAlertMap.put(fingerPrint, alert);
    }

    public SingleAlert getPending(String fingerPrint) {
        return this.pendingAlertMap.get(fingerPrint);
    }

    public SingleAlert removePending(String fingerPrint) {
        return this.pendingAlertMap.remove(fingerPrint);
    }

    public void putFiring(String fingerPrint, SingleAlert alert) {
        this.firingAlertMap.put(fingerPrint, alert);
    }

    public SingleAlert getFiring(String fingerPrint) {
        return this.firingAlertMap.get(fingerPrint);
    }

    public SingleAlert removeFiring(String fingerPrint) {
        return this.firingAlertMap.remove(fingerPrint);
    }
}

