/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.contrib.azure.resource.AzureEnvVarPlatform;
import io.opentelemetry.contrib.azure.resource.AzureVmResourceProvider;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.contrib.azure.resource.IncubatingAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class AzureAppServiceResourceProvider
extends CloudResourceProvider {
    static final AttributeKey<String> AZURE_APP_SERVICE_STAMP_RESOURCE_ATTRIBUTE = AttributeKey.stringKey((String)"azure.app.service.stamp");
    static final String REGION_NAME = "REGION_NAME";
    private static final String WEBSITE_HOME_STAMPNAME = "WEBSITE_HOME_STAMPNAME";
    private static final String WEBSITE_HOSTNAME = "WEBSITE_HOSTNAME";
    static final String WEBSITE_INSTANCE_ID = "WEBSITE_INSTANCE_ID";
    private static final String WEBSITE_OWNER_NAME = "WEBSITE_OWNER_NAME";
    private static final String WEBSITE_RESOURCE_GROUP = "WEBSITE_RESOURCE_GROUP";
    static final String WEBSITE_SITE_NAME = "WEBSITE_SITE_NAME";
    private static final String WEBSITE_SLOT_NAME = "WEBSITE_SLOT_NAME";
    private static final Map<AttributeKey<String>, String> ENV_VAR_MAPPING = new HashMap<AttributeKey<String>, String>();
    private final Map<String, String> env;

    public AzureAppServiceResourceProvider() {
        this(System.getenv());
    }

    AzureAppServiceResourceProvider(Map<String, String> env) {
        this.env = env;
    }

    public Resource createResource(ConfigProperties config) {
        return Resource.create((Attributes)this.getAttributes());
    }

    public Attributes getAttributes() {
        AzureEnvVarPlatform detect = AzureEnvVarPlatform.detect(this.env);
        if (detect != AzureEnvVarPlatform.APP_SERVICE) {
            return Attributes.empty();
        }
        String name = Objects.requireNonNull(this.env.get(WEBSITE_SITE_NAME));
        AttributesBuilder builder = AzureVmResourceProvider.azureAttributeBuilder("azure_app_service");
        builder.put(ServiceAttributes.SERVICE_NAME, (Object)name);
        String resourceUri = this.resourceUri(name);
        if (resourceUri != null) {
            builder.put(IncubatingAttributes.CLOUD_RESOURCE_ID, (Object)resourceUri);
        }
        AzureEnvVarPlatform.addAttributesFromEnv(ENV_VAR_MAPPING, this.env, builder);
        return builder.build();
    }

    @Nullable
    private String resourceUri(String websiteName) {
        String websiteResourceGroup = this.env.get(WEBSITE_RESOURCE_GROUP);
        String websiteOwnerName = this.env.get(WEBSITE_OWNER_NAME);
        String subscriptionId = websiteOwnerName != null && websiteOwnerName.contains("+") ? websiteOwnerName.substring(0, websiteOwnerName.indexOf("+")) : websiteOwnerName;
        if (StringUtils.isNullOrEmpty((String)websiteResourceGroup) || StringUtils.isNullOrEmpty((String)subscriptionId)) {
            return null;
        }
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Web/sites/%s", subscriptionId, websiteResourceGroup, websiteName);
    }

    static {
        ENV_VAR_MAPPING.put(IncubatingAttributes.CLOUD_REGION, REGION_NAME);
        ENV_VAR_MAPPING.put(IncubatingAttributes.DEPLOYMENT_ENVIRONMENT_NAME, WEBSITE_SLOT_NAME);
        ENV_VAR_MAPPING.put(IncubatingAttributes.HOST_ID, WEBSITE_HOSTNAME);
        ENV_VAR_MAPPING.put(IncubatingAttributes.SERVICE_INSTANCE_ID, WEBSITE_INSTANCE_ID);
        ENV_VAR_MAPPING.put(AZURE_APP_SERVICE_STAMP_RESOURCE_ATTRIBUTE, WEBSITE_HOME_STAMPNAME);
    }
}

