/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.reader;

import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;

public class OrcSplitReaderUtil {
    public static TypeDescription toOrcType(DataType type) {
        type = type.copy(true);
        switch (type.getTypeRoot()) {
            case CHAR: {
                return TypeDescription.createChar().withMaxLength(((CharType)type).getLength());
            }
            case VARCHAR: {
                int len = ((VarCharType)type).getLength();
                if (len == Integer.MAX_VALUE) {
                    return TypeDescription.createString();
                }
                return TypeDescription.createVarchar().withMaxLength(len);
            }
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case VARBINARY: {
                if (type.equals((Object)DataTypes.BYTES())) {
                    return TypeDescription.createBinary();
                }
                throw new UnsupportedOperationException("Not support other binary type: " + type);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return TypeDescription.createDecimal().withScale(decimalType.getScale()).withPrecision(decimalType.getPrecision());
            }
            case TINYINT: {
                return TypeDescription.createByte();
            }
            case SMALLINT: {
                return TypeDescription.createShort();
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: {
                return TypeDescription.createInt();
            }
            case BIGINT: {
                return TypeDescription.createLong();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case DATE: {
                return TypeDescription.createDate();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TypeDescription.createTimestamp();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return TypeDescription.createTimestampInstant();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return TypeDescription.createList(OrcSplitReaderUtil.toOrcType(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return TypeDescription.createMap(OrcSplitReaderUtil.toOrcType(mapType.getKeyType()), OrcSplitReaderUtil.toOrcType(mapType.getValueType()));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                TypeDescription struct = TypeDescription.createStruct();
                for (int i = 0; i < rowType.getFieldCount(); ++i) {
                    struct.addField((String)rowType.getFieldNames().get(i), OrcSplitReaderUtil.toOrcType(rowType.getTypeAt(i)));
                }
                return struct;
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }
}

