/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import org.apache.gravitino.authorization.ranger.RangerMetadataObject;

public class RangerMetadataObjects {
    protected static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    protected static final Joiner DOT_JOINER = Joiner.on((char)'.');

    private RangerMetadataObjects() {
    }

    public static String getParentFullName(List<String> names) {
        if (names.size() <= 1) {
            return null;
        }
        return DOT_JOINER.join(names.subList(0, names.size() - 1));
    }

    static String getLastName(List<String> names) {
        Preconditions.checkArgument((names.size() > 0 ? 1 : 0) != 0, (Object)"Cannot get the last name of an empty list");
        return names.get(names.size() - 1);
    }

    static void checkName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a metadata object with null name");
    }

    public static class RangerMetadataObjectImpl
    implements RangerMetadataObject {
        private final String name;
        private final String parent;
        private final RangerMetadataObject.Type type;

        public RangerMetadataObjectImpl(String parent, String name, RangerMetadataObject.Type type) {
            this.parent = parent;
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<String> names() {
            return DOT_SPLITTER.splitToList((CharSequence)this.fullName());
        }

        @Override
        public String parent() {
            return this.parent;
        }

        @Override
        public RangerMetadataObject.Type type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangerMetadataObjectImpl)) {
                return false;
            }
            RangerMetadataObjectImpl that = (RangerMetadataObjectImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.parent, this.type});
        }

        public String toString() {
            return "MetadataObject: [fullName=" + this.fullName() + "], [type=" + (Object)((Object)this.type) + "]";
        }
    }
}

