/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.Unstable;

@Unstable
public interface RangerMetadataObject {
    @Nullable
    public String parent();

    public String name();

    public List<String> names();

    default public String fullName() {
        if (this.parent() == null) {
            return this.name();
        }
        return this.parent() + "." + this.name();
    }

    public Type type();

    public static enum Type {
        SCHEMA(MetadataObject.Type.SCHEMA),
        TABLE(MetadataObject.Type.TABLE),
        COLUMN(MetadataObject.Type.COLUMN);

        private final MetadataObject.Type metadataType;

        private Type(MetadataObject.Type type) {
            this.metadataType = type;
        }

        public MetadataObject.Type getMetadataType() {
            return this.metadataType;
        }

        public static Type fromMetadataType(MetadataObject.Type metadataType) {
            for (Type type : Type.values()) {
                if (type.getMetadataType() != metadataType) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching RangerMetadataObject.Type for " + metadataType);
        }
    }
}

