/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.ranger.RangerMetadataObject;
import org.apache.gravitino.authorization.ranger.RangerPrivilege;
import org.apache.gravitino.authorization.ranger.RangerSecurableObject;
import org.apache.gravitino.exceptions.AuthorizationPluginException;
import org.apache.ranger.RangerClient;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RangerHelper.class);
    public static final String MANAGED_BY_GRAVITINO = "MANAGED_BY_GRAVITINO";
    public static final String RESOURCE_ALL = "*";
    private final Set<RangerPrivilege> ownerPrivileges;
    protected final List<String> policyResourceDefines;
    private final RangerClient rangerClient;
    private final String rangerAdminName;
    private final String rangerServiceName;
    public static final String GRAVITINO_METALAKE_OWNER_ROLE = "GRAVITINO_METALAKE_OWNER_ROLE";
    public static final String GRAVITINO_CATALOG_OWNER_ROLE = "GRAVITINO_CATALOG_OWNER_ROLE";

    public RangerHelper(RangerClient rangerClient, String rangerAdminName, String rangerServiceName, Set<RangerPrivilege> ownerPrivileges, List<String> resourceDefines) {
        this.rangerClient = rangerClient;
        this.rangerAdminName = rangerAdminName;
        this.rangerServiceName = rangerServiceName;
        this.ownerPrivileges = ownerPrivileges;
        this.policyResourceDefines = resourceDefines;
    }

    void checkPolicyItemAccess(RangerPolicy.RangerPolicyItem policyItem) throws AuthorizationPluginException {
        if (policyItem.getAccesses().size() != 1) {
            throw new AuthorizationPluginException("The access type only have one in the delegate Gravitino management policy", new Object[0]);
        }
        HashSet setAccesses = new HashSet();
        policyItem.getAccesses().forEach(access -> {
            if (setAccesses.contains(access.getType())) {
                throw new AuthorizationPluginException("Contain duplicate privilege(%s) in the delegate Gravitino management policy ", new Object[]{access.getType()});
            }
            setAccesses.add(access.getType());
        });
    }

    void addPolicyItem(RangerPolicy policy, String roleName, RangerSecurableObject securableObject) {
        securableObject.privileges().forEach(rangerPrivilege -> {
            List matchPolicyItems = rangerPrivilege.condition() == Privilege.Condition.ALLOW ? policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().anyMatch(access -> access.getType().equals(rangerPrivilege.getName()))).collect(Collectors.toList()) : policy.getDenyPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().anyMatch(access -> access.getType().equals(rangerPrivilege.getName()))).collect(Collectors.toList());
            if (matchPolicyItems.isEmpty()) {
                RangerPolicy.RangerPolicyItem policyItem2 = new RangerPolicy.RangerPolicyItem();
                RangerPolicy.RangerPolicyItemAccess access = new RangerPolicy.RangerPolicyItemAccess();
                access.setType(rangerPrivilege.getName());
                policyItem2.getAccesses().add(access);
                policyItem2.getRoles().add(roleName);
                if (Privilege.Condition.ALLOW == rangerPrivilege.condition()) {
                    policy.getPolicyItems().add(policyItem2);
                } else {
                    policy.getDenyPolicyItems().add(policyItem2);
                }
            } else {
                matchPolicyItems.stream().forEach(policyItem -> {
                    if (!policyItem.getRoles().contains(roleName)) {
                        policyItem.getRoles().add(roleName);
                    }
                });
            }
        });
    }

    public List<RangerPolicy> wildcardSearchPolies(List<String> metadataNames) throws AuthorizationPluginException {
        HashMap<String, String> searchFilters = new HashMap<String, String>();
        searchFilters.put("serviceName", this.rangerServiceName);
        searchFilters.put("policyLabelsPartial", MANAGED_BY_GRAVITINO);
        for (int i = 0; i < metadataNames.size(); ++i) {
            searchFilters.put("resource:" + this.policyResourceDefines.get(i), metadataNames.get(i));
        }
        try {
            List policies = this.rangerClient.findPolicies(searchFilters);
            return policies;
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to find the policies in the Ranger", new Object[0]);
        }
    }

    public RangerPolicy findManagedPolicy(RangerMetadataObject rangerMetadataObject) throws AuthorizationPluginException {
        List<Object> policies = this.wildcardSearchPolies(rangerMetadataObject.names());
        if (!policies.isEmpty()) {
            List<String> nsMetadataObj = rangerMetadataObject.names();
            HashMap<String, String> preciseFilters = new HashMap<String, String>();
            for (int i = 0; i < nsMetadataObj.size(); ++i) {
                preciseFilters.put(this.policyResourceDefines.get(i), nsMetadataObj.get(i));
            }
            policies = policies.stream().filter(policy -> policy.getResources().entrySet().stream().allMatch(entry -> preciseFilters.containsKey(entry.getKey()) && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().size() == 1 && ((RangerPolicy.RangerPolicyResource)entry.getValue()).getValues().contains(preciseFilters.get(entry.getKey())))).collect(Collectors.toList());
        }
        if (policies.size() > 1) {
            throw new AuthorizationPluginException("Every metadata object has only a Gravitino managed policy.", new Object[0]);
        }
        if (policies.isEmpty()) {
            return null;
        }
        RangerPolicy policy2 = policies.get(0);
        policy2.getPolicyItems().forEach(this::checkPolicyItemAccess);
        policy2.getDenyPolicyItems().forEach(this::checkPolicyItemAccess);
        policy2.getRowFilterPolicyItems().forEach(this::checkPolicyItemAccess);
        policy2.getDataMaskPolicyItems().forEach(this::checkPolicyItemAccess);
        return policy2;
    }

    protected boolean checkRangerRole(String roleName) throws AuthorizationPluginException {
        try {
            this.rangerClient.getRole(roleName, this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to check the role(%s) in the Ranger", new Object[]{roleName});
        }
        return true;
    }

    protected GrantRevokeRoleRequest createGrantRevokeRoleRequest(String roleName, String userName, String groupName) {
        HashSet groups;
        HashSet users = StringUtils.isEmpty((String)userName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{userName});
        HashSet hashSet = groups = StringUtils.isEmpty((String)groupName) ? Sets.newHashSet() : Sets.newHashSet((Object[])new String[]{groupName});
        if (users.size() == 0 && groups.size() == 0) {
            throw new AuthorizationPluginException("The user and group cannot be empty!", new Object[0]);
        }
        GrantRevokeRoleRequest roleRequest = new GrantRevokeRoleRequest();
        roleRequest.setUsers((Set)users);
        roleRequest.setGroups((Set)groups);
        roleRequest.setGrantor(this.rangerAdminName);
        roleRequest.setTargetRoles((Set)Sets.newHashSet((Object[])new String[]{roleName}));
        return roleRequest;
    }

    protected RangerRole createRangerRoleIfNotExists(String roleName, boolean isOwnerRole) {
        if (isOwnerRole) {
            Preconditions.checkArgument((roleName.equalsIgnoreCase(GRAVITINO_METALAKE_OWNER_ROLE) || roleName.equalsIgnoreCase(GRAVITINO_CATALOG_OWNER_ROLE) ? 1 : 0) != 0, (Object)"The role name should be GRAVITINO_METALAKE_OWNER_ROLE or GRAVITINO_CATALOG_OWNER_ROLE");
        } else {
            Preconditions.checkArgument((!roleName.equalsIgnoreCase(GRAVITINO_METALAKE_OWNER_ROLE) && !roleName.equalsIgnoreCase(GRAVITINO_CATALOG_OWNER_ROLE) ? 1 : 0) != 0, (Object)"The role name should not be GRAVITINO_METALAKE_OWNER_ROLE or GRAVITINO_CATALOG_OWNER_ROLE");
        }
        RangerRole rangerRole = null;
        try {
            rangerRole = this.rangerClient.getRole(roleName, this.rangerAdminName, this.rangerServiceName);
        }
        catch (RangerServiceException e) {
            LOG.warn("The role({}) does not exist in the Ranger!", (Object)roleName);
        }
        try {
            if (rangerRole == null) {
                rangerRole = new RangerRole(roleName, MANAGED_BY_GRAVITINO, null, null, null);
                this.rangerClient.createRole(this.rangerServiceName, rangerRole);
            }
        }
        catch (RangerServiceException e) {
            throw new AuthorizationPluginException((Throwable)e, "Failed to create the role(%s) in the Ranger", new Object[]{roleName});
        }
        return rangerRole;
    }

    protected void updatePolicyOwner(RangerPolicy policy, Owner preOwner, Owner newOwner) {
        List<RangerPolicy.RangerPolicyItem> matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().allMatch(policyItemAccess -> this.ownerPrivileges.stream().anyMatch(ownerPrivilege -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).collect(Collectors.toList());
        matchPolicyItems.forEach(policyItem -> {
            if (preOwner != null) {
                if (preOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().removeIf(preOwner.name()::equals);
                } else {
                    policyItem.getGroups().removeIf(preOwner.name()::equals);
                }
            }
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    if (!policyItem.getUsers().contains(newOwner.name())) {
                        policyItem.getUsers().add(newOwner.name());
                    }
                } else if (!policyItem.getGroups().contains(newOwner.name())) {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
        });
        this.ownerPrivileges.stream().filter(ownerPrivilege -> matchPolicyItems.stream().noneMatch(policyItem -> policyItem.getAccesses().stream().anyMatch(policyItemAccess -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
            policy.getPolicyItems().add(policyItem);
        });
    }

    protected RangerPolicy createPolicyAddResources(RangerMetadataObject metadataObject) {
        RangerPolicy policy = new RangerPolicy();
        policy.setService(this.rangerServiceName);
        policy.setName(metadataObject.fullName());
        policy.setPolicyLabels((List)Lists.newArrayList((Object[])new String[]{MANAGED_BY_GRAVITINO}));
        List<String> nsMetadataObject = metadataObject.names();
        for (int i = 0; i < nsMetadataObject.size(); ++i) {
            RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource(nsMetadataObject.get(i));
            policy.getResources().put(this.policyResourceDefines.get(i), policyResource);
        }
        return policy;
    }

    protected RangerPolicy addOwnerToNewPolicy(RangerMetadataObject metadataObject, Owner newOwner) {
        RangerPolicy policy = this.createPolicyAddResources(metadataObject);
        this.ownerPrivileges.forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            if (newOwner != null) {
                if (newOwner.type() == Owner.Type.USER) {
                    policyItem.getUsers().add(newOwner.name());
                } else {
                    policyItem.getGroups().add(newOwner.name());
                }
            }
            policy.getPolicyItems().add(policyItem);
        });
        return policy;
    }

    protected RangerPolicy addOwnerRoleToNewPolicy(RangerMetadataObject metadataObject, String ownerRoleName) {
        RangerPolicy policy = this.createPolicyAddResources(metadataObject);
        this.ownerPrivileges.forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            policyItem.getRoles().add(ownerRoleName);
            policy.getPolicyItems().add(policyItem);
        });
        return policy;
    }

    protected void updatePolicyOwnerRole(RangerPolicy policy, String ownerRoleName) {
        List<RangerPolicy.RangerPolicyItem> matchPolicyItems = policy.getPolicyItems().stream().filter(policyItem -> policyItem.getAccesses().stream().allMatch(policyItemAccess -> this.ownerPrivileges.stream().anyMatch(ownerPrivilege -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).collect(Collectors.toList());
        matchPolicyItems.forEach(policyItem -> {
            if (!policyItem.getRoles().contains(ownerRoleName)) {
                policyItem.getRoles().add(ownerRoleName);
            }
        });
        this.ownerPrivileges.stream().filter(ownerPrivilege -> matchPolicyItems.stream().noneMatch(policyItem -> policyItem.getAccesses().stream().anyMatch(policyItemAccess -> ownerPrivilege.equalsTo(policyItemAccess.getType())))).forEach(ownerPrivilege -> {
            RangerPolicy.RangerPolicyItem policyItem = new RangerPolicy.RangerPolicyItem();
            policyItem.getAccesses().add(new RangerPolicy.RangerPolicyItemAccess(ownerPrivilege.getName()));
            if (!policyItem.getRoles().contains(ownerRoleName)) {
                policyItem.getRoles().add(ownerRoleName);
            }
            policy.getPolicyItems().add(policyItem);
        });
    }
}

