/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.credential.Credential;

public class S3SecretKeyCredential
implements Credential {
    public static final String S3_SECRET_KEY_CREDENTIAL_TYPE = "s3-secret-key";
    public static final String GRAVITINO_S3_STATIC_ACCESS_KEY_ID = "s3-access-key-id";
    public static final String GRAVITINO_S3_STATIC_SECRET_ACCESS_KEY = "s3-secret-access-key";
    private final String accessKeyId;
    private final String secretAccessKey;

    public S3SecretKeyCredential(String accessKeyId, String secretAccessKey) {
        Preconditions.checkNotNull((Object)accessKeyId, (Object)"S3 access key Id should not null");
        Preconditions.checkNotNull((Object)secretAccessKey, (Object)"S3 secret access key should not null");
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

    @Override
    public String credentialType() {
        return S3_SECRET_KEY_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return 0L;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder().put((Object)GRAVITINO_S3_STATIC_ACCESS_KEY_ID, (Object)this.accessKeyId).put((Object)GRAVITINO_S3_STATIC_SECRET_ACCESS_KEY, (Object)this.secretAccessKey).build();
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }
}

