/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.ops;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.gravitino.iceberg.common.IcebergCatalogBackend;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.common.utils.IcebergCatalogUtil;
import org.apache.gravitino.utils.IsolatedClassLoader;
import org.apache.gravitino.utils.MapUtils;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableOps
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(IcebergTableOps.class);
    protected Catalog catalog;
    private SupportsNamespaces asNamespaceCatalog;
    private final IcebergCatalogBackend catalogBackend;
    private String catalogUri = null;
    private Map<String, String> catalogConfigToClients;
    private static final Set<String> catalogPropertiesToClientKeys = ImmutableSet.of((Object)"io-impl", (Object)"client.region", (Object)"s3.access-key-id", (Object)"s3.secret-access-key", (Object)"s3.endpoint");

    public IcebergTableOps(IcebergConfig icebergConfig) {
        this.catalogBackend = IcebergCatalogBackend.valueOf(((String)icebergConfig.get(IcebergConfig.CATALOG_BACKEND)).toUpperCase(Locale.ROOT));
        if (!IcebergCatalogBackend.MEMORY.equals((Object)this.catalogBackend)) {
            icebergConfig.get(IcebergConfig.CATALOG_WAREHOUSE);
            this.catalogUri = (String)icebergConfig.get(IcebergConfig.CATALOG_URI);
        }
        this.catalog = IcebergCatalogUtil.loadCatalogBackend(this.catalogBackend, icebergConfig);
        if (this.catalog instanceof SupportsNamespaces) {
            this.asNamespaceCatalog = (SupportsNamespaces)this.catalog;
        }
        this.catalogConfigToClients = MapUtils.getFilteredMap(icebergConfig.getIcebergCatalogProperties(), key -> catalogPropertiesToClientKeys.contains(key));
    }

    public IcebergTableOps() {
        this(new IcebergConfig(Collections.emptyMap()));
    }

    private void validateNamespace(Optional<Namespace> namespace) {
        namespace.ifPresent(n -> Preconditions.checkArgument((!n.toString().isEmpty() ? 1 : 0) != 0, (Object)"Namespace couldn't be empty"));
        if (this.asNamespaceCatalog == null) {
            throw new UnsupportedOperationException("The underlying catalog doesn't support namespace operation");
        }
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        this.validateNamespace(Optional.of(request.namespace()));
        return CatalogHandlers.createNamespace((SupportsNamespaces)this.asNamespaceCatalog, (CreateNamespaceRequest)request);
    }

    public void dropNamespace(Namespace namespace) {
        this.validateNamespace(Optional.of(namespace));
        CatalogHandlers.dropNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace);
    }

    public GetNamespaceResponse loadNamespace(Namespace namespace) {
        this.validateNamespace(Optional.of(namespace));
        return CatalogHandlers.loadNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace);
    }

    public ListNamespacesResponse listNamespace(Namespace parent) {
        this.validateNamespace(Optional.empty());
        return CatalogHandlers.listNamespaces((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)parent);
    }

    public UpdateNamespacePropertiesResponse updateNamespaceProperties(Namespace namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        this.validateNamespace(Optional.of(namespace));
        return CatalogHandlers.updateNamespaceProperties((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace, (UpdateNamespacePropertiesRequest)updateNamespacePropertiesRequest);
    }

    public LoadTableResponse registerTable(Namespace namespace, RegisterTableRequest request) {
        return CatalogHandlers.registerTable((Catalog)this.catalog, (Namespace)namespace, (RegisterTableRequest)request);
    }

    public LoadTableResponse createTable(Namespace namespace, CreateTableRequest request) {
        request.validate();
        if (request.stageCreate()) {
            return this.injectTableConfig(() -> CatalogHandlers.stageTableCreate((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
        }
        return this.injectTableConfig(() -> CatalogHandlers.createTable((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
    }

    public void dropTable(TableIdentifier tableIdentifier) {
        CatalogHandlers.dropTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier);
    }

    public void purgeTable(TableIdentifier tableIdentifier) {
        CatalogHandlers.purgeTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier);
    }

    public LoadTableResponse loadTable(TableIdentifier tableIdentifier) {
        return this.injectTableConfig(() -> CatalogHandlers.loadTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier));
    }

    public boolean tableExists(TableIdentifier tableIdentifier) {
        return this.catalog.tableExists(tableIdentifier);
    }

    public ListTablesResponse listTable(Namespace namespace) {
        return CatalogHandlers.listTables((Catalog)this.catalog, (Namespace)namespace);
    }

    public void renameTable(RenameTableRequest renameTableRequest) {
        CatalogHandlers.renameTable((Catalog)this.catalog, (RenameTableRequest)renameTableRequest);
    }

    public LoadTableResponse updateTable(TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        return CatalogHandlers.updateTable((Catalog)this.catalog, (TableIdentifier)tableIdentifier, (UpdateTableRequest)updateTableRequest);
    }

    public LoadTableResponse updateTable(IcebergTableChange icebergTableChange) {
        Transaction transaction = icebergTableChange.getTransaction();
        transaction.commitTransaction();
        return this.loadTable(icebergTableChange.getTableIdentifier());
    }

    @Override
    public void close() throws Exception {
        if (this.catalog instanceof AutoCloseable) {
            ((AutoCloseable)this.catalog).close();
        }
        if (this.catalogUri != null && this.catalogUri.contains("mysql")) {
            this.closeMySQLCatalogResource();
        } else if (this.catalogUri != null && this.catalogUri.contains("postgresql")) {
            this.closePostgreSQLCatalogResource();
        } else if (this.catalogBackend.equals((Object)IcebergCatalogBackend.HIVE)) {
            // empty if block
        }
    }

    private void closeMySQLCatalogResource() {
        try {
            Class.forName("com.mysql.cj.jdbc.AbandonedConnectionCleanupThread").getMethod("uncheckedShutdown", new Class[0]).invoke(null, new Object[0]);
            LOG.info("AbandonedConnectionCleanupThread has been shutdown...");
            this.closeDriverLoadedByIsolatedClassLoader(this.catalogUri);
        }
        catch (Exception e) {
            LOG.warn("Failed to shutdown AbandonedConnectionCleanupThread or deregister MySQL driver", (Throwable)e);
        }
    }

    private void closeDriverLoadedByIsolatedClassLoader(String uri) {
        try {
            Driver driver = DriverManager.getDriver(uri);
            if (driver.getClass().getClassLoader().getClass() == IsolatedClassLoader.CUSTOM_CLASS_LOADER_CLASS) {
                DriverManager.deregisterDriver(driver);
                LOG.info("Driver {} has been deregistered...", (Object)driver);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to deregister driver", (Throwable)e);
        }
    }

    private void closePostgreSQLCatalogResource() {
        this.closeDriverLoadedByIsolatedClassLoader(this.catalogUri);
    }

    private LoadTableResponse injectTableConfig(Supplier<LoadTableResponse> supplier) {
        LoadTableResponse loadTableResponse = supplier.get();
        return LoadTableResponse.builder().withTableMetadata(loadTableResponse.tableMetadata()).addAllConfig(this.getCatalogConfigToClient()).build();
    }

    private Map<String, String> getCatalogConfigToClient() {
        return this.catalogConfigToClients;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public static final class IcebergTableChange {
        private TableIdentifier tableIdentifier;
        private Transaction transaction;

        public IcebergTableChange(TableIdentifier tableIdentifier, Transaction transaction) {
            this.tableIdentifier = tableIdentifier;
            this.transaction = transaction;
        }

        public TableIdentifier getTableIdentifier() {
            return this.tableIdentifier;
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public void setTableIdentifier(TableIdentifier tableIdentifier) {
            this.tableIdentifier = tableIdentifier;
        }

        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }
    }
}

